/************************************************************************/
/*									*/
/*		stemutil.c						*/
/*									*/
/*	Utility menuing routines					*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "stem_local.h"
#include <biokeys.h>
#include <bpiokeys.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <sys/stat.h>




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MAX_FILES	1024



/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	Integer 	data_compare();





/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


static	String		cmd;




/************************************************************************/
/*									*/
/*	STEM_util_init -- module initialization 			*/
/*									*/
/************************************************************************/


void
STEM_util_init()
{
   cmd = NULL;

   BIOset_mapping(NULL,FKEY(BPIO_KEY_PRINT),BIO_MAP_ACTION,STEMutil_print,NULL);
   BIOset_mapping(NULL,FKEY_UP(BPIO_KEY_PRINT),BIO_MAP_NONE,NULL,NULL);
};





/************************************************************************/
/*									*/
/*	STEMutil_print -- handle printing key request			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

void
STEMutil_print(data,w,x,y)
   Integer data;
   ASH_WINDOW w;
   Integer x,y;
{
   String menu[64];
   Character file[128],printer[128],header[128],trailer[128],device[128];
   Character buf[512],wdopt[256],propt[256];
   Integer typ,pfg,sfg,chfg,cvfg,scale,mode,rv,brdrs;
   Integer ct,pid;
   String s,sh;
   ASH_WINDOW p;
   float wd,ht,left,top;

   if (cmd != NULL) {
      sh = getenv("SHELL");
      if (sh == NULL) sh = "/bin/csh";
      if ((pid = vfork()) == 0) {
	 execl(sh,"sh","-c",cmd,0);
	 _exit(127);
       };

      SFREE(cmd);
      cmd = NULL;

      while (getpgrp(pid) > 0) {
	 CMPXselect(0);
       };

      return;
    };

   ct = 0;
   menu[ct++] = "%CSave/Print Window\n";

   pfg = 1;
   sfg = 1;
   menu[ct++] = "%3o Print%M%4o Save\n";

   file[0] = 0;
   menu[ct++] = "File:    %0.48t\n";

   s = (String) getenv("PRINTER");
   if (s == NULL) printer[0] = 0;
   else strcpy(printer,s);
   menu[ct++] = "Printer:      %1.16t";

   strcpy(device,"ps");
   menu[ct++] = "Device:  %16.16t\n";

   typ = 1;
   menu[ct++] = "Window:  %2.0o Current%M%2.1o Root of Current";
   menu[ct++] = "         %2.2o Parent of Current%M%2.3o Screen\n";

   wd = 0.0;
   ht = 0.0;
   menu[ct++] = "Size:    %5.8g wide X %6.8g high\n";
   scale = 0;
   menu[ct++] = "Scale:   %11.0o To fit       %11.1o By 1       %11.2o By 2";
   menu[ct++] = "         %11.3o By 3         %11.4o By 4       %11.5o By 5";
   menu[ct++] = "         Other: %11.6d\n";
   mode = 0;
   menu[ct++] = "Mode:    %14.1o Landscape    %14.2o Portrait   %14.0o Either";

   rv = 0;
   menu[ct++] = "         %15o Reverse Video";
   brdrs = 1;
   menu[ct++] = "         %17o Borders\n";

   left = 0.0;
   top = 0.0;
   chfg = TRUE;
   cvfg = TRUE;
   menu[ct++] = "Margins: %7.8g left X %8.8g top";
   menu[ct++] = "         %9o Centered Horizontal%M%10o Centered Vertical\n";

   header[0] = 0;
   menu[ct++] = "Header:  %12.48t";
   trailer[0] = 0;
   menu[ct++] = "Trailer: %13.48t\n";

   menu[ct++] = "Hit the PRINT key again to activate when ready\n";

   menu[ct++] = "   %a%M   %c";

   menu[ct] = 0;

   if (!STEMdialog(w,menu,file,printer,&typ,&pfg,&sfg,&wd,&ht,&left,&top,&chfg,&cvfg,
		      &scale,header,trailer,&mode,&rv,device,&brdrs))
      return;

   if (file[0] == 0) sfg = FALSE;

   if (!sfg && !pfg) return;

   sprintf(wdopt,"-display %s",ASHinq_display_name(w));

   switch (typ) {
      case 0 :
	 break;
      case 1 :
	 while ((p = ASHinq_parent(w)) != NULL) w = p;
	 break;
      case 2 :
	 if ((p = ASHinq_parent(w)) != NULL) w = p;
	 break;
      case 3 :
	 w = NULL;
	 break;
    };

   if (w == NULL) strcat(wdopt," -root");
   else {
      sprintf(buf," -id %d",ASHinq_X_window(w));
      strcat(wdopt,buf);
    };

   if (!brdrs || w == NULL) {
      strcat(wdopt," -nobdrs");
    };

   propt[0] = 0;
   if (device[0] != 0) {
      sprintf(buf,"-device %s ",device);
      strcat(propt,buf);
    };
   if (printer[0] != 0) {
      sprintf(buf,"-P%s ",printer);
      strcat(propt,buf);
    };
   if (wd != 0) {
      sprintf(buf,"-width %g ",wd);
      strcat(propt,buf);
    };
   if (ht != 0) {
      sprintf(buf,"-height %g ",ht);
      strcat(propt,buf);
    };
   if (left != 0 || !chfg) {
      sprintf(buf,"-left %g ",left);
      strcat(propt,buf);
    };
   if (top != 0 || !cvfg) {
      sprintf(buf,"-top %g ",top);
      strcat(propt,buf);
    };
   if (scale != 0) {
      sprintf(buf,"-scale %d ",scale);
      strcat(propt,buf);
    };
   if (header[0] != 0) {
      sprintf(buf,"-header '%s' ",header);
      strcat(propt,buf);
    };
   if (trailer[0] != 0) {
      sprintf(buf,"-trailer '%s' ",trailer);
      strcat(propt,buf);
    };
   if (mode == 1) strcat(propt,"-landscape ");
   if (mode == 2) strcat(propt,"-portrait ");
   if (rv) strcat(propt,"-rv ");

   if (!sfg) {
      sprintf(buf,"xdpr %s %s",wdopt,propt);
    }
   else if (!pfg) {
      sprintf(buf,"xwd %s -out %s",wdopt,file);
    }
   else {
      sprintf(buf,"xwd %s -out %s; xdpr %s %s",wdopt,file,propt,file);
    };

   cmd = SALLOC(buf);
};





/************************************************************************/
/*									*/
/*	STEMutil_get_file -- get file from directory			*/
/*									*/
/************************************************************************/


static	String	ignorefiles[] = {
   "bBACKUP",
   "bCONTROL",
   "bBUFFERS",
   "core",
   0
};





char *
STEMutil_get_file(w,prmpt,directory,sfx,dirfg,alt,nbuf)
   ASH_WINDOW w;
   String prmpt;
   String directory;
   String sfx;
   Integer dirfg;
   String alt;
   String nbuf;
{
   STEM_DIALOG_LIST sdl;
   String files[MAX_FILES+3];
   struct direct * dp;
   DIR *df;
   Integer i,ct,base;
   String s,p;
   Character buf[256];
   Character menu[1024];
   struct stat info;

   if (directory == NULL) directory = ".";

   df = opendir(directory);
   if (df == NULL) return NULL;

   ct = 1;
   while ((dp = readdir(df)) != NULL) {
      if (dp->d_name[0] == '.') continue;
      if (dp->d_name[0] == '#') continue;
      for (i = 0; ignorefiles[i] != NULL; ++i) {
	 if (STREQL(dp->d_name,ignorefiles[i])) break;
       };
      if (ignorefiles[i] != NULL) continue;
      if (sfx != NULL) {
	 s = rindex(dp->d_name,'.');
	 if (s == NULL) s = ".";
	 i = strlen(s);
	 for (p = sfx; *p != 0; ++p) {
	    if (*p == '.' && strncmp(p,s,i) == 0 && p[i] == '.') break;
	  };
	 if (*p == 0) continue;
       };
      sprintf(buf,"%s/%s",directory,dp->d_name);
      if (stat(buf,&info) < 0) continue;
      if (dirfg >= 0) {
	 if (dirfg && (info.st_mode & S_IFDIR) == 0) continue;
	 if (!dirfg && (info.st_mode & S_IFDIR) != 0) continue;
       };
      if (info.st_mode & S_IFDIR) {
	 sprintf(buf,"%s/",dp->d_name);
	 s = buf;
       }
      else s = dp->d_name;
      files[ct++] = SALLOC(s);
    };

   if (ct > 2) {
      qsort(&files[1],ct-1,sizeof(String),data_compare);
    };
   files[0] = alt;
   files[ct] = NULL;

   base = (alt == NULL ? 1 : 0);
   sdl.choice = 0;
   sdl.btns = &files[base];
   buf[0] = 0;

   if (prmpt == NULL) prmpt = "Select File";

   i = ct-base;
   if (i == 0) {
      sprintf(menu,"%%C%s\n\nName: %%0.32t\n\n%%a%%M   %%c",prmpt);
    }
   if (i <= 4) {
      sprintf(menu,"%%C%s\n\nName: %%0.32t\n\n   %%1.32.%dl\n\n   %%a%%M   %%c",
		 prmpt,i*2+1);
    }
   else if (i <= 8) {
      sprintf(menu,"%%C%s\n\nName: %%0.48t\n\n   %%1.48.9l\n\n   %%a%%M   %%c",prmpt);
    }
   else
      sprintf(menu,"%%C%s\n\nName: %%0.48t\n\n   %%1.48.16l\n\n   %%a%%M   %%c",prmpt);

   if (!STEMdialog1(w,menu,buf,&sdl)) nbuf[0] = 0;
   else {
      if (buf[0] != 0 && sdl.choice != 0) buf[0] = 0;
      else if (buf[0] != 0) strcpy(nbuf,buf);
      else if (files[base+sdl.choice] != NULL) strcpy(nbuf,files[base+sdl.choice]);
      else nbuf[0] = 0;
    };

   for (i = 1; i < ct; ++i) SFREE(files[i]);

   if (nbuf[0] == 0) return NULL;

   return nbuf;
};





static Integer
data_compare(sa,sb)
   String * sa;
   String * sb;
{
   return strcmp(*sa,*sb);
};






/* end of stemutil.c */
