/************************************************************************/
/*									*/
/*		stemmain.c						*/
/*									*/
/*	Main module for STEM menu package				*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#define STEM_MAIN

#include "stem_local.h"






/************************************************************************/
/*									*/
/*	Variable definitions						*/
/*									*/
/************************************************************************/


	Boolean 	STEM__initedflag = FALSE;
	Integer 	STEM__tracelvl = 0;

	PROT_DECL;




/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


#ifdef	LIB
static			stem_cleanup();
#endif




/************************************************************************/
/*									*/
/*	STEMinit -- initialize the module				*/
/*									*/
/************************************************************************/


void
STEMinit()
{
   ITRACE("STEMinit");

   PROT_INIT;
   PROTECT;
   if (!STEM__initedflag) {
#ifdef LIB
      BROWNregister_cleanup(stem_cleanup);
#endif
      STEM__initedflag = TRUE;

      STEM_btn_init();
      STEM_3d_init();
      STEM_simple_init();
      STEM_2d_init();

      STEM_menu_init();
      STEM_scroll_init();
      STEM_pdm_init();
      STEM_dialog_init();
      STEM_state_init();
      STEM_pop_init();
      STEM_panel_init();
      STEM_util_init();
    };
   UNPROTECT;
};





#ifdef LIB
static
stem_cleanup()
{
   STEM__tracelvl = 0;
   STEM__initedflag = 0;
};
#endif





/************************************************************************/
/*									*/
/*	STEMtrace -- set tracing level					*/
/*									*/
/************************************************************************/


void
STEMtrace(lvl)
   Integer lvl;
{
   STEM__tracelvl = lvl;
};






/************************************************************************/
/*									*/
/*	STEM_trace -- output trace information				*/
/*									*/
/************************************************************************/


void
STEM_trace(msg,a1,a2,a3,a4,a5,a6,a7,a8,a9)
   String msg;
   Integer a1,a2,a3,a4,a5,a6,a7,a8,a9;
{
   Character mbf[1024];

   sprintf(mbf,msg,a1,a2,a3,a4,a5,a6,a7,a8,a9);

   printf("STEM: %s\n",mbf);
};






/************************************************************************/
/*									*/
/*	STEM_error -- handle error condition for STEM		       */
/*									*/
/************************************************************************/


void
STEM_error(msg)
   String msg;
{
   fprintf(stderr,"STEM: ERROR: %s\n",msg);
   fflush(stderr);
};





/* end of stemmain.c */
