/************************************************************************/
/*									*/
/*		stem_local.h						*/
/*									*/
/*	Local definitions for the STEM steady menu package		*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#define PROT_NAME	STEM__sema
#include <bwethread.h>

#include <X11/Xlib.h>

#include <DATATYPES.h>
#include <sequence.h>
#include <stem.h>
#include <ash.h>
#include <rip.h>
#include <bio.h>
#include <help.h>
#include <cmpx.h>





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Data types							*/
/*									*/
/************************************************************************/


typedef struct _STEM_BTN_STYLE *	STEM_BTN_STYLE;


typedef struct _STEM_BTN {
   ASH_WINDOW window;
   Integer lx,by,rx,ty;
   Integer blx,bby,brx,bty;
   Integer xdl,ydl;
   String text;
   ASH_COLOR fg,bg,gray,oncol,selcol;
   Boolean fill;
   Boolean refresh;
   Boolean resize;
   Boolean status;
   Boolean select;
   Boolean hilite;
   Boolean enable;
   Boolean drawn;
   Boolean center;
   Boolean fullsize;
   Boolean left;
   Boolean nofill;
   Boolean dummy;
   ASH_FONT font;
   Integer gray_size;
   ASH_SENSE_TYPE sense;
   Function_Ptr rtn;
   Universal data;
   RIP_REGION rgn;
   ASH_SENSE sensebox;
   String id;
   STEM_BTN_STYLE style;
   Integer fill_style;
} STEM_BTN_INFO;





/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


extern	Boolean 	STEM__initedflag;





/************************************************************************/
/*									*/
/*	Tracing Definitions						*/
/*									*/
/************************************************************************/

extern	Integer 	STEM__tracelvl;

#define TRACE if (STEM__tracelvl & STEM_TRACE_ON) STEM_trace
#define ITRACE if (STEM__tracelvl & STEM_TRACE_INT) STEM_trace
#define DTRACE if (STEM__tracelvl & STEM_TRACE_DBG) STEM_trace

#define ERROR(m) STEM_error(m)
#define FATAL(m) { ERROR(m); ABORT; }
#define ABORT	 abort()

#define CHECKINIT if (!STEM__initedflag) STEMinit();
#define ENTER	CHECKINIT; TRACE




/************************************************************************/
/*									*/
/*	Module symbols							*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Internal entries						*/
/*									*/
/************************************************************************/


extern	void		STEMinit();
extern	void		STEM_trace();
extern	void		STEM_error();

extern	void		STEM_menu_init();

extern	void		STEM_scroll_init();

extern	void		STEM_pdm_init();

extern	void		STEM_pop_init();

extern	void		STEM_state_init();

extern	void		STEM_dialog_init();

extern	void		STEM_panel_init();

extern	void		STEM_btn_init();
extern	void		STEM_btn_define_style();
extern	Integer 	STEM_btn_size_string();
extern	void		STEM_btn_draw_string();

extern	void		STEM_util_init();

extern	void		STEM_3d_init();
extern	void		STEM_2d_init();
extern	void		STEM_simple_init();




/* end of stem_local.h */

