/************************************************************************/
/*									*/
/*		stem.h							*/
/*									*/
/*	External definitions for the STEM steady menu package		*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "biokeys.h"



/************************************************************************/
/*									*/
/*	Data types -- sticky menus					*/
/*									*/
/************************************************************************/


typedef struct _STEM_BUTTON {
   char *	name;
   int		flags;
} STEM_BUTTON;


#define STEM_FLAG_NORMAL	0		/* normal text display	*/
#define STEM_FLAG_LOLITE	0x1		/* use half-tone font	*/
#define STEM_FLAG_CHOICE	0x2		/* item is selected	*/
#define STEM_FLAG_ONECOL	0x4		/* only use one column	*/





/************************************************************************/
/*									*/
/*	Data types -- pull-down menus					*/
/*									*/
/************************************************************************/


typedef int STEM_PDM_STATE;

#define STEM_PSTATE_END 		0
#define STEM_PSTATE_MENU		1
#define STEM_PSTATE_MENU_DISABLE_OLD	2
#define STEM_PSTATE_BTN 		3
#define STEM_PSTATE_BTN_DISABLE_OLD	4
#define STEM_PSTATE_BTN_SELECT_OLD	5
#define STEM_PSTATE_INFO		6
#define STEM_PSTATE_IGNORE		7

#define STEM_PSTATE_MENU_DISABLE	(STEM_PSTATE_MENU|STEM_PSTATE_DISABLE)
#define STEM_PSTATE_BTN_DISABLE 	(STEM_PSTATE_BTN|STEM_PSTATE_DISABLE)
#define STEM_PSTATE_BTN_SELECT		(STEM_PSTATE_BTN|STEM_PSTATE_SELECT)


#define STEM_PSTATE_TYPE		0x0f
#define STEM_PSTATE_FLAGS		0xfffffff0

#define STEM_PSTATE_COMPLEX		0x10
#define STEM_PSTATE_SIMPLE		0x20
#define STEM_PSTATE_DISABLE		0x100
#define STEM_PSTATE_SELECT		0x200
#define STEM_PSTATE_RIPOFF		0x400
#define STEM_PSTATE_NO_RIPOFF		0x800
#define STEM_PSTATE_COLORS		0xf000
#define STEM_PSTATE_COLOR(i)		((((i)+1))*0x1000)
#define STEM_PSTATE_INQ_COLOR(x)	((((x) & STEM_PSTATE_COLORS)/0x1000)-1)

#define STEM_PSTATE_CHAR_FIELD		0x1ff0000
#define STEM_PSTATE_CHAR(c)		(FKEY_ASCII(c)*0x10000)
#define STEM_PSTATE_META_CHAR(c)	(FKEY_META(c)*0x10000)
#define STEM_PSTATE_FCT_KEY(c)		(FKEY(c)*0x10000)
#define STEM_PSTATE_SHIFT_KEY(c)	(FKEY_SHIFT(c)*0x10000)
#define STEM_PSTATE_CTRL_KEY(c) 	(FKEY_CTRL(c)*0x10000)
#define STEM_PSTATE_INQ_CHAR(x) 	(((x) & STEM_PSTATE_CHAR_FIELD)/0x10000)





typedef struct _STEM_PDM_DATA {
   STEM_PDM_STATE state;
   char *	  name;
#ifndef __cplusplus
   int		  (*routine)();
#else
   int		  (*routine)(int,char*,char*,ASH_WINDOW);
#endif
} STEM_PDM_DATA;





/************************************************************************/
/*									*/
/*	Data types -- pop up menus					*/
/*									*/
/************************************************************************/


typedef enum {
   STEM_POP_STATE_END,
   STEM_POP_STATE_PANEL,
   STEM_POP_STATE_BUTTON,
   STEM_POP_STATE_DISABLE,
   STEM_POP_STATE_SELECT,
   STEM_POP_STATE_DIS_SEL
} STEM_POP_STATE;


typedef struct _STEM_POP_DATA {
   STEM_POP_STATE   state;
   char *	    name;
#ifndef __cplusplus
   int		    (*routine)();
#else
   int		    (*routine)(int,char*,char*,char*);
#endif
   char *	    invoke;
} STEM_POP_DATA;





/************************************************************************/
/*									*/
/*	Data types -- dialog boxes					*/
/*									*/
/************************************************************************/


typedef struct _STEM_DIALOG_LIST {
   int		choice;
   char **	btns;
} STEM_DIALOG_LIST;




/************************************************************************/
/*									*/
/*	Data types -- 3D buttons					*/
/*									*/
/************************************************************************/


typedef struct _STEM_BTN *	STEM_BTN;



typedef int	STEM_BTN_FLAGS;
#define STEM_BTN_REFRESH	0x1
#define STEM_BTN_NO_REFRESH	0x2
#define STEM_BTN_DEFAULT	0x4
#define STEM_BTN_SENSE_INOUT	0x8
#define STEM_BTN_SENSE_FLIP	0x10
#define STEM_BTN_NO_DRAW	0x20
#define STEM_BTN_FULL_SIZE	0x40
#define STEM_BTN_LEFT		0x80
#define STEM_BTN_NO_FILL	0x100
#define STEM_BTN_WINDOW_FONT	0x200
#define STEM_BTN_DEFAULT_COLORS 0x400

#define STEM_BTN_DEFAULT_FONT	((ASH_FONT) (-1))	/* for STEMbtn_size */





/************************************************************************/
/*									*/
/*	Data types -- panels						*/
/*									*/
/************************************************************************/


typedef struct _STEM_PANEL_BTN {
   char *    text;
   char *    color;
   long      data;
} STEM_PANEL_BTN;


typedef int	STEM_PANEL_FLAGS;
#define STEM_PANEL_SAME_SIZE	0x1






/************************************************************************/
/*									*/
/*	Entries 							*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	void		STEMmenu();
extern	void		STEMmenu_refresh();
extern	void		STEMmenu_colors();
extern	void		STEMmenu_remove();

extern	void		STEMscroll();
extern	void		STEMscroll_set();
extern	void		STEMscroll_thread();
extern	void		STEMscroll_color();

extern	void		STEMpdm_define();
extern	void		STEMpdm_menu_enable();
extern	void		STEMpdm_remove();
extern	void		STEMpdm_btn_enable();
extern	void		STEMpdm_btn_select();
extern	void		STEMpdm_menu_remove();
extern	void		STEMpdm_menu_add();
extern	void		STEMpdm_btn_remove();
extern	void		STEMpdm_btn_add();
extern	void		STEMpdm_fonts();
extern	char *		STEMpdm_help_info();

extern	int		STEMdialog();
extern	int		STEMdialog1();
extern	int		STEMdialog_array();
extern	int		STEMdialog1_array();
extern	int		STEMdialog_wait();
extern	int		STEMdialog1_wait();
extern	void		STEMdialog_mouse();
extern	void		STEMdialog_color();
extern	int		STEMdialog_edt_cmd();

extern	void		STEMstate();
extern	int		STEMstate_inq();
extern	void		STEMstate_set();
extern	void		STEMstate_color();
extern	void		STEMstate_remove();

extern	void		STEMpop_define();
extern	void		STEMpop_enable();
extern	void		STEMpop_remove();
extern	void		STEMpop_panel_add();
extern	void		STEMpop_panel_remove();
extern	void		STEMpop_panel_select();
extern	void		STEMpop_btn_enable();
extern	void		STEMpop_btn_select();
extern	void		STEMpop_btn_remove();
extern	void		STEMpop_btn_add();
extern	int		STEMpop_inq_size();
extern	int		STEMpop_inq_buttons();
extern	void		STEMpop_fonts();

extern	void		STEMpanel_define();
extern	void		STEMpanel_reset();

extern	STEM_BTN	STEMbtn_define();
extern	void		STEMbtn_background();
extern	void		STEMbtn_size();
extern	void		STEMbtn_size_style();
extern	void		STEMbtn_draw();
extern	void		STEMbtn_window_draw();
extern	void		STEMbtn_remove();
extern	void		STEMbtn_window_remove();
extern	void		STEMbtn_set();
extern	void		STEMbtn_hilite();
extern	void		STEMbtn_select();
extern	void		STEMbtn_enable();
extern	void		STEMbtn_set_gray();
extern	void		STEMbtn_set_select();
extern	void		STEMbtn_set_id();

extern	void		STEMutil_print();
extern	char *		STEMutil_get_file();

#else

extern "C" {
	void		STEMmenu(ASH_WINDOW ...);
	void		STEMmenu_refresh(ASH_WINDOW,STEM_BUTTON *);
	void		STEMmenu_colors(ASH_WINDOW);
	void		STEMmenu_remove(ASH_WINDOW);

	void		STEMscroll(ASH_WINDOW ...);
	void		STEMscroll_set(ASH_WINDOW,int,int,int,int);
	void		STEMscroll_thread(ASH_WINDOW ...);
	void		STEMscroll_color(char *);

	void		STEMpdm_define(ASH_WINDOW ...);
	void		STEMpdm_menu_enable(ASH_WINDOW,char *,int);
	void		STEMpdm_remove(ASH_WINDOW);
	void		STEMpdm_btn_enable(ASH_WINDOW,char *,char *,int);
	void		STEMpdm_btn_select(ASH_WINDOW,char *,char *,int);
	void		STEMpdm_menu_remove(ASH_WINDOW,char *);
	void		STEMpdm_menu_add(ASH_WINDOW,char *);
	void		STEMpdm_btn_remove(ASH_WINDOW,char *,char *);
	void		STEMpdm_btn_add(ASH_WINDOW,char *,char * ...);
	void		STEMpdm_fonts(ASH_WINDOW,int,int);
	char *		STEMpdm_help_info(ASH_WINDOW,int,int);

	int		STEMdialog(ASH_WINDOW,char ** ...);
	int		STEMdialog1(ASH_WINDOW,char * ...);
	int		STEMdialog_array(ASH_WINDOW,char ** ...);
	int		STEMdialog1_array(ASH_WINDOW,char * ...);
	int		STEMdialog_wait(ASH_WINDOW ...);
	int		STEMdialog1_wait(ASH_WINDOW ...);
	void		STEMdialog_mouse(int);
	void		STEMdialog_color(int,char *,char *);
	int		STEMdialog_edt_cmd(...);

	void		STEMstate(ASH_WINDOW,char * ...);
	int		STEMstate_inq(ASH_WINDOW,int);
	void		STEMstate_set(ASH_WINDOW,int,int);
	void		STEMstate_color(int,char *,char *);
	void		STEMstate_remove(ASH_WINDOW);

	void		STEMpop_define(ASH_WINDOW ...);
	void		STEMpop_enable(ASH_WINDOW,char *,int,int);
	void		STEMpop_remove(ASH_WINDOW,char *);
	void		STEMpop_panel_add(ASH_WINDOW,char *,char *,char *);
	void		STEMpop_panel_remove(ASH_WINDOW,char *,char *);
	void		STEMpop_panel_select(ASH_WINDOW,char *,char *);
	void		STEMpop_btn_enable(ASH_WINDOW,char *,char *,char *,int);
	void		STEMpop_btn_select(ASH_WINDOW,char *,char *,char *,int);
	void		STEMpop_btn_remove(ASH_WINDOW,char *,char *,char *);
	void		STEMpop_btn_add(ASH_WINDOW,char *,char *,char * ...);
	int		STEMpop_inq_size(ASH_WINDOW,char *);
	int		STEMpop_inq_buttons(ASH_WINDOW,char *,int,STEM_POP_DATA []);
	void		STEMpop_fonts(ASH_WINDOW,char *,int,int);

	void		STEMpanel_define(ASH_WINDOW,STEM_PANEL_BTN [] ...);
	void		STEMpanel_reset(ASH_WINDOW,STEM_PANEL_BTN []);

	STEM_BTN	STEMbtn_define(ASH_WINDOW,int,int,int,int,char *,int ...);
	void		STEMbtn_background(STEM_BTN,int,int,int,int);
	void		STEMbtn_size(...);
	void		STEMbtn_size_style(...);
	void		STEMbtn_draw(STEM_BTN);
	void		STEMbtn_window_draw(ASH_WINDOW);
	void		STEMbtn_remove(STEM_BTN);
	void		STEMbtn_window_remove(ASH_WINDOW);
	void		STEMbtn_set(STEM_BTN,int);
	void		STEMbtn_hilite(STEM_BTN,int);
	void		STEMbtn_select(STEM_BTN,int);
	void		STEMbtn_enable(STEM_BTN,int);
	void		STEMbtn_set_gray(STEM_BTN,ASH_COLOR);
	void		STEMbtn_set_select(STEM_BTN,ASH_COLOR);
	void		STEMbtn_set_id(STEM_BTN,char *);

	void		STEMutil_print(int,ASH_WINDOW,int,int);
	char *		STEMutil_get_file(ASH_WINDOW,char *,char *,char *,int,char *,char *);
};

#endif





/************************************************************************/
/*									*/
/*	Tracing Definitions						*/
/*									*/
/************************************************************************/


#ifndef __cplusplus
extern	void		STEMtrace();		/* establish tracing	*/
#else
extern	"C" void        STEMtrace(int);         /* establish tracing    */
#endif

#define STEM_TRACE_OFF	0		/* tracing off			*/
#define STEM_TRACE_ON	0x1		/* trace external entries	*/
#define STEM_TRACE_INT	0x2		/* trace internal entries	*/
#define STEM_TRACE_DBG	0x4		/* trace local routines 	*/





/* end of stem.h */
