/************************************************************************/
/*									*/
/*  rip_local.h:							*/
/*									*/
/*	include file for RIP.						*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#define PROT_NAME	RIP__sema
#include <bwethread.h>

#include "DATATYPES.h"
#include "ash.h"
#include "bio.h"
#include "biokeys.h"
#include "bpiokeys.h"
#include <help.h>
#include <cmpx.h>

#include "rip.h"




/************************************************************************/
/*									*/
/*  constants								*/
/*									*/
/************************************************************************/


#define EMPTY	""
#define EOS	'\0'
#define SPACE	' '

#define ESC	'\\'
#define DASH	'-'

#define fKEY	'f'
#define LKEY	'l'
#define RKEY	'r'
#define SKEY	's'

#define DOWN	'd'
#define SHIFT	's'
#define UP	'u'
#define CTRL	'c'

#define BS	'b'
#define CR	'c'
#define TAB	't'

#define FIELD_SIZE 0x10 		     /* number of virtual keys	*/

#define MAX_NUM_BTNS	16		     /* number of mouse comb's  */
#define MAX_NUM_CHARS	(FKEY_LAST+1)	     /* number of characters	*/
#define MAX_EVENTS	MAX_NUM_CHARS + MAX_NUM_BTNS + MAX_NUM_BTNS

#define CLEAR	0			     /* combination rule values */
#define SXORD	6
#define SET	15

#define INPUT_CURSOR	ASH_CURSOR_SMALL_XHAIRS

#define MAX_PTS 	99		     /* max pts to enter	*/
#define POLY_TLC	5		     /* dist from init pt to end*/
#define MAXINPUT	120		     /* max chars to enter	*/

#define NUM_AREAS	3		     /* number of areas 	*/

#define NOSTORAGE	"No more storage space available"
#define BADREGIONID	"Bad region id"
#define BADWNDWID	"Bad window id"
#define NOPREVINPUT	"No previous input to retrieve"

#define USE_BIO_MASK	BIO_MASK_ASCII | BIO_MASK_META | BIO_MASK_FKEY | \
			BIO_MASK_SHIFT_FKEY | BIO_MASK_CTRL_FKEY | \
			BIO_MASK_META_FKEY | BIO_MASK_UP_FKEY | BIO_MASK_MOVE | \
			BIO_MASK_BUTTON | BIO_MASK_BUTTON_UP | \
			BIO_MASK_SHIFT_BUTTON | BIO_MASK_TAP_BUTTON | \
			BIO_MASK_REDRAW | BIO_MASK_VISIBLE | BIO_MASK_VIEW

#define FLUSH_BIO_MASK	BIO_MASK_MOVE





/************************************************************************/
/*									*/
/*  data types								*/
/*									*/
/************************************************************************/


typedef struct _EVENTS {
   Short * events_ch;
   Integer events_btn;
   Boolean all_chars;
} EVENTS;



typedef struct _RIP_REGION {
    ASH_WINDOW window;			/* window assoc'd w/region      */
    Integer lx, by, rx, ty;		/* region dimensions		*/
    EVENTS events;			/* events region is sensitive to*/
    Function_Ptr rtn;			/* routine assoc'd w/region     */
    RIP_DATA data;			/* data assoc'd w/region        */
    String id;				/* id assoc'd w/ region         */
    ASH_SENSE_TYPE sense;		/* region sensitivity		*/
    Boolean enable;			/* region enabled?		*/
    Boolean whole_window;		/* region occupies whole window */
    ASH_SENSE area_id;			/* sensitive area id		*/
    RIP_REGION next;
    Boolean local_window;		/* use this window for points	*/
} RIP_REGION_B;



typedef struct _PICK {
    Integer x, y, btns;
    Integer ch;
} PICK;



typedef struct _INPUT {
    Integer filled, x, y, btns;
    Integer ch;
} INPUT;





/************************************************************************/
/*									*/
/*  global variables							*/
/*									*/
/************************************************************************/


extern	Boolean 	RIP__initialized;
extern	Integer 	RIP__trace_level;

extern	RIP_REGION	RIP__head;

extern	ASH_WINDOW	RIP__areas[NUM_AREAS];





/************************************************************************/
/*									*/
/*  macros								*/
/*									*/
/************************************************************************/



#define BTWN(x,a,b)	( ABS((a)-(b)) ==  (ABS((a)-(x)) + ABS((b)-(x))) )

#define POINTIN(x,y,lx,by,rx,ty)    (BTWN(x,lx,rx) && BTWN(y,by,ty))

#define POINTINR(x,y,r) POINTIN(x,y,r->lx,r->by,r->rx,r->ty)

#define RGNALLOC()	((RIP_REGION) malloc(sizeof(RIP_REGION_B)))

#define FREE(a) 	(free((char *) a))

#define CHECKINIT	if (!RIP__initialized) RIPinit()

#define ETRACE		if (RIP__trace_level & RIP_TRACE_EXTERNAL) RIP_trace
#define ITRACE		if (RIP__trace_level & RIP_TRACE_INTERNAL) RIP_trace

#define ERROR(a, b)	RIP_error(a, b)




/************************************************************************/
/*									*/
/*  functions								*/
/*									*/
/************************************************************************/


extern	int		atoi();
extern	double		atof();
extern	String		mktemp();

extern	void		RIP_region_init();

extern	void		RIP_pick_init();
extern	void		RIP_region_invalidate();
extern	RIP_TRANS	RIP_track_event();

extern	void		RIP_inout_init();
extern	RIP_TRANS	RIP_get_input();
extern	void		RIP_display_text();

extern	void		RIP_misc_init();
extern	void		RIP_trace();
extern	void		RIP_error();




/* end of rip_local.h */
