/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

#ifndef RIP_INCLUDED

/************************************************************************/
/*									*/
/*  rip.h:								*/
/*									*/
/*	include file for programs using RIP.				*/
/*  Assumes that ash.h has already been included.			*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*  constants								*/
/*									*/
/************************************************************************/


#define RIP_OK		1
#define RIP_BAD 	0

#define RIP_BAD_PTS	-1

	/* mouse button combinations */
	/*	   2^(value of pressed buttons) */
#define RIP_BTN_NONE	0x1

	/* single button */
#define RIP_BTN_LEFT_ONLY	0x2
#define RIP_BTN_MID_ONLY	0x4
#define RIP_BTN_RIGHT_ONLY	0x10
#define RIP_BTN_FOURTH_ONLY	0x100

	/* two buttons */
#define RIP_BTN_LEFT_MID	0x8
#define RIP_BTN_LEFT_RIGHT	0x20
#define RIP_BTN_LEFT_FOURTH	0x200
#define RIP_BTN_MID_RIGHT	0x40
#define RIP_BTN_MID_FOURTH	0x400
#define RIP_BTN_RIGHT_FOURTH	0x1000

	/* three buttons */
#define RIP_BTN_LEFT_MID_RIGHT		0x80
#define RIP_BTN_LEFT_MID_FOURTH 	0x800
#define RIP_BTN_LEFT_RIGHT_FOURTH	0x2000
#define RIP_BTN_MID_RIGHT_FOURTH	0x4000

	/* all four buttons */
#define RIP_BTN_ALL	0x8000

	/* prioritizing: any combination that includes one certain button */
#define RIP_BTN_LEFT	0xaaaa		/* 0xaaaa */
#define RIP_BTN_MID	0x4444		/* 0xcccc */
#define RIP_BTN_RIGHT	0x1010		/* 0xf0f0 */
#define RIP_BTN_FOURTH	0x0100		/* 0xff00 */

#define RIP_BTN_ANY	0xffff

	/* distinguishing btwn transitions */
#define RIP_BTN_DOWN	0x10000
#define RIP_BTN_UP	0x20000
#define RIP_BTN_EITHER	0x30000

#define RIP_BTN_SHIFT	0x100000
#define RIP_BTN_CTRL	0x200000
#define RIP_BTN_META	0x400000
#define RIP_BTN_EXTRA	0x700000

#define RIP_BTN_TAP	0x800000

	/* any of a certain transition */
#define RIP_BTN_ANY_DOWN	RIP_BTN_ANY | RIP_BTN_DOWN | RIP_BTN_EXTRA
#define RIP_BTN_ANY_UP		RIP_BTN_ANY | RIP_BTN_UP | RIP_BTN_EXTRA | RIP_BTN_TAP
#define RIP_BTN_ANY_TAP 	RIP_BTN_ANY | RIP_BTN_EXTRA | RIP_BTN_TAP
#define RIP_BTN_ANY_EITHER	RIP_BTN_ANY | RIP_BTN_EITHER | RIP_BTN_EXTRA | RIP_BTN_TAP
#define RIP_BTN_ANY_EXTRA	RIP_BTN_ANY | RIP_BTN_EXTRA

#define RIP_NO_CHARS	""
#define RIP_ALL_CHARS	"\001-\377"

#define RIP_TRACE_OFF		0x0
#define RIP_TRACE_EXTERNAL	0x1
#define RIP_TRACE_INTERNAL	0x2

#define RIP_AREA_STATUS 	0
#define RIP_AREA_PROMPT 	1
#define RIP_AREA_TYPEIN 	2





/************************************************************************/
/*									*/
/*  data types								*/
/*									*/
/************************************************************************/


typedef struct _RIP_REGION *RIP_REGION;

typedef int (*RIP_FNCT)();

typedef int RIP_DATA;

typedef enum {
    RIP_TRANS_NONE,
    RIP_TRANS_MOVE,
    RIP_TRANS_DOWN,
    RIP_TRANS_UP,
    RIP_TRANS_CHAR,
    RIP_TRANS_TAP
} RIP_TRANS;





/************************************************************************/
/*									*/
/*  region functions							*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	RIP_REGION	RIPdefine_region();
extern	void		RIPset_data();
extern	void		RIPset_sense();
extern	RIP_DATA	RIPinq_data();
extern	ASH_WINDOW	RIPinq_window();
extern	void		RIPset_region_id();
extern	char *		RIPinq_region_id();
extern	void		RIPuse_local_window();
extern	void		RIPremove_region();
extern	void		RIPremove_window_regions();
extern	char *		RIPhelp_info();

#else

extern "C" {
	RIP_REGION	RIPdefine_region(ASH_WINDOW,int,int,int,int,char *,int ...);
	void		RIPset_data(RIP_REGION ...);
	void		RIPset_sense(RIP_REGION,int);
	RIP_DATA	RIPinq_data(RIP_REGION);
	ASH_WINDOW	RIPinq_window(RIP_REGION);
	void		RIPset_region_id(RIP_REGION,char *);
	char *		RIPinq_region_id(RIP_REGION);
	void		RIPuse_local_window(RIP_REGION);
	void		RIPremove_region(RIP_REGION);
	void		RIPremove_window_regions(ASH_WINDOW);
	char *		RIPhelp_info(ASH_WINDOW,int,int);
};

#endif




/************************************************************************/
/*									*/
/*  picking/tracking functions						*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	void		RIPthread_init();
extern	ASH_WINDOW	RIPgrab_window();
extern	int		RIPtrack();
extern	void		RIPidler();
extern	int		RIPuser_pick();
extern	int		RIPuser_poll();
extern	RIP_REGION	RIPinq_region();

#else

extern "C" {
	void		RIPthread_init();
	ASH_WINDOW	RIPgrab_window(ASH_WINDOW);
	int		RIPtrack(...);
	void		RIPidler(int);
	int		RIPuser_pick(...);
	RIP_REGION	RIPinq_region(ASH_WINDOW,int,int,int,int,ASH_WINDOW);
};

#endif




/************************************************************************/
/*									*/
/*  input/output functions						*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	int		RIPinput_track();
extern	int		RIPinput_track_down();
extern	int		RIPinput_point();
extern	int		RIPinput_line();
extern	int		RIPinput_box();
extern	int		RIPinput_polygon();
extern	int		RIPinput_ival();
extern	int		RIPinput_rval();
extern	int		RIPinput_text();
extern	ASH_CURSOR	RIPset_tracking_cursor();

#else

extern "C" {
	int		RIPinput_track(ASH_WINDOW,char * ...);
	int		RIPinput_track_down(ASH_WINDOW,char * ...);
	int		RIPinput_point(ASH_WINDOW,char *,int *,int *);
	int		RIPinput_line(ASH_WINDOW,char *,int *,int *,int *,int *);
	int		RIPinput_box(ASH_WINDOW,char *,int *,int *,int *,int *);
	int		RIPinput_polygon(ASH_WINDOW,char *,int *,int [],int []);
	int		RIPinput_ival(char *,int *);
	int		RIPinput_rval(char *,double *);
	int		RIPinput_text(char *,char **);
	ASH_CURSOR	RIPset_tracking_cursor(ASH_CURSOR);
};

#endif




/************************************************************************/
/*									*/
/*  miscellaneous functions						*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	void		RIPinit();
extern	void		RIPtrace();
extern	void		RIPregister_clock();
extern	void		RIPstatus();
extern	void		RIPprompt();
extern	ASH_WINDOW	RIParea();
extern	ASH_WINDOW	RIPinq_area_window();

#else

extern "C" {
	void		RIPinit();
	void		RIPtrace(int);
	void		RIPregister_clock(...);
	void		RIPstatus(char *);
	void		RIPprompt(char *);
	ASH_WINDOW	RIParea(int,ASH_WINDOW);
	ASH_WINDOW	RIPinq_area_window(int);
};

#endif


#define RIP_INCLUDED
#endif




/* end of rip.h */
