/************************************************************************/
/*									*/
/*		SEQUENCE.H						*/
/*									*/
/*	This module contains a fast, general purpose list processing	*/
/*	package that is to be used in conjunction with IDL.		*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#ifndef SEQUENCE_DONE
#define SEQUENCE_DONE



#define Universal	int
#define Boolean 	char


/************************************************************************/
/*									*/
/*	Type definitions						*/
/*									*/
/************************************************************************/


typedef struct _Sequence *Sequence;	/* A list is a pointer to a list block	*/

typedef struct _Sequence {	/* A list block contains		*/
   Universal Lcar;		/*    data in its car			*/
   Sequence Lcdr;		/*    and a list as its cdr		*/
} SequenceB;





/************************************************************************/
/*									*/
/*	Basic List Processing Functions 				*/
/*									*/
/************************************************************************/


#define CAR(type,list)	((type)((list)->Lcar))
#define CDR(list)	((list)->Lcdr)
#define CONS(item,list) SEQcons((Universal)item,list)
#define CDDR(list)	CDR(CDR(list))
#define CDDDR(list)	CDR(CDDR(list))
#define CDDDDR(list)	CDR(CDDDR(list))
#define CADR(type,list) CAR(type,CDR(list))
#define CADDR(type,list) CAR(type,CDDR(list))
#define CADDDR(type,list) CAR(type,CDDDR(list))
#define CADDDDR(type,list) CAR(type,CDDDDR(list))
#define NTH(type,list,n) ((type)(SEQnth(list,n)))
#define NEW		SEQnew			/* construct a new list */
#define NEW0()		NULL
#define NEW1(x) 	SEQnewc(1,x)
#define NEW2(x,y)	SEQnewc(2,x,y)
#define NEW3(x,y,z)	SEQnewc(3,x,y,z)
#define NEW4(x,y,z,w)	SEQnewc(4,x,y,z,w)
#define NEW5(a,b,c,d,e) SEQnewc(5,a,b,c,d,e)
#define NEW6(a,b,c,d,e,f)	SEQnewc(6,a,b,c,d,e,f)
#define NEW7(a,b,c,d,e,f,g)	SEQnewc(7,a,b,c,d,e,f,g)
#define NEW8(a,b,c,d,e,f,g,h)	SEQnewc(8,a,b,c,d,e,f,g,h)
#define NEW9(a,b,c,d,e,f,g,h,i) SEQnewc(9,a,b,c,d,e,f,g,h,i)
#define APPEND(it,list) SEQappend((Universal)it,list)  /* append elt to list   */
#define EMPTY(list)	((list) == NULL)
#define MINUS(la,lb)	SEQminus(la,lb)
#define INTERSECT(a,b)	SEQinter(a,b)
#define CONC(la,lb)	SEQconc(la,lb)		/* append two lists	*/
#define UNION(la,lb)	SEQunion(la,lb)
#define REMOB(it,list)	SEQremob((Universal)it,list)/* remove item from list */
#define SAMESET(la,lb)	SEQsame(la,lb)
#define SAMELIST(la,lb) SEQequal(la,lb)
#define CONTAINED(la,lb) SEQcontain(la,lb)
#define NULLINTER(la,lb) SEQnullint(la,lb)
#define LFREE(list)	SEQfree(list)
#define CDRF(list)	SEQcdrf(list)		/* free car; return cdr */
#define MEMQ(item,list) SEQmemq((Universal)item,list)
#define REVERSE(list)	SEQreverse(list)
#define LCOPY(list)	SEQcopy(list)
#define LENGTH(list)	SEQlength(list)
#define RPLACA(l,v)	SEQrplaca(l,(Universal)v)
#define RPLACD(l,v)	SEQrplacd(l,v)

#define forin(var,type,lvar,list) for(var=NULL,lvar=(list); EMPTY(lvar)?((var=NULL),FALSE):((var=CAR(type,lvar)),TRUE); lvar=CDR(lvar))




/************************************************************************/
/*									*/
/*	External functions						*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	Universal   SEQnth();
extern	Sequence    SEQcons();
extern	Sequence    SEQnew();
extern	Sequence    SEQnewc();
extern	Sequence    SEQappend();
extern	Sequence    SEQminus();
extern	Sequence    SEQinter();
extern	Sequence    SEQconc();
extern	Sequence    SEQunion();
extern	Sequence    SEQremob();
extern	Boolean     SEQsame();
extern	Boolean     SEQequal();
extern	Boolean     SEQcontain();
extern	Boolean     SEQnullint();
extern		    SEQfree();
extern	Sequence    SEQcdrf();
extern	Boolean     SEQmemq();
extern	Sequence    SEQreverse();
extern	Sequence    SEQcopy();
extern	int	    SEQlength();
extern		    SEQprint();
extern	Sequence    SEQrplaca();
extern	Sequence    SEQrplacd();

#else

extern "C" {
	Universal   SEQnth(Sequence,int);
	Sequence    SEQcons(...);
	Sequence    SEQnew(...);
	Sequence    SEQnewc(int ...);
	Sequence    SEQappend(...);
	Sequence    SEQminus(Sequence,Sequence);
	Sequence    SEQinter(Sequence,Sequence);
	Sequence    SEQconc(Sequence,Sequence);
	Sequence    SEQunion(Sequence,Sequence);
	Sequence    SEQremob(...);
	Boolean     SEQsame(Sequence,Sequence);
	Boolean     SEQequal(Sequence,Sequence);
	Boolean     SEQcontain(Sequence,Sequence);
	Boolean     SEQnullint(Sequence,Sequence);
		    SEQfree(Sequence);
	Sequence    SEQcdrf(Sequence);
	Boolean     SEQmemq(...);
	Sequence    SEQreverse(Sequence);
	Sequence    SEQcopy(Sequence);
	int	    SEQlength(Sequence);
		    SEQprint(Sequence);
	Sequence    SEQrplaca(Sequence ...);
	Sequence    SEQrplacd(Sequence ...);
}

#endif



#undef	Universal
#undef	Boolean


#endif





/* end of sequence.h */









