/************************************************************************/
/*									*/
/*		libcalls.c						*/
/*									*/
/*	Miscellaneous library calls					*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#include "DATATYPES.h"
#include <stdio.h>



/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#ifndef PRO_DIRECTORY
#define PRO_DIRECTORY	"/pro"
#endif




/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


static	String		project = NULL;
static	String		arch = NULL;
static	String		local_project = NULL;
static	String		bwe_project = NULL;




/************************************************************************/
/*									*/
/*	BWE_libcalls_init -- module initialization			*/
/*									*/
/************************************************************************/


void
BWE_libcalls_init()
{
   project = NULL;
   arch = NULL;
   local_project = NULL;
   bwe_project = NULL;
};





/************************************************************************/
/*									*/
/*	BWEproject -- return project directory for general applications */
/*									*/
/************************************************************************/


char *
BWEproject()
{
   register String s;

   if (project != NULL) return project;

   s = (String) getenv("BWE_PRO");
   if (s == NULL) s = (String) getenv("PRO");

   if (s == NULL) s = PRO_DIRECTORY;

   project = s;

   return s;
};




/************************************************************************/
/*									*/
/*	BWEbwe_project -- return project directory for bwe		*/
/*									*/
/************************************************************************/


char *
BWEbwe_project()
{
   register String s;

   if (bwe_project != NULL) return bwe_project;

   s = (String)getenv("BWE");
   if (s == NULL) s = (String) getenv("PRO");

#ifndef BWE_DIRECTORY
   if (s == NULL) s = BWEproject();
#else
   if (s == NULL) s = BWE_DIRECTORY;
#endif

   bwe_project = s;

   return s;
};




/************************************************************************/
/*									*/
/*	BWEarch -- return current architecture string			*/
/*									*/
/************************************************************************/


char *
BWEarch()
{
   register String s;
   FILE * p;
   char abuf[256];
   extern FILE * popen();
   char fbuf[128];

   if (arch != NULL) return arch;

   s = (String)getenv("ARCH");

   if (s == NULL) {
#ifdef BWE_ARCH
      s = BWE_ARCH;
#else
      p = popen("arch","r");
      if (p != NULL) {
	 fgets(abuf,256,p);
	 pclose(p);
	 s = (char *) index(abuf,'\n');
	 if (s != NULL) *s = 0;
	 s = SALLOC(abuf);
       }
      else {
	 s = "";
       };
#endif
    };

   arch = s;

   return s;
};





/************************************************************************/
/*									*/
/*	BWElocal_project -- return local project name			*/
/*	BWEset_local_project -- set local project name			*/
/*									*/
/************************************************************************/


String
BWElocal_project()
{
   if (local_project == NULL) {
      local_project = BWEproject();
    }

   return local_project;
};




void
BWEset_local_project(s)
   String s;
{
   local_project = SALLOC(s);
};





/************************************************************************/
/*									*/
/*	BWEversion -- return/print version number of software		*/
/*		      negative value indicates working version		*/
/*									*/
/************************************************************************/


#ifndef BWE_VERSION
static double version_no = -1.0;
#else
static double version_no = BWE_VERSION;
#endif


double
BWEversion(fg)
   int fg;
{
   if (fg)
      if (version_no < 0.)
	 printf("Brown Workstation Environment -- working version\n");
      else
	 printf("Brown Workstation Environment -- version %.1lf\n", version_no);

   return version_no;
};





/* end of libcalls.c */
