/************************************************************************/
/*									*/
/*		hashsearch.h						*/
/*									*/
/*	Definitions for using BWE extensible hashing package		*/
/*									*/
/************************************************************************/
/*	Copyright 1990 Brown University -- Steven P. Reiss		*/


#include <search.h>

/************************************************************************/
/*									*/
/*	Search.h defines standard UNIX hashing stuff			*/
/*									*/
/************************************************************************/

/*	typedef struct entry { char *key, *data; } ENTRY;		*/
/*	typedef enum { FIND, ENTER } ACTION;				*/



/************************************************************************/
/*									*/
/*	Type definitions:  HASH_TABLE -- hash table			*/
/*									*/
/************************************************************************/


typedef struct _HASH_TABLE *	  HASH_TABLE;



/************************************************************************/
/*									*/
/*	Entry points							*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	HASH_TABLE		HASHcreate();
extern	void			HASHdestroy();
extern	ENTRY * 		HASHsearch();

#else

extern "C" {

	HASH_TABLE		HASHcreate(int);
	void			HASHdestroy(HASH_TABLE);
	ENTRY * 		HASHsearch(HASH_TABLE,ENTRY,ACTION);

}

#endif




/* end of hashsearch.h */
