/************************************************************************/
/*									*/
/*		bwethread.c					       */
/*								       */
/*	Entries to handle thread management within BWE		       */
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include <signal.h>
#include "DATATYPES.h"
#include "bwethread.h"
#include "bio.h"
#include "wind.h"



/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define START_STACK_SIZE	130000
#define START_DATA_SIZE 	(8*1024*1024)
#define START_NPROC		4




/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/






/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


extern	String		getenv();





/************************************************************************/
/*									*/
/*	BWEthread_begin -- begin threads while using BWE		*/
/*									*/
/************************************************************************/


void
BWEthread_begin(pr,ssz,nproc,dsize,rtn,arg)
   int pr,ssz;
   int nproc,dsize;
   Function_Ptr rtn;
   Universal arg;
{
   register String s;

   BWE_thread_init();
   BIOthread_init();
   WINDthread_init();
   RIPthread_init();

   THREADsetnononblockingio();

#ifdef OLD_THREADS
   THREADbegin(pr);
#else
   if (pr == 0) pr = 16;
   if (ssz == 0) {
      s = getenv("BWE_STACKSIZE");
      if (s != NULL) ssz = atol(s);
      if (ssz == 0) ssz = START_STACK_SIZE;
    };
   if (nproc == 0) {
      s = getenv("BWE_PARALLEL");
      if (s != NULL) nproc = atol(s);
      if (nproc == 0) nproc = START_NPROC;
    };
   if (dsize == 0) {
      s = getenv("BWE_DATASIZE");
      if (s != NULL) dsize = atol(s);
      if (dsize == 0) dsize = START_DATA_SIZE;
    };
   THREADgo(nproc,dsize,rtn,arg,0,ssz,pr);
#endif
};





/* end of bwethreadgo.c */
