/************************************************************************/
/*									*/
/*		bwethread.h						*/
/*									*/
/*	Include file for using threads					*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include <thread.h>		/* includes stdio.h			*/

#ifdef sun
#include <bwethreadsun.h>
#endif



/************************************************************************/
/*									*/
/*	The program should define the macro PROT_NAME as the name of	*/
/*	the semaphore associated with the current package.  This file	*/
/*	defines the necessary entries for protection with multiple	*/
/*	threads.							*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Type definitions						*/
/*									*/
/************************************************************************/


typedef struct _BWE_SEMA {
   SEMAPHORE	real_sema;
   THREAD	owner;
   int		count;
   struct _BWE_SEMA * next;
} BWE_SEMA;


#define USE_THREADS	(THREADcurrent != NULL)
#define BWE_NEW_SEMA()	BWEthread_semaphore(((BWE_SEMA *) calloc(1,sizeof(BWE_SEMA))))



#ifdef PROT_NAME

extern	BWE_SEMA	PROT_NAME;

#define PROT_DECL	BWE_SEMA	PROT_NAME = { 0,0,0 };

#define PROT_INIT	BWEthread_semaphore(&PROT_NAME)

#define PROT_USE	(PROT_NAME.real_sema != NULL)

#define PROTECT 	if (PROT_USE) BWEthread_protect(&PROT_NAME)

#define UNPROTECT	if (PROT_USE) BWEthread_unprotect(&PROT_NAME)

#endif




/************************************************************************/
/*									*/
/*	External entries						*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	void		BWEthread_begin();
extern	BWE_SEMA *	BWEthread_semaphore();
extern	void		BWEthread_protect();
extern	void		BWEthread_unprotect();
extern	void		BWEthread_unprotect_ok();
extern	void		BWEthread_reset();
extern	void		BWEthread_sema_remove();

#else

extern "C" {
	void		BWEthread_begin(int,int,int,int ...);
	BWE_SEMA *	BWEthread_semaphore(BWE_SEMA *);
	void		BWEthread_protect(BWE_SEMA *);
	void		BWEthread_unprotect(BWE_SEMA *);
	void		BWEthread_unprotect_ok(BWE_SEMA *);
	void		BWEthread_reset(THREAD);
	void		BWEthread_sema_remove(BWE_SEMA *);
};

#endif




/* end of bwethread.h */
