/************************************************************************/
/*									*/
/*		leafmain.c						*/
/*									*/
/*	Main module for LEAF window layout package			*/
/*									*/
/************************************************************************/
/*	Copyright 1985 Brown University -- Steven P. Reiss		*/


#define LEAF_MAIN

#include "leaf_local.h"






/************************************************************************/
/*									*/
/*	Variable definitions						*/
/*									*/
/************************************************************************/


	Boolean 	LEAF__initedflag = FALSE;
	Integer 	LEAF__tracelvl = 0;

	PROT_DECL;




/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


#ifdef	LIB
static			leaf_cleanup();
#endif




/************************************************************************/
/*									*/
/*	LEAF_init -- initialize the module				*/
/*									*/
/************************************************************************/


void
LEAF_init()
{
   ITRACE("LEAF_init");

   PROT_INIT;

   PROTECT;
   if (!LEAF__initedflag) {
#ifdef LIB
      BROWNregister_cleanup(leaf_cleanup);
#endif

      RIPinit();

      LEAF_layout_init();
      LEAF_draw_init();

      LEAF__initedflag = TRUE;
    };
   UNPROTECT;
};





#ifdef LIB
static
leaf_cleanup()
{
   LEAF__tracelvl = 0;
   LEAF__initedflag = 0;
};
#endif





/************************************************************************/
/*									*/
/*	LEAFtrace -- set tracing level					*/
/*									*/
/************************************************************************/


void
LEAFtrace(lvl)
   Integer lvl;
{
   LEAF__tracelvl = lvl;
};






/************************************************************************/
/*									*/
/*	LEAF_trace -- output trace information				*/
/*									*/
/************************************************************************/


void
LEAF_trace(msg,a1,a2,a3,a4,a5,a6,a7,a8,a9)
   String msg;
   Integer a1,a2,a3,a4,a5,a6,a7,a8,a9;
{
   Character mbf[1024];

   sprintf(mbf,msg,a1,a2,a3,a4,a5,a6,a7,a8,a9);

   printf("LEAF: %s\n",mbf);
};






/************************************************************************/
/*									*/
/*	LEAF_error -- handle error condition for LEAF		       */
/*									*/
/************************************************************************/


void
LEAF_error(msg)
   String msg;
{
   fprintf(stderr,"LEAF: ERROR: %s\n",msg);
   fflush(stderr);
};





/* end of leafmain.c */
