/************************************************************************/
/*									*/
/*		leaf_local.h						*/
/*									*/
/*	Local definitions for the LEAF window layout package		*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#define PROT_NAME	LEAF__sema
#include <bwethread.h>

#include <ctype.h>
#include <DATATYPES.h>
#include <leaf.h>
#include <ash.h>
#include <rip.h>
#include <stem.h>




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MAX_BOX 	32
#define MAX_PARAM	8

#define coordlx 	coord[LEAF_LOC_LX]
#define coordby 	coord[LEAF_LOC_BY]
#define coordrx 	coord[LEAF_LOC_RX]
#define coordty 	coord[LEAF_LOC_TY]





/************************************************************************/
/*									*/
/*	Data Type Definitions						*/
/*									*/
/************************************************************************/


typedef struct _LEAF_BOX *	LEAF_BOX;
typedef struct _LEAF_COORD *	LEAF_COORD;

typedef struct _LEAF_WIN *	LEAF_WIN;
typedef struct _LEAF_DEF *	LEAF_DEF;




typedef enum _LEAF_STATUS {
   LEAF_STATUS_NEW,
   LEAF_STATUS_UNDONE,
   LEAF_STATUS_WORK,
   LEAF_STATUS_LAYOUT,
   LEAF_STATUS_DRAWN
} LEAF_STATUS;




typedef struct _LEAF_WIN {
   LEAF_BOX	defn;
   ASH_WINDOW	window;
   Universal	data;
   RIP_REGION	region;
   Integer	coord[4];
   LEAF_STATUS	status;
   Integer	font;
} LEAF_WIN_B;





typedef struct _LEAF_DEF {
   Universal	data;
   Integer	numwin;
   Integer	infosize;
   ASH_WINDOW	window;
   Integer	coord[4];
   Integer	dx,dy;
   Integer	font;
   Function_Ptr ctrl_rtn;
   Function_Ptr refresh_rtn;
   LEAF_DATA *	leafdata;
   LEAF_WIN_B * info;
   Integer	param[MAX_PARAM];
   Boolean	resize_only;
   Boolean	active;
} LEAF_DEF_B;






/************************************************************************/
/*									*/
/*	Global variables						*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Tracing Definitions						*/
/*									*/
/************************************************************************/


extern	Boolean 	LEAF__initedflag;
extern	Integer 	LEAF__tracelvl;


#define TRACE if (LEAF__tracelvl & LEAF_TRACE_ON) LEAF_trace
#define ITRACE if (LEAF__tracelvl & LEAF_TRACE_INT) LEAF_trace
#define DTRACE if (LEAF__tracelvl & LEAF_TRACE_DBG) LEAF_trace

#define ERROR(m) LEAF_error(m)
#define FATAL(m) { ERROR(m); ABORT; }
#define ABORT	 abort()

#define CHECKINIT if (!LEAF__initedflag) LEAF_init();
#define ENTER	CHECKINIT; TRACE




/************************************************************************/
/*									*/
/*	Internal entries						*/
/*									*/
/************************************************************************/


extern	void		LEAF_init();
extern	void		LEAF_trace();
extern	void		LEAF_error();

extern	void		LEAF_layout_init();
extern	void		LEAF_recompute_layout();
extern	LEAF_DEF	LEAF_find_window_defn();
extern	Integer 	LEAF_get_value();
extern	Integer 	LEAF_get_font();

extern	void		LEAF_draw_init();
extern	void		LEAF_free_component();
extern	void		LEAF_remove();




/* end of leaf_local.h */

