/************************************************************************/
/*									*/
/*		leaf.h							*/
/*									*/
/*	External definitions for the LEAF window layout package 	*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "ash.h"
#include "rip.h"




/************************************************************************/
/*									*/
/*	LEAF parameter type definitions 				*/
/*									*/
/************************************************************************/


				/* window types supported by leaf	*/
typedef int	LEAF_TYPE;


#define LEAF_TYPE_BASE		0x0fff
#define LEAF_TYPE_NONE		0x1	/*    undefined 		*/
#define LEAF_TYPE_ROOT		0x2	/*    root node 		*/
#define LEAF_TYPE_WINDOW	0x4	/*    ASH window		*/
#define LEAF_TYPE_TEXT		0x8	/*    box with text in it	*/
#define LEAF_TYPE_TEXT_CENTERED 0x10	/*    box with centered text in */
#define LEAF_TYPE_OLD_TEXT	0x20	/*    box showing title 	*/
#define LEAF_TYPE_PDM		0x40	/*    pull-down menu top bar	*/
#define LEAF_TYPE_STEM		0x100	/*    STEM static menu		*/
#define LEAF_TYPE_TEXT_RIGHT	0x200	/*    right-justified text	*/
#define LEAF_TYPE_SHADE 	0x400	/*    shaded area		*/
#define LEAF_TYPE_BTN		0x800	/*    STEM_BTN button		*/

#define LEAF_TYPE_FLAGS 	0xfff000
#define LEAF_TYPE_ARRAY 	0x1000	/*    array of windows		*/
#define LEAF_TYPE_SEPARATE	0x2000	/*    separate window array	*/
#define LEAF_TYPE_VERTICAL	0x4000	/*    array vertically		*/
#define LEAF_TYPE_UPPER_LEFT	0x8000	/*    put origin in upper left	*/
#define LEAF_TYPE_LOWER_LEFT	0x10000 /*    put origin in lower left	*/
#define LEAF_TYPE_SENSE_FLIP	0x20000 /*    flip if sensitive 	*/
#define LEAF_TYPE_INVISIBLE	0x40000 /*    make window invisible	*/
#define LEAF_TYPE_USE_TITLE	0x80000 /*    use as title		*/
#define LEAF_TYPE_ICONIC	0x100000 /*   icon font 		*/

#define LEAF_TYPE_TITLE 	(LEAF_TYPE_TEXT|LEAF_TYPE_USE_TITLE)


				/* coordinate types			*/
typedef short	LEAF_FLAG;

#define LEAF_FLAG_TYPE		0x0fff	/* basic type			*/
#define LEAF_FLAG_ABSOLUTE	0x1	/*    absolute position 	*/
#define LEAF_FLAG_SIZE		0x2	/*    absolute size		*/
#define LEAF_FLAG_PERCENT	0x4	/*    percent position		*/
#define LEAF_FLAG_TEXT_SIZE	0x8	/*    size of text		*/
#define LEAF_FLAG_NEXT		0x10	/*    below given box		*/
#define LEAF_FLAG_SAME		0x20	/*    same as given box 	*/
#define LEAF_FLAG_WINDOW	0x40	/*    use window coordinate	*/
#define LEAF_FLAG_REL_PERCENT	0x80	/*    percent size		*/
#define LEAF_FLAG_SCROLL_WIDTH	0x100	/*    scroll bar width		*/


#define LEAF_FLAG_DESCRIPTOR	0xf000	/* addendum to basic type	*/
#define LEAF_FLAG_LINE		0x1000	/*    bound with a line 	*/
#define LEAF_FLAG_DOUBLE_LINE	0x2000	/*    bound with a double line	*/



				/* value types				*/
#define LEAF_VFLAG_PARAM	0x40000000
#define LEAF_VFLAGS		0x40000000


#define LEAF_VALUE(n)		(n)
#define LEAF_VALUE_PARAM(n)	(LEAF_VFLAG_PARAM|(n))




/************************************************************************/
/*									*/
/*	Coordinate type definition					*/
/*									*/
/************************************************************************/


typedef struct	_LEAF_COORD {
   LEAF_FLAG	flags;
   int		value;
} LEAF_COORD_B;



#define LEAF_LOC_LX	0
#define LEAF_LOC_BY	1
#define LEAF_LOC_RX	2
#define LEAF_LOC_TY	3


#define LEAF_COORD_ABS(n)	{ LEAF_FLAG_ABSOLUTE, n }
#define LEAF_COORD_SIZE(s)	{ LEAF_FLAG_SIZE, s }
#define LEAF_COORD_REL(p)	{ LEAF_FLAG_PERCENT, p }
#define LEAF_COORD_REL_SIZE(p)	{ LEAF_FLAG_REL_PERCENT, p }
#define LEAF_COORD_TEXT 	{ LEAF_FLAG_TEXT_SIZE, 0 }
#define LEAF_COORD_NEXT(b)	{ LEAF_FLAG_NEXT, ((int) b) }
#define LEAF_COORD_SAME(b)	{ LEAF_FLAG_SAME, ((int) b) }
#define LEAF_COORD_LX		{ LEAF_FLAG_WINDOW, LEAF_LOC_LX }
#define LEAF_COORD_BY		{ LEAF_FLAG_WINDOW, LEAF_LOC_BY }
#define LEAF_COORD_RX		{ LEAF_FLAG_WINDOW, LEAF_LOC_RX }
#define LEAF_COORD_TY		{ LEAF_FLAG_WINDOW, LEAF_LOC_TY }
#define LEAF_COORD_REL_NEXT(b,p) { LEAF_FLAG_PERCENT|LEAF_FLAG_NEXT,(b*1024+p) }
#define LEAF_COORD_SCROLL	{ LEAF_FLAG_SCROLL_WIDTH, 0 }

#define LEAF_COORD_ABS_LINE(n)	{ LEAF_FLAG_ABSOLUTE|LEAF_FLAG_LINE, n }
#define LEAF_COORD_SIZE_LINE(s) { LEAF_FLAG_SIZE|LEAF_FLAG_LINE, s }
#define LEAF_COORD_REL_LINE(p)	{ LEAF_FLAG_PERCENT|LEAF_FLAG_LINE, p }
#define LEAF_COORD_REL_SIZE_LINE(p)  { LEAF_FLAG_REL_PERCENT|LEAF_FLAG_LINE, p }
#define LEAF_COORD_TEXT_LINE	{ LEAF_FLAG_TEXT_SIZE|LEAF_FLAG_LINE, 0 }
#define LEAF_COORD_NEXT_LINE(b) { LEAF_FLAG_NEXT|LEAF_FLAG_LINE, ((int) b) }
#define LEAF_COORD_SAME_LINE(b) { LEAF_FLAG_SAME|LEAF_FLAG_LINE, ((int) b) }
#define LEAF_COORD_LX_LINE	{ LEAF_FLAG_WINDOW|LEAF_FLAG_LINE, LEAF_LOC_LX }
#define LEAF_COORD_BY_LINE	{ LEAF_FLAG_WINDOW|LEAF_FLAG_LINE, LEAF_LOC_BY }
#define LEAF_COORD_RX_LINE	{ LEAF_FLAG_WINDOW|LEAF_FLAG_LINE, LEAF_LOC_RX }
#define LEAF_COORD_TY_LINE	{ LEAF_FLAG_WINDOW|LEAF_FLAG_LINE, LEAF_LOC_TY }
#define LEAF_COORD_REL_NEXT_LINE(b,p) { LEAF_FLAG_PERCENT|LEAF_FLAG_NEXT|LEAF_FLAG_LINE,(b*1024+p) }
#define LEAF_COORD_SCROLL_LINE	{ LEAF_FLAG_SCROLL_WIDTH|LEAF_FLAG_LINE, 0 }





/************************************************************************/
/*									*/
/*	Box descriptor definitions					*/
/*									*/
/************************************************************************/


typedef int		LEAF_BOX_ID;

#define LEAF_BOX_ID_ROOT	0
#define LEAF_BOX_ID_LAST	(-1)




typedef int		(*LEAF_FCT)();





typedef struct _LEAF_BOX {
   LEAF_BOX_ID		id;
   LEAF_TYPE		type;
   LEAF_COORD_B 	coord[4];
   LEAF_FCT		button_fct;
   int			data;
} LEAF_BOX_B;





/************************************************************************/
/*									*/
/*	LEAF data table definitions					*/
/*									*/
/************************************************************************/


typedef struct _LEAF_BOX	LEAF_DATA;


#define LEAF_ROOT(btn)						\
	  { LEAF_BOX_ID_ROOT, LEAF_TYPE_ROOT,			\
	       { LEAF_COORD_LX, LEAF_COORD_BY,			\
		 LEAF_COORD_RX, LEAF_COORD_TY },		\
	       btn,0 }

#define LEAF_END	{ LEAF_BOX_ID_LAST }





/************************************************************************/
/*									*/
/*	Entries 							*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	void		LEAFsetup_window();
extern	void		LEAFlayout_window();
extern	void		LEAFset_parameters();
extern	void		LEAFset_control();
extern	void		LEAFset_refresh();
extern	void		LEAFset_active();
extern	ASH_WINDOW	LEAFinq_window();
extern	void		LEAFset_font();
extern	void		LEAFset_data();
extern	int		LEAFinq_data();
extern	RIP_REGION	LEAFinq_rip_region();

extern	void		LEAFredraw();
extern	void		LEAFremove();

#else

extern "C" {
	void		LEAFsetup_window(ASH_WINDOW,LEAF_DATA [] ...);
	void		LEAFlayout_window(ASH_WINDOW,LEAF_DATA [] ...);
	void		LEAFset_parameters(ASH_WINDOW,int ...);
	void		LEAFset_control(ASH_WINDOW ...);
	void		LEAFset_refresh(ASH_WINDOW ...);
	void		LEAFset_active(ASH_WINDOW,int);
	ASH_WINDOW	LEAFinq_window(ASH_WINDOW,int ...);
	void		LEAFset_font(int,ASH_WINDOW,int ...);
	void		LEAFset_data(...);
	int		LEAFinq_data(ASH_WINDOW,int ...);
	RIP_REGION	LEAFinq_rip_region(ASH_WINDOW,int ...);

	void		LEAFredraw(ASH_WINDOW);
	void		LEAFremove(ASH_WINDOW);
};

#endif




/************************************************************************/
/*									*/
/*	Tracing Definitions						*/
/*									*/
/************************************************************************/


#ifndef __cplusplus
extern	void		LEAFtrace();		/* establish tracing	*/
#else
extern	"C" void        LEAFtrace(int);         /* establish tracing    */
#endif

#define LEAF_TRACE_OFF	0		/* tracing off			*/
#define LEAF_TRACE_ON	0x1		/* trace external entries	*/
#define LEAF_TRACE_INT	0x2		/* trace internal entries	*/
#define LEAF_TRACE_DBG	0x4		/* trace local routines 	*/





/* end of leaf.h */
