/************************************************************************/
/*									*/
/*		helpwin.c						*/
/*									*/
/*	Windowing routines for HELP information 			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/



#include "help_local.h"




/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/


static	Sequence	all_windows;




/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	int		help_control();





/************************************************************************/
/*									*/
/*	Tables -- window definitions					*/
/*									*/
/************************************************************************/


#define MENU_WIN	1
#define HEADER_RGN	2
#define EDIT_WIN	3


static LEAF_DATA help_leaf[] = {
   LEAF_ROOT(NULL),
   { MENU_WIN, LEAF_TYPE_STEM,
	{ LEAF_COORD_LX, LEAF_COORD_REL_SIZE(33), LEAF_COORD_RX, LEAF_COORD_TY },
	HELP_menu_btn, NULL },
   { HEADER_RGN, LEAF_TYPE_TEXT,
	{ LEAF_COORD_LX, LEAF_COORD_TEXT, LEAF_COORD_RX, LEAF_COORD_NEXT_LINE(MENU_WIN) },
	NULL, NULL },
   { EDIT_WIN, LEAF_TYPE_WINDOW,
	{ LEAF_COORD_LX, LEAF_COORD_BY, LEAF_COORD_RX, LEAF_COORD_NEXT_LINE(HEADER_RGN) },
	NULL, NULL },
   LEAF_END
};





static LEAF_DATA simple_help_leaf[] = {
   LEAF_ROOT(NULL),
   { HEADER_RGN, LEAF_TYPE_TEXT,
	{ LEAF_COORD_LX, LEAF_COORD_TEXT, LEAF_COORD_RX, LEAF_COORD_TY },
	NULL, NULL },
   { EDIT_WIN, LEAF_TYPE_WINDOW,
	{ LEAF_COORD_LX, LEAF_COORD_BY, LEAF_COORD_RX, LEAF_COORD_NEXT_LINE(HEADER_RGN) },
	NULL, NULL },
   LEAF_END
};





/************************************************************************/
/*									*/
/*	HELP_win_init -- module initialization				*/
/*									*/
/************************************************************************/


void
HELP_win_init()
{
   all_windows = NULL;
};






/************************************************************************/
/*									*/
/*	HELP_win_create -- create a new HELP window			*/
/*									*/
/************************************************************************/


HELP_WIN
HELP_win_create(w,hd)
   ASH_WINDOW w;
   HELP_DATA hd;
{
   HELP_WIN hw;
   Boolean simple;

   hw = PALLOC(HELP_WIN_INFO);

   hw->window = w;
   hw->data = hd;
   hw->menu_win = NULL;
   hw->edit_win = NULL;
   hw->edit_id = NULL;
   hw->sensitive = (hd == NULL);
   hw->root = hd;

   PROTECT;
   all_windows = CONS(hw,all_windows);
   UNPROTECT;

   if (hw->root != NULL && hw->root->son == NULL) {
      LEAFsetup_window(w,simple_help_leaf,hw);
      simple = TRUE;
    }
   else {
      LEAFsetup_window(w,help_leaf,hw);
      simple = FALSE;
    };

   LEAFredraw(w);

   ASHset_window_name(w,"HELP Information");
   LEAFset_control(w,help_control);

   if (!simple) hw->menu_win = LEAFinq_window(w,MENU_WIN,0);

   hw->edit_win = LEAFinq_window(w,EDIT_WIN,0);

   HELP_display_current(hw);

   return hw;
};





/************************************************************************/
/*									*/
/*	HELP_win_title -- set current help title			*/
/*									*/
/************************************************************************/


void
HELP_win_title(hw,txt)
   HELP_WIN hw;
   String txt;
{
   Character buf[1024];

   sprintf(buf,"Help on %s",txt);
   ASHset_window_name(hw->window,buf);

   LEAFset_data(txt,hw->window,HEADER_RGN,0);
   LEAFredraw(hw->window);
};





/************************************************************************/
/*									*/
/*	HELP_win_find -- find a sensitive window			*/
/*									*/
/************************************************************************/


HELP_WIN
HELP_win_find()
{
   Sequence l;
   HELP_WIN hw;

   forin (hw,HELP_WIN,l,all_windows) {
      if (hw->sensitive) break;
    };

   return hw;
};





/************************************************************************/
/*									*/
/*	help_control -- handle ASH control messages for HELP window	*/
/*									*/
/************************************************************************/


static int
help_control(msg,w)
   String msg;
   ASH_WINDOW w;
{
   Sequence l;
   HELP_WIN hw;

   if (STREQL(msg,"ASH$REMOVE")) {
      PROTECT;
      forin (hw,HELP_WIN,l,all_windows) {
	 if (hw->window == w) break;
       };
      if (hw != NULL) all_windows = REMOB(hw,all_windows);
      UNPROTECT;
      free(hw);
    };

   return ASH_CONTROL_REJECT;
};





/* end of helpwin.c */
