/************************************************************************/
/*									*/
/*		helpmouse.c						*/
/*									*/
/*	Routines for providing MOUSE help information			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/



#include "help_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/


typedef struct _HELP_MOUSE *	HELP_MOUSE;

typedef struct _HELP_MOUSE {
   ASH_WINDOW window;
   Character left[256];
   Character center[256];
   Character right[256];
} HELP_MOUSE_INFO;



static	ASH_WINDOW		mouse_window;
static	HELP_MOUSE		current_mouse;
static	Sequence		mouse_stack;
static	Sequence		all_mouse_data;



/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	int		mouse_control();
static	int		user_mouse_control();
static	HELP_MOUSE	find_mouse_data();
static	void		set_mouse_data();





/************************************************************************/
/*									*/
/*	Tables -- window definitions					*/
/*									*/
/************************************************************************/


#define LEFT_HDR	1
#define LEFT_DATA	2
#define CENTER_HDR	3
#define CENTER_DATA	4
#define RIGHT_HDR	5
#define RIGHT_DATA	6


static LEAF_DATA help_mouse_leaf[] = {
   LEAF_ROOT(NULL),
   { LEFT_HDR, LEAF_TYPE_TEXT_CENTERED,
	{ LEAF_COORD_LX, LEAF_COORD_REL_SIZE_LINE(33),
	     LEAF_COORD_TEXT_LINE, LEAF_COORD_TY },
	NULL, (int) "Left  " },
   { LEFT_DATA, LEAF_TYPE_TEXT,
	{ LEAF_COORD_NEXT(LEFT_HDR), LEAF_COORD_SAME_LINE(LEFT_HDR),
	     LEAF_COORD_RX, LEAF_COORD_SAME(LEFT_HDR) },
	NULL, NULL },
   { CENTER_HDR, LEAF_TYPE_TEXT_CENTERED,
	{ LEAF_COORD_LX, LEAF_COORD_REL_SIZE_LINE(33),
	     LEAF_COORD_SAME_LINE(LEFT_HDR), LEAF_COORD_NEXT(LEFT_HDR) },
	NULL, (int) "Middle" },
   { CENTER_DATA, LEAF_TYPE_TEXT,
	{ LEAF_COORD_NEXT(CENTER_HDR), LEAF_COORD_SAME_LINE(CENTER_HDR),
	     LEAF_COORD_RX, LEAF_COORD_SAME(CENTER_HDR) },
	NULL, NULL },
   { RIGHT_HDR, LEAF_TYPE_TEXT_CENTERED,
	{ LEAF_COORD_LX, LEAF_COORD_BY,
	     LEAF_COORD_SAME_LINE(LEFT_HDR), LEAF_COORD_NEXT(CENTER_HDR) },
	NULL, (int) "Right " },
   { RIGHT_DATA, LEAF_TYPE_TEXT,
	{ LEAF_COORD_NEXT(RIGHT_HDR), LEAF_COORD_BY,
	     LEAF_COORD_RX, LEAF_COORD_SAME(RIGHT_HDR) },
	NULL, NULL },
   LEAF_END
};





/************************************************************************/
/*									*/
/*	HELP_mouse_init -- module initialization			*/
/*									*/
/************************************************************************/


void
HELP_mouse_init()
{
   mouse_window = NULL;
   all_mouse_data = NULL;
   current_mouse = NULL;
   mouse_stack = NULL;
};





/********************************************************************************/
/*										*/
/*	HELPmouse_register -- register help information for mouse for window	*/
/*										*/
/********************************************************************************/


void
HELPmouse_register(w,l,c,r)
   ASH_WINDOW w;
   String l;
   String c;
   String r;
{
   HELP_MOUSE md;
   Sequence la;

   if (w == NULL) return;

   HELPinit();

   PROTECT;

   forin (md,HELP_MOUSE,la,all_mouse_data) {
      if (md->window == w) break;
    };

   if (md == NULL) {
      md = PALLOC(HELP_MOUSE_INFO);
      md->window = w;
      all_mouse_data = APPEND(md,all_mouse_data);
    };

   if (l == NULL && c == NULL && r == NULL) {
      all_mouse_data = REMOB(md,all_mouse_data);
      ASHremove_control(w,user_mouse_control);
    }
   else {
      if (l != NULL) strcpy(md->left,l);
      else md->left[0] = 0;

      if (STREQL(c,"^")) c = l;
      if (c != NULL) strcpy(md->center,c);
      else md->center[0] = 0;

      if (STREQL(r,"^")) r = c;
      if (r != NULL) strcpy(md->right,r);
      else md->right[0] = 0;

      ASHset_control(w,user_mouse_control);
    };

   if (md == current_mouse) set_mouse_data();

   UNPROTECT;
};




/********************************************************************************/
/*										*/
/*	HELP_mouse_win_create -- create a Mouse HELP window			*/
/*										*/
/********************************************************************************/


Boolean
HELP_mouse_win_create(w)
   ASH_WINDOW w;
{
   if (mouse_window != NULL) return FALSE;

   mouse_window = w;

   LEAFsetup_window(mouse_window,help_mouse_leaf,NULL);

   set_mouse_data();

   LEAFredraw(mouse_window);

   ASHset_window_name(mouse_window,"MOUSE HELP Information");
   LEAFset_control(w,mouse_control);

   return TRUE;
};






/********************************************************************************/
/*										*/
/*	mouse_control -- handle control messages for mouse window		*/
/*										*/
/********************************************************************************/


static int
mouse_control(msg,w)
   String msg;
   ASH_WINDOW w;
{
   if (w != mouse_window) return ASH_CONTROL_REJECT;

   if (STREQL(msg,"ASH$REMOVE")) {
      mouse_window = NULL;
    };

   return ASH_CONTROL_REJECT;
};





/********************************************************************************/
/*										*/
/*	user_mouse_control -- handle control messages for monitored windows	*/
/*										*/
/********************************************************************************/


static int
user_mouse_control(msg,w)
   String msg;
   ASH_WINDOW w;
{
   if (STREQL(msg,"ASH$REMOVE")) {
      HELPmouse_register(w,NULL,NULL,NULL);
    }
   else if (STREQL(msg,"ASH$ENTER")) {
      if (current_mouse != NULL) mouse_stack = CONS(current_mouse,mouse_stack);
      current_mouse = find_mouse_data(w);
      set_mouse_data();
    }
   else if (STREQL(msg,"ASH$EXIT")) {
      if (current_mouse == find_mouse_data(w)) {
	 if (mouse_stack == NULL) current_mouse = NULL;
	 else {
	    current_mouse = CAR(HELP_MOUSE,mouse_stack);
	    mouse_stack = CDRF(mouse_stack);
	  };
	 set_mouse_data();
       };
    };

   return ASH_CONTROL_REJECT;
};





/********************************************************************************/
/*										*/
/*	find_mouse_data -- find mouse data block for window			*/
/*										*/
/********************************************************************************/


static HELP_MOUSE
find_mouse_data(w)
   ASH_WINDOW w;
{
   HELP_MOUSE md;
   Sequence l;

   forin (md,HELP_MOUSE,l,all_mouse_data) {
      if (md->window == w) break;
    };

   return md;
};





/********************************************************************************/
/*										*/
/*	set_mouse_data -- set mosue data in display				*/
/*										*/
/********************************************************************************/


static void
set_mouse_data()
{
   if (mouse_window == NULL) return;

   PROTECT;

   if (current_mouse == NULL) {
      LEAFset_data("",mouse_window,LEFT_DATA,0);
      LEAFset_data("",mouse_window,CENTER_DATA,0);
      LEAFset_data("",mouse_window,RIGHT_DATA,0);
    }
   else {
      LEAFset_data(current_mouse->left,mouse_window,LEFT_DATA,0);
      LEAFset_data(current_mouse->center,mouse_window,CENTER_DATA,0);
      LEAFset_data(current_mouse->right,mouse_window,RIGHT_DATA,0);
    };

   LEAFredraw(mouse_window);

   UNPROTECT;
};





/* end of helpmouse.c */

