/************************************************************************/
/*									*/
/*		helpmain.c						*/
/*									*/
/*	Main program for providing HELP information			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/



#include "help_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define HELP_INFO_MAX	16
#define HELP_DEPTH_MAX	16




/************************************************************************/
/*									*/
/*	Local Storage							*/
/*									*/
/************************************************************************/


static	Boolean 	initedflag = FALSE;

	PROT_DECL;

static	Integer 	help_info_ct = 0;
static	Function_Ptr	help_info_fct[HELP_INFO_MAX];



/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


#ifdef LIB
static			help_cleanup_rtn();
#endif





/************************************************************************/
/*									*/
/*	HELPinit -- initialize HELP facility				*/
/*									*/
/************************************************************************/


void
HELPinit()
{
   PROT_INIT;

   PROTECT;
   if (!initedflag) {
#ifdef LIB
      BROWNregister_cleanup(help_cleanup_rtn);
#endif

      HELP_win_init();
      HELP_item_init();
      HELP_display_init();
      HELP_mouse_init();

      BIOset_mapping(NULL,FKEY(BPIO_KEY_HELP),BIO_MAP_ACTION,HELPrequest,NULL);
      BIOset_mapping(NULL,FKEY_UP(BPIO_KEY_HELP),BIO_MAP_NONE,NULL,NULL);

      initedflag = TRUE;
    };
   UNPROTECT;
};





#ifdef LIB

static
help_cleanup_rtn()
{
   initedflag = FALSE;
   help_info_ct = 0;
};

#endif




/************************************************************************/
/*									*/
/*	HELPrequest -- handle help requests from RIP			*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

void
HELPrequest(data,w,x,y)
   Integer data;
   ASH_WINDOW w;
   Integer x,y;
{
   String helpid[HELP_DEPTH_MAX];
   Integer ct;
   Integer i;
   ASH_WINDOW pw,nw;
   HELP_DATA hd;
   Character buf[1024];
   HELP_WIN hw;
   String s,t;

   HELPinit();

   s = NULL;
   for (i = 0; i < help_info_ct; ++i) {
      s = (String) (*help_info_fct[i])(w,x,y);
      if (s != NULL) break;
    };

   ct = 0;
   while (s != NULL) {
      t = rindex(s,'.');
      if (t != NULL) {
	 *t++ = 0;
	 helpid[ct++] = t;
       }
      else {
	 helpid[ct++] = s;
	 s = NULL;
       };
    };

   for (pw = w; pw != NULL; pw = ASHinq_parent(pw)) {
      s = ASHinq_window_id(pw);
      if (s != NULL) helpid[ct++] = s;
    };

   if (ASHinq_top_window(w) != ASHinq_top()) {
      s = ASHinq_window_id(ASHinq_top());
      if (s != NULL) helpid[ct++] = s;
    };

   hd = HELP_item_find(ct,helpid);
   if (hd == NULL) {
      buf[0] = 0;
      for (i = ct-1; i >= 0; --i) {
	 if (i != ct-1) strcat(buf,".");
	 strcat(buf,helpid[i]);
       };
      fprintf(stderr,"No help information on %s\n",buf);
      for (i = 1; i < ct; ++i) {
	 hd = HELP_item_find(ct-i,&helpid[i]);
	 if (hd != NULL) break;
       };
    };

   hw = HELP_win_find();
   if (hw == NULL && hd != NULL) {
      WINDactivate("Help",NULL,NULL);
      hw = HELP_win_find();
      if (hw == NULL) {
	 nw = ASHroot_window(NULL,"Help");
	 HELPnew_window(nw);
	 hw = HELP_win_find();
       };
      if (hw == NULL) {
	 fprintf(stderr,"Couldn't create help window\n");
       }
    };

   if (hw != NULL && hd != NULL) {
      HELP_display(hw,hd);
    };
};






/************************************************************************/
/*									*/
/*	HELPnew_window -- create new help window			*/
/*									*/
/************************************************************************/


int
HELPnew_window(w)
   ASH_WINDOW w;
{
   Boolean fg;

   fg = (HELP_win_create(w,NULL) != NULL);

   return fg;
};





/************************************************************************/
/*									*/
/*	HELPnew_window_on -- create new help window on topic		*/
/*									*/
/************************************************************************/


int
HELPnew_window_on(w,what)
   ASH_WINDOW w;
   String what;
{
   Character buf[10240];
   String helpid[HELP_DEPTH_MAX];
   Integer ct;
   String t;
   Boolean fg;
   HELP_DATA hd;
   HELP_WIN hw;

   if (what == NULL) what = ASHinq_window_id(ASHinq_top());
   if (what == NULL) what = "";

   strcpy(buf,what);
   ct = 0;

   while ((t = rindex(buf,'.')) != NULL) {
      *t++ = 0;
      if (t[0] != 0) helpid[ct++] = t;
    };
   if (buf[0] != 0) helpid[ct++] = buf;

   hd = HELP_item_find(ct,helpid);
   if (hd == NULL) {
      if (what != NULL) fprintf(stderr,"No help information on %s\n",what);
    };

   if (w == NULL) {
      hw = HELP_win_find();
      if (hw == NULL && hd != NULL) {
	 WINDactivate("Help",NULL,NULL);
	 hw = HELP_win_find();
	 if (hw == NULL) {
	    w = ASHroot_window(NULL,"Help");
	    HELPnew_window(w);
	    hw = HELP_win_find();
	  };
	 if (hw == NULL) {
	    fprintf(stderr,"Couldn't create help window\n");
	  }
       };
      if (hw != NULL && hd != NULL) {
	 HELP_display(hw,hd);
	 fg = TRUE;
       }
      else fg = FALSE;
    }
   else {
      hw = HELP_win_create(w,hd);
      fg = (hw != NULL);
    };

   return fg;
};





/************************************************************************/
/*									*/
/*	HELPnew_mouse_window -- create new help window for mouse info	*/
/*									*/
/************************************************************************/


int
HELPnew_mouse_window(w)
   ASH_WINDOW w;
{
   Boolean fg;

   fg = HELP_mouse_win_create(w);

   return fg;
};





/************************************************************************/
/*									*/
/*	HELPregister_info -- register function for help requests	*/
/*									*/
/************************************************************************/


void
HELPregister_info(fct)
   Function_Ptr fct;
{
   Integer i;

   PROTECT;

   for (i = 0; i < help_info_ct; ++i) {
      if (fct == help_info_fct[i]) break;
    };

   if (i >= help_info_ct) {
      help_info_fct[help_info_ct++] = fct;
    };

   UNPROTECT;
};





/* end of helpmain.c */
