/************************************************************************/
/*									*/
/*		helpdisplay.c						*/
/*									*/
/*	Display routines for HELP facilitty				*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/



#include "help_local.h"




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MAX_BUTTON	128




/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	void		display_menu();
static	void		display_text();
static	void		format_text();
static	Integer 	addline();
static	void		dumpline();
static	void		dumptext();





/************************************************************************/
/*									*/
/*	HELP_display_init -- module initialization			*/
/*									*/
/************************************************************************/


void
HELP_display_init()
{
};




/************************************************************************/
/*									*/
/*	HELP_display_current -- display current item			*/
/*									*/
/************************************************************************/


void
HELP_display_current(hw)
   HELP_WIN hw;
{
   HELP_display(hw,hw->data);
};





/************************************************************************/
/*									*/
/*	HELP_display -- display help item				*/
/*									*/
/************************************************************************/


void
HELP_display(hw,h)
   HELP_WIN hw;
   HELP_DATA h;
{
   HELP_DATA_INFO sb;

   PROTECT;

   hw->data = h;

   if (h == NULL) {
      h = HELP_inq_top_data();
      if (h == NULL) return;
      if (h->brother == NULL) {
	 hw->data = h;
       }
      else {
	 sb.name = NULL;
	 sb.filename = NULL;
	 sb.filepos = -1;
	 sb.textfile = NULL;
	 sb.brother = NULL;
	 sb.son = h;
	 sb.parent = NULL;
	 sb.flags = HELP_FLAG_EXPANDED;
	 h = &sb;
       };
    };

   HELP_item_expand(h);

   display_menu(hw,h);
   display_text(hw,h);

   UNPROTECT;
};





/************************************************************************/
/*									*/
/*	HELP_menu_btn -- handle menu button hit for help		*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

int
HELP_menu_btn(hw,idx,mask,win)
   HELP_WIN hw;
   Integer idx;
   Integer mask;
   ASH_WINDOW win;
{
   Integer i;
   HELP_DATA h;

   if ((mask & RIP_BTN_DOWN) != 0) return FALSE;

   if (idx == 0) {
      ASHremove(hw->window);
    }
   if (idx == 1) {
      if (hw->data == NULL) h = NULL;
      else h = hw->data->parent;
    }
   else {
      i = 2;
      if (hw->data == NULL) h = HELP_inq_top_data();
      else h = hw->data->son;
      for ( ; h != NULL; h = h->brother) {
	 if (h->flags & HELP_FLAG_IGNORE) continue;
	 if (i == idx) break;
	 ++i;
       };
    };

   HELP_display(hw,h);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	display_menu -- display help menu				*/
/*									*/
/************************************************************************/


static void
display_menu(hw,h)
   HELP_WIN hw;
   HELP_DATA h;
{
   STEM_BUTTON btns[MAX_BUTTON];
   Integer ct;
   HELP_DATA hs;
   Character buf[1024];

   if (hw->menu_win == NULL) return;

   ct = 0;

   btns[ct].name = "<< QUIT >>";
   btns[ct].flags = STEM_FLAG_NORMAL;
   ++ct;

   if (h->parent != NULL && h != hw->root) {
      sprintf(buf,"^^ %s",h->parent->name);
      btns[ct].name = buf;
      btns[ct].flags = STEM_FLAG_NORMAL;
      ++ct;
    }
   else {
      sprintf(buf,"^^ <root>");
      btns[ct].name = buf;
      btns[ct].flags = STEM_FLAG_LOLITE;
      ++ct;
    };

   for (hs = h->son; hs != NULL; hs = hs->brother) {
      if (hs->flags & HELP_FLAG_IGNORE) continue;
      btns[ct].name = hs->name;
      btns[ct].flags = STEM_FLAG_NORMAL;
      ++ct;
    };

   btns[ct].name = 0;
   btns[ct].flags = 0;

   STEMmenu_refresh(hw->menu_win,btns);
};






/************************************************************************/
/*									*/
/*	display_text -- display text for help button			*/
/*									*/
/************************************************************************/


static void
display_text(hw,h)
   HELP_WIN hw;
   HELP_DATA h;
{
   FILE * inf;
   Integer c;

   if (hw->edit_win == NULL || h == NULL) return;

   if (hw->edit_id == NULL) {
      hw->edit_id = EDTedit_string(hw->edit_win,NULL);
    }
   else {
      EDTenable(hw->edit_id,TRUE);
      EDTtruncate_at(hw->edit_id,1);
      EDTgoto(hw->edit_id,1);
    };

   EDTinq_bounds(hw->edit_id,&c,NULL,NULL,0);

   HELP_win_title(hw,h->name);

   if (h->textfile != NULL) {
      inf = fopen(h->textfile,"r");
      if (h->textpos != 0) fseek(inf,h->textpos,0);
      format_text(hw,inf,c-1);
      fclose(inf);
    };

   EDTgoto(hw->edit_id,1);
   EDTenable(hw->edit_id,FALSE);
};





/************************************************************************/
/*									*/
/*	format_text -- format text from file to vt window		*/
/*									*/
/************************************************************************/


static void
format_text(hw,inf,width)
   HELP_WIN hw;
   FILE * inf;
   Integer width;
{
   Character buf[1024];
   Character line[1024];
   Integer c,i;
   Character outbuf[10240];

   hw->buf = outbuf;
   hw->max = 1024;
   hw->ct = 0;
   hw->buf[0] = 0;

   c = 0;

   while (fgets(buf,1024,inf) != NULL) {
      if (buf[0] == HELP_TEXT_FLAG) break;
      if (buf[0] == '\n') {
	 dumpline(hw,line,c);
	 c = 0;
	 dumptext(hw,"\n");
       }
      else if (buf[0] == ' ' || buf[0] == '\t') {
	 dumpline(hw,line,c);
	 c = 0;
	 for (i = 0; buf[i] == ' '; ++i);
	 if (buf[i] == '\t') {
	    i += 8;
	    i &= ~7;
	  };
	 if (i >= 3) {
	    dumptext(hw,buf);
	  }
	 else {
	    line[0] = line[1] = line[2] = ' ';
	    c = 3;
	    c = addline(hw,buf,line,c,width);
	  };
       }
      else c = addline(hw,buf,line,c,width);

      line[c] = '\n';
      line[c+1] = 0;
    };

   dumpline(hw,line,c);

   if (hw->ct > 0) EDTshell_output(hw->edit_id,outbuf);
   hw->buf = NULL;
};





/************************************************************************/
/*									*/
/*	addline -- add buffer to display line				*/
/*									*/
/************************************************************************/


static Integer
addline(hw,buf,line,pos,width)
   HELP_WIN hw;
   String buf;
   String line;
   Integer pos;
   Integer width;
{
   Integer lpos,i,ct;
   Character xline[1024];

   lpos = pos;

   while (*buf != 0) {
      if (*buf == ' ' || *buf == '\n') {
	 ++buf;
	 line[pos++] = ' ';
	 lpos = pos;
       }
      else if (*buf == '\t') {
	 ++buf;
	 ct = (pos+8)&(~7)-pos;
	 for (i = 0; i < ct; ++i) {
	    line[pos++] = ' ';
	    lpos = pos;
	  };
       }
      else {
	 line[pos++] = *buf++;
	 if (pos >= width) {
	    if (lpos != 0) {
	       ct = 0;
	       for (i = lpos; i < pos; ++i) {
		  xline[ct++] = line[i];
		};
	       dumpline(hw,line,lpos);
	       pos = 0;
	       for (i = 0; i < ct; ++i) {
		  line[pos++] = xline[i];
		};
	     }
	    else {
	       dumpline(hw,line,pos);
	       pos = 0;
	     };
	    lpos = 0;
	  };
       };
    };

   return pos;
};





/************************************************************************/
/*									*/
/*	dumpline -- output line 					*/
/*									*/
/************************************************************************/


static void
dumpline(hw,line,c)
   HELP_WIN hw;
   String line;
   Integer c;
{
   if (c == 0) return;

   line[c] = '\n';
   line[c+1] = 0;

   dumptext(hw,line);
};





/************************************************************************/
/*									*/
/*	dumptext -- dump a line of text to whoever wants it		*/
/*									*/
/************************************************************************/


static void
dumptext(hw,line)
   HELP_WIN hw;
   String line;
{
   Integer i;

   i = strlen(line);

   if (i+hw->ct >= hw->max) {
      EDTshell_output(hw->edit_id,hw->buf);
      hw->ct = 0;
      hw->buf[0] = 0;
    };

   strcpy(&hw->buf[hw->ct],line);
   hw->ct += i;
};





/* end of helpdisplay.c */



