/************************************************************************/
/*									*/
/*		help_local.h						*/
/*									*/
/*	Local definitions for HELP facility				*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include <DATATYPES.h>
#include <sequence.h>

#define PROT_NAME	HELP__sema
#include <bwethread.h>

#include <ash.h>
#include <bio.h>
#include <biokeys.h>
#include <bpiokeys.h>
#include <rip.h>
#include <stem.h>
#include <leaf.h>
#include <edt.h>
#include <wind.h>
#include <help.h>




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define HELP_TEXT_NAME	"INFO"
#define HELP_TEXT_FLAG	'$'

#define HELP_DIRECTORY	"bwe/info"





/************************************************************************/
/*									*/
/*	Data Structures 						*/
/*									*/
/************************************************************************/


typedef Integer 		HELP_FLAG;

#define HELP_FLAG_DIRECTORY	0x1
#define HELP_FLAG_FILE		0x2
#define HELP_FLAG_IGNORE	0x4
#define HELP_FLAG_EXPANDED	0x8

#define HELP_FLAG_INITIAL	0




typedef struct _HELP_DATA *	HELP_DATA;
typedef struct _HELP_WIN *	HELP_WIN;




typedef struct _HELP_DATA {	/* Data describing possible help	*/
   String name; 		/*    name to put in menu for user	*/
   String filename;		/*    filename for sons help info	*/
   Integer filepos;		/*    position in file for sons 	*/
   String textfile;		/*    filename for text 		*/
   Integer textpos;		/*    position in file for text 	*/
   HELP_DATA brother;		/*    pointer to brother node		*/
   HELP_DATA son;		/*    pointer to first son node 	*/
   HELP_DATA parent;		/*    pointer to parent node		*/
   HELP_FLAG flags;		/*    flags telling state, etc. 	*/
} HELP_DATA_INFO;





typedef struct _HELP_WIN {
   ASH_WINDOW window;
   HELP_DATA  data;
   ASH_WINDOW menu_win;
   ASH_WINDOW edit_win;
   EDT_ID edit_id;
   Boolean sensitive;
   String buf;
   Integer ct;
   Integer max;
   HELP_DATA root;
} HELP_WIN_INFO;





/************************************************************************/
/*									*/
/*	General functions and definitions -- helpmain.c 		*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Windowing routines						*/
/*									*/
/************************************************************************/


extern	void		HELP_win_init();
extern	HELP_WIN	HELP_win_create();
extern	void		HELP_win_title();
extern	HELP_WIN	HELP_win_find();




/************************************************************************/
/*									*/
/*	Functions for item manipulation 				*/
/*									*/
/************************************************************************/


extern	void		HELP_item_init();
extern	HELP_DATA	HELP_item_add();
extern	void		HELP_item_expand();
extern	HELP_DATA	HELP_inq_top_data();
extern	HELP_DATA	HELP_item_find();





/************************************************************************/
/*									*/
/*	Functions for displaying help information			*/
/*									*/
/************************************************************************/


extern	void		HELP_display_init();
extern	void		HELP_display_current();
extern	void		HELP_display();
extern	int		HELP_menu_btn();





/********************************************************************************/
/*										*/
/*	Functions for mouse help						*/
/*										*/
/********************************************************************************/


extern	void		HELP_mouse_init();
extern	Boolean 	HELP_mouse_win_create();





/* end of help_local.h */
