/************************************************************************/
/*									*/
/*	testlayout.c -- GELO test program				*/
/*									*/
/************************************************************************/
/*	Copyright 1990 Brown University -- Steven P. Reiss		*/


#include <DATATYPES.h>
#include <gelo.h>
#include <ash.h>



/************************************************************************/
/*									*/
/*	Definitions							*/
/*									*/
/************************************************************************/


#define NUM_NODES	10
#define NUM_ARCS	20
#define MAX_NODE	128

#define CYCLE_MAX	0x1ff
static	GELO_OBJECT	graph_obj();


/************************************************************************/
/*									*/
/*	Main program							*/
/*									*/
/************************************************************************/



main(argc,argv)
   Integer argc;
   String argv[];
{
   Integer n,a,m,w;
   GELO_CONN_METHOD c;
   Integer i;
   String s;
   Integer cycle;
   Integer rpt;

   n = NUM_NODES;
   a = NUM_ARCS;
   m = GELO_METHOD_DFS;
   c = GELO_CONN_METHOD_DIRECT_RECT;
   w = 0;
   rpt = 1;
   cycle = 0;

   for (i = 1; i < argc; ++i) {
      if (STREQL(argv[i],"-m")) {
	 m = 0;
	 s = argv[++i];
	 while (*s != 0) {
	    switch (*s++) {
	       case 'd' :
	       case 'D' :
		  m |= GELO_METHOD_BIT_DFS;
		  break;
	       case 'h' :
	       case 'H' :
		  m |= GELO_METHOD_BIT_HOR;
		  break;
	       case 'v' :
	       case 'V' :
		  m |= GELO_METHOD_BIT_VERT;
		  break;
	       case '2' :
		  m |= GELO_METHOD_BIT_2WAY;
		  break;
	       case 'i' :
	       case 'I' :
		  m |= GELO_METHOD_BIT_INCR;
		  break;
	       case 'b' :
	       case 'B' :
		  m |= GELO_METHOD_BIT_BFS;
		  break;
	       case 'a' :
	       case 'A' :
		  m |= GELO_METHOD_BIT_AVG;
		  break;
	       case 'f' :
	       case 'F' :
		  m |= GELO_METHOD_BIT_FWD;
		  break;
	       case 'l' :
	       case 'L' :
		  m |= GELO_METHOD_BIT_LEVEL;
		  break;
	       case 'o' :
	       case 'O' :
		  m |= GELO_METHOD_BIT_OPT;
		  break;
	       case 'g' :
	       case 'G' :
		  m |= GELO_METHOD_BIT_ANNEAL;
		  break;
	       default :
		  printf("layout methods: DHV2IBAFLOG\n");
		  exit(1);
	     };
	  };
       }
      else if (STREQL(argv[i],"-c")) {
	 s = argv[++i];
	 switch (*s) {
	    case 'r' :
	    case 'R' :
	       c = GELO_CONN_METHOD_RECT;
	       break;
	    case 'd' :
	    case 'D' :
	       c = GELO_CONN_METHOD_DIRECT;
	       break;
	    case 'e' :
	    case 'E' :
	       c = GELO_CONN_METHOD_DIRECT_RECT;
	       break;
	    default :
	       printf("connection methods: RDE\n");
	       exit(1);
	  };
       }
      else if (STREQL(argv[i],"-w")) {
	 w = atol(argv[++i]);
       }
      else if (STREQL(argv[i],"-n")) {
	 n = atol(argv[++i]);
       }
      else if (STREQL(argv[i],"-a")) {
	 a = atol(argv[++i]);
       }
      else if (STREQL(argv[i],"-r")) {
	 rpt = atol(argv[++i]);
       }
      else if (STREQL(argv[i],"-t")) {
	 rpt = CYCLE_MAX;
	 cycle = 1;
       }
      else if (STREQL(argv[i],"-d")) {
	 GELOtrace(atol(argv[++i]));
       }
      else {
	 printf("testlayout -m <method> -c <connmethod> -w # -n # -a # -d # -r # -t\n");
	 exit(1);
       };
    };

   ASHinit(ASH_MODE_WINDOW);

   GELOinit();

   GELOwindow_open(ASHinq_top());

   printf("start drawing graph\n");

   for (i = 0; i < rpt; ++i) {
      if (cycle) m = i;
      GELOwindow_draw(ASHinq_top(),graph_obj(n,a,m,w,c));
    };

   printf("finished drawing tree\n");

   RIPuser_pick(NULL);
};





/************************************************************************/
/*									*/
/*	graph_obj -- layout a graph					*/
/*									*/
/************************************************************************/


static GELO_OBJECT
graph_obj(n,a,m,w,cm)
   Integer n,a,m,w;
   GELO_CONN_METHOD cm;
{
   GELO_OBJECT g,g1,g2;
   Character buf[16];
   Integer i,j,k;
   Boolean conn[MAX_NODE][MAX_NODE];
   GELO_OBJECT obj[MAX_NODE];
   GELO_CONNECT c;

   for (i = 0; i < n; ++i) {
      for (j = 0; j < n; ++j) {
	 conn[i][j] = FALSE;
       };
    };

   g = GELOdefine_layout();
   GELOdefine_layout_method(g,m);
   GELOdefine_layout_conn_method(g,cm);
   GELOdefine_layout_white_space(g,w);

   for (i = 0; i < n; ++i) {
      sprintf(buf,"%02d",i);
      g1 = GELOdefine_data();
      GELOdefine_data_text(g1,SALLOC(buf));
      GELOdefine_layout_component(g,g1);
      obj[i] = g1;
    };

   for (i = 0; i < a; ++i) {
      j = random()%n;
      k = random()%n;
      if (j != k && !conn[j][k]) {
	 c = GELOnew_connect(obj[j],GELO_PORT_ANY,
				obj[k],GELO_PORT_ANY);
	 GELOdefine_layout_connect(g,c);
       };
    };

   return g;
};
