/************************************************************************/
/*									*/
/*	testgelo.c -- GELO test program 				*/
/*									*/
/************************************************************************/
/*	Copyright 1990 Brown University -- Steven P. Reiss		*/


#include <gelo.h>
#include <ash.h>
#include <DATATYPES.h>



/************************************************************************/
/*									*/
/*	Definitions							*/
/*									*/
/************************************************************************/


typedef struct _TREE *TREE;

typedef struct _TREE {
   Integer data;
   TREE lson,rson;
} TREE_B;


#define NUM_NODES	10


static	TREE		create_tree();
static	GELO_OBJECT	tree_setup();





/************************************************************************/
/*									*/
/*	Main program							*/
/*									*/
/************************************************************************/



typedef struct _args { Integer cnt; String *args; };

static void main_prog();


void
main(argc,argv)
   Integer argc;
   String argv[];
{
   struct _args A;

   A.cnt = argc;
   A.args = argv;

   BWEthread_begin(16,0,0,0,main_prog,&A);

   main_prog(&A);
};






static void
main_prog(A)
   struct _args *A;
{
   Integer argc;
   String *argv;
   TREE t;
   Integer n;

   argc = A->cnt;
   argv = A->args;

   if (argc > 1) n = atol(argv[1]);
   if (n == 0 || argc <= 1) n = NUM_NODES;

   if (argc > 2) GELOtrace(atol(argv[2]));

   ASHinit(ASH_MODE_WINDOW);

   t = create_tree(n);

   GELOinit();

   GELOwindow_open(ASHinq_top());

   printf("start drawing tree\n");

   GELOwindow_draw(ASHinq_top(),tree_setup(t));

   printf("finished drawing tree\n");

   if (argc <= 2) sleep(100);
};





/************************************************************************/
/*									*/
/*	create_tree -- generate a dummy tree				*/
/*									*/
/************************************************************************/


static TREE
create_tree(n)
   Integer n;
{
   TREE root,t,*wh;
   Integer i,j;

   root = NULL;

   for (i = 0; i < n; ++i) {
      j = random()%1024;
      wh = &root;
      for (t = root; t != NULL; t = *wh) {
	 if (t->data >= j) wh = &(t->lson);
	 else wh = &(t->rson);
       };
      t = (TREE) calloc(1,sizeof(TREE_B));
      t->data = j;
      t->lson = NULL;
      t->rson = NULL;
      *wh = t;
    };

   return root;
};




/************************************************************************/
/*									*/
/*	tree_setup -- draw a non-empty tree				*/
/*									*/
/************************************************************************/


static GELO_OBJECT
tree_setup(t)
   TREE t;
{
   GELO_OBJECT g,g1,g2;
   GELO_CONNECT c;
   Character buf[16];
   Float f;

   if (t == NULL) {
      g = GELOdefine_data();
      GELOdefine_data_shape(g,GELO_SHAPE_CIRCLE);
      GELOdefine_data_fill(g,3);
/*    GELOset_priority_y(g,0.1);	*/
      GELOuse_default_x(g,TRUE);
      GELOuse_default_y(g,TRUE);
      return g;
    };

   g = GELOdefine_tiled();

   g1 = GELOdefine_data();
   GELOdefine_data_shape(g1,GELO_SHAPE_RECTANGLE);
   sprintf(buf,"%d",t->data);
   GELOdefine_data_text(g1,SALLOC(buf));
   GELOdefine_tiled_component(g,g1,1,1,4,0,1.0,1.0,1.0);
   GELOuse_default_y(g1,TRUE);
   g2 = g1;

   g1 = GELOdefine_data();
   GELOdefine_data_shape(g1,GELO_SHAPE_NONE);
   GELOdefine_tiled_component(g,g1,0,1,1,0,1.0,0.1,1.0);

   g1 = GELOdefine_data();
   GELOdefine_data_shape(g1,GELO_SHAPE_NONE);
   GELOdefine_tiled_component(g,g1,4,1,5,0,1.0,0.1,1.0);

   g1 = GELOdefine_data();
   GELOdefine_data_shape(g1,GELO_SHAPE_NONE);
   GELOdefine_tiled_component(g,g1,0,2,5,1,1.0,0.5,1.0);

   g1 = GELOdefine_data();
   GELOdefine_data_shape(g1,GELO_SHAPE_NONE);
   GELOdefine_tiled_component(g,g1,0,5,2,3,1.0,0.1,1.0);

   g1 = GELOdefine_data();
   GELOdefine_data_shape(g1,GELO_SHAPE_NONE);
   GELOdefine_tiled_component(g,g1,3,5,5,4,1.0,0.1,1.0);

   g1 = GELOdefine_data();
   GELOdefine_data_shape(g1,GELO_SHAPE_NONE);
   GELOdefine_tiled_component(g,g1,2,5,3,2,0.001,1.0,1.0);

   g1 = tree_setup(t->lson);
   GELOdefine_tiled_component(g,g1,0,3,2,2,1.0,1.0,0.9);
   c = GELOnew_connect(g2,GELO_PORT_BOTTOM,g1,GELO_PORT_TOP);
   GELOdefine_tiled_connect(g,c);

   g1 = tree_setup(t->rson);
   GELOdefine_tiled_component(g,g1,3,4,5,2,1.0,1.0,0.9);
   c = GELOnew_connect(g2,GELO_PORT_BOTTOM,g1,GELO_PORT_TOP);
   GELOdefine_tiled_connect(g,c);

   return g;
};
