/************************************************************************/
/*									*/
/*		geloutil.c						*/
/*									*/
/*	Utility routines for GELO users 				*/
/*									*/
/************************************************************************/
/*	Copyright 1990 Brown University -- Steven P. Reiss		*/


#include "gelo_local.h"





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define AVERAGE_METHOD		GELO_METHOD_DAVG2
#define DFS_METHOD		GELO_METHOD_DFS2
#define BREADTH_METHOD		GELO_METHOD_BFS2
#define LEVEL_METHOD		GELO_METHOD_LEVEL
#define ANNEAL_METHOD		(GELO_METHOD_DAVG|GELO_METHOD_BIT_ANNEAL)
#define GRID_METHOD		GELO_METHOD_GRID2
#define LATTICE_METHOD		GELO_METHOD_LATTICE2
#define GIOTTO_METHOD		GELO_METHOD_RECT






/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	GELO_util_init -- module initialization 			*/
/*									*/
/************************************************************************/


void
GELO_util_init()
{
};





/************************************************************************/
/*									*/
/*	GELOrequest_methods -- get layout methods			*/
/*									*/
/************************************************************************/


int
GELOrequest_layout_methods(w,mthdp,cmthdp,fixp,stdp,ctrp,whitep)
   ASH_WINDOW w;
   GELO_METHOD * mthdp;
   GELO_CONN_METHOD * cmthdp;
   Integer * fixp;
   Integer * stdp;
   Integer * ctrp;
   Integer * whitep;
{
   Character menu[10240];
   Character buf[1024];
   Integer fix,std,cen,mthd,cmthd,white,dir;
   Integer userbits;

   sprintf(menu,"%%CDisplay Options\n\n");

   if (fixp != NULL && stdp != NULL && ctrp != NULL) {
      fix = *fixp;
      std = *stdp;
      cen = *ctrp;

      strcat(menu,"Node size options:\n");
      strcat(menu,"   %0o Fixed size nodes        %1o Standard size nodes   %2o Center nodes\n");
      strcat(menu,"\n");
    };

   mthd = *mthdp;
   userbits = mthd & GELO_METHOD_USER_BITS;

   strcat(menu,"Basic Methods:\n");
   sprintf(buf,"   %%3.%do Depth first layout   ",DFS_METHOD);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%do Averaged layout    ",AVERAGE_METHOD);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%do Level graph layout \n",LEVEL_METHOD);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%do Optimized layout     ",ANNEAL_METHOD);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%do Grid layout        ",GRID_METHOD);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%do Lattice layout\n",LATTICE_METHOD);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%do Breadth first layout ",BREADTH_METHOD);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%do Rectangular layout\n",GIOTTO_METHOD);
   strcat(menu,buf);
   strcat(menu,"\n");

   strcat(menu,"Heuristics to be used:\n");
   sprintf(buf,"   %%3.%df Depth-first          ",GELO_METHOD_BIT_DFS);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%df Breadth-first      ",GELO_METHOD_BIT_BFS);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%df Averaged position\n",GELO_METHOD_BIT_AVG);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%df Level graphs         ",GELO_METHOD_BIT_LEVEL);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%df Grid Heuristic     ",GELO_METHOD_BIT_GRID);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%df Lattice Heuristic\n",GELO_METHOD_BIT_LATTICE);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%df Rectangular          ",GELO_METHOD_BIT_GIOTTO);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%df Simulated Annealing\n",GELO_METHOD_BIT_ANNEAL);
   strcat(menu,buf);
   strcat(menu,"\n");

   strcat(menu,"Options to be applied:\n");
   sprintf(buf,"   %%3.%df 2-way layout         ",GELO_METHOD_BIT_2WAY);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%df Local Optimization ",GELO_METHOD_BIT_OPT);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%df Forward arcs only \n",GELO_METHOD_BIT_FWD);
   strcat(menu,buf);
   sprintf(buf,"   %%3.%df Variation 1             %%3.%df Variation 2     ",
	      GELO_METHOD_BIT_VAR0,GELO_METHOD_BIT_VAR1);
   strcat(menu,buf);
   sprintf(buf,"      %%3.%df Variation 3\n   %%3.%df Variation 4       ",
	      GELO_METHOD_BIT_VAR2,GELO_METHOD_BIT_VAR3);
   strcat(menu,buf);
   sprintf(buf,"      %%3.%df Option 1\n",GELO_METHOD_BIT_VAR4);
   strcat(menu,buf);
   strcat(menu,"\n");

   dir = (mthd & (GELO_METHOD_BIT_HOR|GELO_METHOD_BIT_VERT));
   if (dir == (GELO_METHOD_BIT_HOR|GELO_METHOD_BIT_VERT)) dir = 0;
   else if (dir & GELO_METHOD_BIT_HOR) dir = 1;
   else if (dir & GELO_METHOD_BIT_VERT) dir = 2;
   else dir = 0;
   strcat(menu,"Layout  Direction:\n");
   strcat(menu,"   %6.0o For best fit         ");
   strcat(menu,"   %6.1o Horizontal            %6.2o Vertical\n");
   strcat(menu,"\n");

   cmthd = (Integer) *cmthdp;
   strcat(menu,"Connection Method:\n");
   strcat(menu,"   %4.0o Routed Connections      %4.1o Direct Connections ");
   strcat(menu,"   %4.2o Best Connections\n\n");

   if (whitep != NULL) {
      white = *whitep;
      strcat(menu,"White space: %5d\n\n");
    };

   strcat(menu,"   %a%M   %c");

   if (!STEMdialog1(w,menu,&fix,&std,&cen,&mthd,&cmthd,&white,&dir)) {
      return FALSE;
    };

   mthd |= userbits;
   mthd &= ~ (GELO_METHOD_BIT_HOR|GELO_METHOD_BIT_VERT);
   if (dir == 1) mthd |= GELO_METHOD_BIT_HOR;
   else if (dir == 2) mthd |= GELO_METHOD_BIT_VERT;

   if (fixp != NULL && stdp != NULL && ctrp != NULL) {
      *fixp = fix;
      *stdp = std;
      *ctrp = cen;
    };

   *mthdp = mthd;
   *cmthdp = (GELO_CONN_METHOD) cmthd;

   if (whitep != NULL) {
      *whitep = white;
    };

   return TRUE;
};





/* end of geloutil.c */
