/************************************************************************/
/*									*/
/*		gelosolve.c						*/
/*									*/
/*	Equation solver for GELO					*/
/*									*/
/************************************************************************/
/*	Copyright 1985 Brown University -- Steven P. Reiss		*/


#include "gelo_local.h"






/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	Access macro definitions					*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Local type definitions						*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Table definitions						*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	GELO_solve_init -- module initialization			*/
/*									*/
/************************************************************************/


void
GELO_solve_init()
{
   ITRACE("GELO_solve_init");
};





/************************************************************************/
/*									*/
/*	GELO_solve_system -- solve positive system for tiling		*/
/*									*/
/************************************************************************/


#define mat(x,y)	matp[x*ncol+y]
#define origmat(x,y)	origmatp[x*ncol+y]

void
GELO_solve_system(nrow,ncol,nuse,matp,rhs,soln)
   Integer nrow,ncol,nuse;
   float *matp;
   Float rhs[];
   Float soln[];
{
   register Integer i,j,k,l;
   Boolean redo;
   Float rowtot,minval,z;
   Integer minrow;
   Integer ct;
   float * origmatp;
   float * origrhs;
   float * origtot;
   Integer * numelt;
   Integer * origct;
   Integer * vstate;

   ITRACE("GELO_solve_system %d %d",nrow,ncol);

   origmatp = (float *) alloca(ncol*nrow*sizeof(float));
   origrhs = (float *) alloca((nrow+10)*sizeof(float));
   origtot = (float *) alloca((nrow+10)*sizeof(float));
   numelt = (Integer *) alloca((nrow+10)*sizeof(Integer));
   origct = (Integer *) alloca((nrow+10)*sizeof(Integer));
   vstate = (Integer *) alloca((ncol+10)*sizeof(Integer));

   IFTRACE {
      printf("\nGELO: matrix is:\n\n");
      for (i = 0; i < nrow; ++i) {
	 printf("\t%f = ",rhs[i]);
	 for (j = 0; j < ncol; ++j) {
	    printf("\t%f",mat(i,j));
	    if (j+1 != ncol && (j%4) == 3) printf("\n\t\t");
	  };
	 printf("\n");
       };
    };

   for (i = 0; i < ncol; ++i) vstate[i] = 0;

   for (i = 0; i < nrow; ++i) {
      origrhs[i] = rhs[i];
      origtot[i] = 0.0;
      numelt[i] = 0;
      origct[i] = 0;
      for (j = 0; j < ncol; ++j) {
	 z = mat(i,j);
	 origmat(i,j) = z;
	 if (z != 0) {
	    origtot[i] += z;
	    ++numelt[i];
	    ++origct[i];
	  };
       };
    };

   for (i = 0; i < nrow; ++i) {
      for (j = 0; j < ncol; ++j) {
	 if (mat(i,j) != 0) break;
       };
      if (j >= ncol) continue;
      for (k = 0; k < nrow; ++k) {
	 if (k != i && mat(k,j) != 0) {
	    z = mat(k,j)/mat(i,j);
	    for (l = 0; l < ncol; ++l) {
	       if (mat(k,l) == 0.0) ++numelt[k];
	       mat(k,l) -= z*mat(i,l);
	       if (mat(k,l) == 0.0) --numelt[k];
	     };
	    rhs[k] -= z*rhs[i];
	  };
       };
    };

   ct = ncol;

   while (ct > 0) {
      IFTRACE {
	 printf("\nGELO: Next pass:\n\n");
	 for (i = 0; i < nrow; ++i) {
	    printf("\t%f = ",rhs[i]);
	    for (j = 0; j < ncol; ++j) {
	       printf("\t%f",mat(i,j));
	       if (j+1 != ncol && (j%4) == 3) printf("\n\t\t");
	     };
	    printf("\n");
	  };
       };

      redo = TRUE;
      while (redo && ct > 0) {
	 redo = FALSE;
	 minrow = -1;
	 minval = 0.0;
	 for (i = 0; i < nrow; ++i) {
	    if (numelt[i] == 1) {
	       for (j = 0; j < ncol; ++j) {
		  if (mat(i,j) != 0) {
		     soln[j] = rhs[i]/mat(i,j);
		     vstate[j] = 1;
		     redo = TRUE;
		     break;
		   };
		};
	     }
	    else if (origct[i] > 0 && i < nuse) {
	       rowtot = origrhs[i]/origtot[i];
	       if (minrow == -1 || rowtot < minval) {
		  minrow = i;
		  minval = rowtot;
		};
	     };
	  };

	 if (redo) {
	    for (j = 0; j < ncol; ++j) {
	       if (vstate[j] == 1) {
		  for (i = 0; i < nrow; ++i) {
		     if (mat(i,j) != 0.0) {
			rhs[i] -= mat(i,j)*soln[j];
			mat(i,j) = 0.0;
			--numelt[i];
		      };
		     if (origmat(i,j) != 0) {
			origrhs[i] -= origmat(i,j)*soln[j];
			origtot[i] -= origmat(i,j);
			--origct[i];
		      };
		   };
		  --ct;
		  vstate[j] = 2;
		};
	     };
	  };
       };

      if (ct <= 0) break;

      if (minrow < 0) {
	 for (i = 0; i < ncol; ++i) {
	    if (vstate[i] == 0) {
	       soln[i] = 1.0;
	       vstate[i] = 2;
	       --ct;
	     };
	  };
	 break;
       };

      redo = FALSE;
      for (j = ncol-1; j >= 0 && !redo; --j) {
	 if (vstate[j] == 0 && origmat(minrow,j) != 0.0) {
	    soln[j] = minval;
	    for (i = 0; i < nrow; ++i) {
	       if (mat(i,j) != 0.0) {
		  rhs[i] -= mat(i,j)*soln[j];
		  mat(i,j) = 0.0;
		  --numelt[i];
		  if (numelt[i] == 1 && i != minrow) redo = TRUE;
		};
	       if (origmat(i,j) != 0) {
		  origrhs[i] -= origmat(i,j)*soln[j];
		  origtot[i] -= origmat(i,j);
		  --origct[i];
		};
	     };
	    --ct;
	    vstate[j] = 2;
	    break;		/* can we eliminate this??? */
	  };
       };

      if (!redo && j < 0) {
	 for (i = 0; i < ncol; ++i) {
	    if (vstate[i] == 0) {
	       soln[i] = 1.0;
	       vstate[i] = 2;
	       --ct;
	     };
	  };
	 break;
       };
    };

   IFTRACE {
      printf("GELO: solution is:\n\n");
      for (i = 0; i < ncol; ++i) {
	 printf("\t%f\n",soln[i]);
       };
      printf("\nGELO: remainder is:\n");
      for (i = 0; i < nrow; ++i) {
	 printf("\t%f\n",origrhs[i]);
       };
    };
};





/* end of gelosolve.c */



