/************************************************************************/
/*									*/
/*		gelomain.c						*/
/*									*/
/*	Main module for GELO general layout package			*/
/*									*/
/************************************************************************/
/*	Copyright 1985 Brown University -- Steven P. Reiss		*/


#define GELO_MAIN

#include "gelo_local.h"






/************************************************************************/
/*									*/
/*	Variable definitions						*/
/*									*/
/************************************************************************/


	Boolean 	GELO__initedflag = FALSE;
	Integer 	GELO__tracelvl = 0;

	PROT_DECL;




/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


#ifdef	LIB
static			gelo_cleanup();
#endif




/************************************************************************/
/*									*/
/*	GELOinit -- initialize the module				*/
/*									*/
/************************************************************************/


void
GELOinit()
{
   ITRACE("GELOinit");

   PROT_INIT;

   PROTECT;
   if (!GELO__initedflag) {
#ifdef LIB
      BROWNregister_cleanup(gelo_cleanup);
#endif

      GELO_object_init();
      GELO_win_init();
      GELO_conn_init();
      GELO_heur_init();

      GELO_empty_init();
      GELO_data_init();
      GELO_tiled_init();
      GELO_layout_init();
      GELO_arc_init();
      GELO_grid_init();
      GELO_giotto_init();
      GELO_util_init();
      GELO_level_init();

      GELO__initedflag = TRUE;
    };
   UNPROTECT;
};





#ifdef LIB
static
gelo_cleanup()
{
   GELO__tracelvl = 0;
   GELO__initedflag = 0;
};
#endif





/************************************************************************/
/*									*/
/*	GELOtrace -- set tracing level					*/
/*									*/
/************************************************************************/


void
GELOtrace(lvl)
   Integer lvl;
{
   GELO__tracelvl = lvl;
};






/************************************************************************/
/*									*/
/*	GELO_trace -- output trace information				*/
/*									*/
/************************************************************************/


void
GELO_trace(msg,a1,a2,a3,a4,a5,a6,a7,a8,a9,b0,b1,b2,b3,b4,b5)
   String msg;
   Integer a1,a2,a3,a4,a5,a6,a7,a8,a9,b0,b1,b2,b3,b4,b5;
{
   Character mbf[1024];

   sprintf(mbf,msg,a1,a2,a3,a4,a5,a6,a7,a8,a9,b0,b1,b2,b3,b4,b5);

   printf("GELO: %s\n",mbf);
};






/************************************************************************/
/*									*/
/*	GELO_error -- handle error condition for GELO		       */
/*									*/
/************************************************************************/


void
GELO_error(msg)
   String msg;
{
   fprintf(stderr,"GELO: ERROR: %s\n",msg);
   fflush(stderr);
};





/* end of gelomain.c */
