/************************************************************************/
/*									*/
/*		gelogrid.c						*/
/*									*/
/*	Inteface to GELO grid and layout heuristics package		*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "gelo_local.h"
#include "gelo_layout.h"






/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define GRID_PATH	"%s/bin/pertlayout"




/************************************************************************/
/*									*/
/*	Type definitions						*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	Boolean 	output_graph();
static	Integer 	assign_ids();
static	Boolean 	input_graph();





/************************************************************************/
/*									*/
/*	GELO_grid_init -- module initialization 			*/
/*									*/
/************************************************************************/


void
GELO_grid_init()
{
};




/************************************************************************/
/*									*/
/*	GELO_grid_layout -- layout a graph using PERT heuristics	*/
/*									*/
/************************************************************************/


Boolean
GELO_grid_layout(o,mthd)
   GELO_OBJECT o;
   GELO_METHOD mthd;
{
   Character infil[64],otfil[64],cmd[256],sys[128],mbuf[32];
   FILE * inf;
   FILE * otf;
   Boolean fg;
   Integer pid;

   strcpy(infil,"/tmp/gelogridXXXXXX");
   mktemp(infil);
   sprintf(otfil,"%s.out",infil);
   sprintf(sys,GRID_PATH,BWEbwe_project(),BWEarch());
   sprintf(mbuf,"%d",mthd);
   sprintf(cmd,"%s -m %d %s %s",sys,mthd,infil,otfil);

   inf = fopen(infil,"w");
   if (inf == NULL) return FALSE;

   fg = output_graph(o,mthd,inf);

   fclose(inf);

   if (fg) {
      if ((pid = vfork()) == 0) {
	 execl(sys,"pertlayout","-m",mbuf,infil,otfil,0);
	 _exit(127);
       };

      while (getpgrp(pid) > 0) CMPXselect(0);

      otf = fopen(otfil,"r");

      if (otf != NULL && input_graph(o,otf)) fg = TRUE;
      else fg = FALSE;

      if (otf != NULL) fclose(otf);
    };

   unlink(infil);
   unlink(otfil);

   return fg;
};





/************************************************************************/
/*									*/
/*	output_graph -- write graph description to file for pertlayout	*/
/*									*/
/************************************************************************/


static Boolean
output_graph(o,mthd,otf)
   GELO_OBJECT o;
   GELO_METHOD mthd;
   FILE * otf;
{
   Integer ct;
   Sequence l;
   COMPONENT * c, * c1;
   GELO_CONNECT conn;

   ct = 0;
   forin (conn,GELO_CONNECT,l,CONNECTS(o)) {
      c = (COMPONENT *) GELO_conn_inq_from_data(conn);
      if (c == NULL) continue;
      c1 = (COMPONENT *) GELO_conn_inq_to_data(conn);
      if (c1 == NULL) continue;
      if (c != c1) ++ct;
    };

   fprintf(otf,"%d %d\n",LENGTH(COMPONENTS(o)),ct);

   forin (c,COMPONENT *,l,COMPONENTS(o)) {
      c->data = (Universal) -1;
    };

   ct = 1;
   forin (c,COMPONENT *,l,COMPONENTS(o)) {
      ct = assign_ids(c,ct,mthd);
    };

   forin (c,COMPONENT *,l,COMPONENTS(o)) {
      fprintf(otf,"0x%x %d\n",c,c->data);
    };

   forin (conn,GELO_CONNECT,l,CONNECTS(o)) {
      c = (COMPONENT *) GELO_conn_inq_from_data(conn);
      if (c == NULL) continue;
      c1 = (COMPONENT *) GELO_conn_inq_to_data(conn);
      if (c1 == NULL) continue;
      if (c == c1) continue;
      fprintf(otf,"0x%x 0x%x 0x%x\n",conn,c,c1);
    };

   return TRUE;
};






/************************************************************************/
/*									*/
/*	assign_ids -- dfs to assign id numbers to nodes 		*/
/*									*/
/************************************************************************/


static Integer
assign_ids(v,ct,mthd)
   COMPONENT * v;
   Integer ct;
   GELO_METHOD mthd;
{
   Sequence l,la;
   COMPONENT * v1;
   COMPONENT * c1;
   GELO_CONNECT conn;

   if (((Integer) v->data) >= 0) return ct;

   v->data = (Universal) (ct++);

   if (mthd & GELO_METHOD_BIT_2WAY) la = v->all_arcs;
   else la = v->from_arcs;

   forin (conn,GELO_CONNECT,l,la) {
      c1 = (COMPONENT *) GELO_conn_inq_to_data(conn);
      if (c1 == v) c1 = (COMPONENT *) GELO_conn_inq_from_data(conn);
      if (c1 != NULL && !c1->done) {
	 ct = assign_ids(c1,ct,mthd);
       };
    };

   return ct;
};





/************************************************************************/
/*									*/
/*	input_graph -- get input from pertlayout			*/
/*									*/
/************************************************************************/


static Boolean
input_graph(o,inf)
   GELO_OBJECT o;
   FILE * inf;
{
   COMPONENT * c;
   Sequence l;
   GELO_CONNECT conn;
   Character buf[10240];
   Integer x,y;
   String s;

   forin (c,COMPONENT *,l,COMPONENTS(o)) {
      if (!c->done) c->pos_x = -1;
    };

   while (fgets(buf,10240,inf) != NULL) {
      if (buf[0] == 'N') {
	 if (sscanf(buf,"Node 0x%x %d %d",&c,&x,&y) != 3) return FALSE;
	 c->pos_x = x;
	 c->pos_y = y;
       }
      else if (buf[0] == 'C') {
	 if (sscanf(buf,"Conn 0x%x",&conn) != 1) return FALSE;
	 GELO_clear_pivots(conn);
	 s = index(buf,' ');
	 ++s;
	 s = index(s,' ');
	 if (s != NULL) ++s;
	 while (s != NULL) {
	    if (sscanf(s,"%d %d",&x,&y) != 2) return FALSE;
	    GELO_connect_pivot(conn,x,y);
	    s = index(s,' ');
	    ++s;
	    s = index(s,' ');
	    if (s != NULL) ++s;
	  };
       };
    };

   forin (c,COMPONENT *,l,COMPONENTS(o)) {
      if (!c->done && c->pos_x < 0) return FALSE;
    };

   return TRUE;
};





/* end of gelogrid.c */
