/************************************************************************/
/*									*/
/*		geloempty.c						*/
/*									*/
/*	EMPTY flavor object routines for GELO				*/
/*									*/
/************************************************************************/
/*	Copyright 1985 Brown University -- Steven P. Reiss		*/


#include "gelo_local.h"






/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MIN_X_SIZE	3
#define MIN_Y_SIZE	3

#define INSIDE_BOX_SIZE 3






/************************************************************************/
/*									*/
/*	Access macro definitions					*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Local type definitions						*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Table definitions						*/
/*									*/
/************************************************************************/


/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


static	GELO_ATTR_DATA_B	empty_attrs[] = {
   { NULL }
};





/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	Boolean 	gelo_empty_size();
static	void		gelo_empty_layout();
static	void		gelo_empty_draw();
static	Boolean 	gelo_empty_compare();





/************************************************************************/
/*									*/
/*	GELO_empty_init -- module initialization			*/
/*									*/
/************************************************************************/


void
GELO_empty_init()
{
   ITRACE("GELO_empty_init");

   GELO_flavor_define(GELO_FLAVOR_EMPTY,
			 "EMPTY",
			 empty_attrs,
			 gelo_empty_size,
			 gelo_empty_layout,
			 gelo_empty_draw,
			 NULL,NULL,NULL,NULL,NULL,
			 gelo_empty_compare);
};





/************************************************************************/
/*									*/
/*	gelo_empty_size -- set sizes for an EMPTY object		*/
/*									*/
/************************************************************************/


static Boolean
gelo_empty_size(o,mxx,mxy)
   GELO_OBJECT o;
   Integer mxx,mxy;
{
   ITRACE("gelo_empty_size 0x%x %d %d",o,mxx,mxy);

   if (MIN_X_SIZE > mxx || MIN_Y_SIZE > mxy) return FALSE;

   GELO_set_x_size(o,MIN_X_SIZE);
   GELO_set_y_size(o,MIN_Y_SIZE);
   GELO_set_x_min_size(o,MIN_X_SIZE);
   GELO_set_y_min_size(o,MIN_Y_SIZE);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	gelo_empty_layout -- layout an EMPTY object			*/
/*									*/
/************************************************************************/


static void
gelo_empty_layout(gw,o)
   GELO_WINDOW gw;
   GELO_OBJECT o;
{
   DTRACE("gelo_empty_layout 0x%x 0x%x",gw,o);
};





/************************************************************************/
/*									*/
/*	gelo_empty_draw -- draw a data object				*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static void
gelo_empty_draw(gw,o,hifg)
   GELO_WINDOW gw;
   GELO_OBJECT o;
   GELO_DRAW_FLAGS hifg;
{
   Integer lx,by,rx,ty;
   Integer dx,dy;
   ASH_COLOR fgd,bgd,dfgd,dbgd;

   ITRACE("gelo_empty_draw 0x%x 0x%x",gw,o);

   if (!GELO_inq_position(gw,o,&lx,&by,&rx,&ty)) return;

   fgd = ASHinq_color(gw->window);
   bgd = ASHinq_background_color(gw->window);

   if (hifg == GELO_DRAW_HILITE) {
      dfgd = fgd;
      dbgd = bgd;
    }
   else if (o->flavor == GELO_FLAVOR_DATA || o->flavor == GELO_FLAVOR_TILED) {
      if (GELO__data_fg == NULL) dfgd = fgd;
      else dfgd = ASHlookup_color(gw->window,GELO__data_fg);
      if (GELO__data_bg == NULL) dbgd = bgd;
      else dbgd = ASHlookup_color(gw->window,GELO__data_bg);
    }
   else {
      dfgd = fgd;
      dbgd = bgd;
    };

   ASHcolor(gw->window,dfgd);
   ASHbackground_color(gw->window,dbgd);

   ASHclear_box(gw->window,lx,by,rx,ty);
   ASHbox(gw->window,lx,by,rx,ty);

#ifdef INSIDE_BOX_SIZE
   dx = (rx - lx - INSIDE_BOX_SIZE - 1)/2;
   dy = (by - ty - INSIDE_BOX_SIZE - 1)/2;
   if (dx > 0 && dy > 0) {
      dx += lx;
      dy += ty;
      ASHrectangle(gw->window,dx,dy+INSIDE_BOX_SIZE-1,dx+INSIDE_BOX_SIZE-1,dy);
    };
#endif

   ASHcolor(gw->window,fgd);
   ASHbackground_color(gw->window,bgd);
};





/************************************************************************/
/*									*/
/*	gelo_empty_compare -- compare two empty objects 		*/
/*									*/
/************************************************************************/


/*ARGSUSED*/

static Boolean
gelo_empty_compare(o1,o2,o1p,o2p)
   GELO_OBJECT o1;
   GELO_OBJECT o2;
   GELO_OBJECT *o1p;
   GELO_OBJECT *o2p;
{
   return TRUE;
};





/* end of geloempty.c */


