/************************************************************************/
/*									*/
/*		geloarc.c						*/
/*									*/
/*	ARC flavor object routines for GELO				*/
/*									*/
/************************************************************************/
/*	Copyright 1985 Brown University -- Steven P. Reiss		*/


#include "gelo_local.h"






/************************************************************************/
/*									*/
/*	Access macro definitions					*/
/*									*/
/************************************************************************/


#define CONNECT(o)	((GELO_CONNECT) ((o)->attributes[GELO_ARC_ATTR_CONNECT]))





/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


static	GELO_ATTR_DATA_B	arc_attrs[] = {
   { "CONNECT" },
   { NULL }
};





/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	Boolean 	gelo_arc_size();
static	void		gelo_arc_layout();
static	void		gelo_arc_draw();
static	GELO_OBJECT	gelo_arc_correlate();
static	Boolean 	gelo_arc_hilite();
static	Boolean 	gelo_arc_compare();




/************************************************************************/
/*									*/
/*	GELO_arc_init -- module initialization				*/
/*									*/
/************************************************************************/


void
GELO_arc_init()
{
   ITRACE("GELO_empty_init");

   GELO_flavor_define(GELO_FLAVOR_ARC,
			 "ARC",
			 arc_attrs,
			 gelo_arc_size,
			 gelo_arc_layout,
			 gelo_arc_draw,
			 NULL,NULL,gelo_arc_correlate,gelo_arc_hilite,NULL,
			 gelo_arc_compare);
};





/************************************************************************/
/*									*/
/*	gelo_arc_size -- set sizes for an ARC object			*/
/*									*/
/************************************************************************/


static Boolean
gelo_arc_size(o,mxx,mxy)
   GELO_OBJECT o;
   Integer mxx,mxy;
{
   ITRACE("gelo_arc_size 0x%x %d %d",o,mxx,mxy);

   GELO_set_x_size(o,1);
   GELO_set_y_size(o,1);
   GELO_set_x_min_size(o,1);
   GELO_set_y_min_size(o,1);

   return TRUE;
};





/************************************************************************/
/*									*/
/*	gelo_arc_layout -- layout an ARC object 			*/
/*									*/
/************************************************************************/


static void
gelo_arc_layout(gw,o)
   GELO_WINDOW gw;
   GELO_OBJECT o;
{
   DTRACE("gelo_arc_layout 0x%x 0x%x",gw,o);
};





/************************************************************************/
/*									*/
/*	gelo_arc_draw -- draw a arc object				*/
/*									*/
/************************************************************************/


static void
gelo_arc_draw(gw,o,hifg)
   GELO_WINDOW gw;
   GELO_OBJECT o;
   GELO_DRAW_FLAGS hifg;
{
   ITRACE("gelo_arc_draw 0x%x 0x%x",gw,o);

   if (hifg != GELO_DRAW_NORM) {
      GELO_draw_connect(gw,CONNECT(o),hifg);
    };
};





/************************************************************************/
/*									*/
/*	gelo_arc_correlate -- correlate with an arc object		*/
/*									*/
/************************************************************************/


static GELO_OBJECT
gelo_arc_correlate(gw,o,x,y)
   GELO_WINDOW gw;
   GELO_OBJECT o;
   Integer x,y;
{
   ITRACE("gelo_arc_correlate 0x%x 0x%x %d %d",gw,o,x,y);

   if (!GELO_connect_correlate(gw,CONNECT(o),x,y)) return NULL;

   return o;
};





/************************************************************************/
/*									*/
/*	gelo_arc_hilite -- hilight an arc object			*/
/*									*/
/************************************************************************/


static Boolean
gelo_arc_hilite(gw,o,sty,fg)
   GELO_WINDOW gw;
   GELO_OBJECT o;
   Integer sty;
   Boolean fg;
{
   ITRACE("gelo_arc_hilite 0x%x 0x%x %d %d",gw,o,sty,fg);

   if (ASHinq_configuration_depth(ASHinq_top()) == 1) {
      GELO_hilite_connect(gw,CONNECT(o),sty);
    }
   else {
      return FALSE;
    };

   return TRUE;
};





/************************************************************************/
/*									*/
/*	gelo_arc_compare -- compare two arc objects			*/
/*									*/
/************************************************************************/


static Boolean
gelo_arc_compare(o1,o2,o1p,o2p)
   GELO_OBJECT o1,o2;
   GELO_OBJECT * o1p, * o2p;
{
   register Boolean fg;

   ITRACE("gelo_arc_compare 0x%x 0x%x",o1,o2);

   fg = GELO_connect_compare(CONNECT(o1),CONNECT(o2));

   if (!fg) {
      *o1p = o1;
      *o2p = o2;
    };

   return fg;
};





/* end of geloarc.c */


