/************************************************************************/
/*									*/
/*		gelo_local.h						*/
/*									*/
/*	Local definitions for the GELO general layout package		*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#define PROT_NAME	GELO__sema
#include <bwethread.h>

#include <ctype.h>
#include <DATATYPES.h>
#include <sequence.h>
#include <gelo.h>
#include <ash.h>




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MAT_SIZE	256
#define MIN_COMPONENT_SIZE	3
#define MAX_SEQ_PORTS	16





/************************************************************************/
/*									*/
/*	Data Type Definitions						*/
/*									*/
/************************************************************************/


typedef struct _GELO_WINDOW *	GELO_WINDOW;
typedef struct _GELO_SOURCE *	GELO_SOURCE;
typedef struct _GELO_ATTR_DATA *GELO_ATTR_DATA;


typedef struct _GELO_SOURCE {
   Universal	object;
   Universal	field;
   Universal	index;
   Universal	type;
} GELO_SOURCE_B;




typedef struct _GELO_OBJECT {
   GELO_FLAVOR	flavor;
   GELO_OBJECT	parent;
   GELO_OBJECT	son;
   GELO_OBJECT	brother;
   GELO_COORD	x_size,y_size;
   GELO_COORD	x_min_size,y_min_size;
   GELO_COORD	x_pos,y_pos;
   float	priority_x;
   float	priority_y;
   Boolean	layout_valid;
   Boolean	too_small;
   Boolean	use_min;
   Boolean	use_default_x;
   Boolean	use_default_y;
   Boolean	zero_size_x;
   Boolean	zero_size_y;
   Universal *	attributes;
   Universal	owner;
   Universal	object;
   Universal	contents;
   GELO_SOURCE_B source;
} GELO_OBJECT_B;




typedef struct _GELO_WINDOW {
   ASH_WINDOW	realwindow;
   ASH_WINDOW	window;
   GELO_OBJECT	object;
   Sequence	select;
   Integer	real_lx,real_by,real_rx,real_ty;
   Integer	view_lx,view_by,view_rx,view_ty;
   Integer	world_x,world_y;
   Boolean	size_valid;
} GELO_WINDOW_B;





typedef struct _GELO_ATTR_DATA {
   String	name;
} GELO_ATTR_DATA_B;




typedef enum _GELO_DRAW_FLAGS {
   GELO_DRAW_NORM,
   GELO_DRAW_HILITE,
   GELO_DRAW_HILITE_OFF,
} GELO_DRAW_FLAGS;





/************************************************************************/
/*									*/
/*	Tracing Definitions						*/
/*									*/
/************************************************************************/


extern	Boolean 	GELO__initedflag;
extern	Integer 	GELO__tracelvl;


#define TRACE if (GELO__tracelvl & GELO_TRACE_ON) GELO_trace
#define ITRACE if (GELO__tracelvl & GELO_TRACE_INT) GELO_trace
#define DTRACE if (GELO__tracelvl & GELO_TRACE_DBG) GELO_trace
#define IFTRACE if (GELO__tracelvl & GELO_TRACE_SPL)

#define ERROR(m) GELO_error(m)
#define FATAL(m) { ERROR(m); ABORT; }
#define ABORT	 abort()

#define CHECKINIT if (!GELO__initedflag) GELOinit()
#define ENTER	CHECKINIT; TRACE




/************************************************************************/
/*									*/
/*	Module symbols							*/
/*									*/
/************************************************************************/


extern	String		GELO__data_fg;
extern	String		GELO__data_bg;





/************************************************************************/
/*									*/
/*	Internal entries						*/
/*									*/
/************************************************************************/


extern	void		GELOinit();
extern	void		GELO_trace();
extern	void		GELO_error();

extern	void		GELO_win_init();
extern	void		GELO_deselect();
extern	Boolean 	GELO_inq_position();
extern	Boolean 	GELO_scale_position();

extern	void		GELO_object_init();
extern	void		GELO_set_too_small();
extern	int		GELO_size();
extern	void		GELO_layout();
extern	void		GELO_relayout();
extern	void		GELO_draw();
extern	void		GELO_set_x_size();
extern	void		GELO_set_y_size();
extern	GELO_COORD	GELO_inq_x_size();
extern	GELO_COORD	GELO_inq_y_size();
extern	void		GELO_set_x_min_size();
extern	void		GELO_set_y_min_size();
extern	GELO_COORD	GELO_inq_x_min_size();
extern	GELO_COORD	GELO_inq_y_min_size();
extern	void		GELO_set_x_position();
extern	void		GELO_set_y_position();
extern	GELO_COORD	GELO_inq_x_position();
extern	GELO_COORD	GELO_inq_y_position();
extern	GELO_COORD	GELO_inq_absolute_x_position();
extern	GELO_COORD	GELO_inq_absolute_y_position();
extern	GELO_FLAVOR	GELO_flavor_define();
extern	GELO_OBJECT	GELO_replace_object();
extern	void		GELO_object_free();
extern	GELO_OBJECT	GELO_test_correlate();
extern	void		GELO_hilite();
extern	void		GELO_inq_port_offset();
extern	Boolean 	GELO_object_compare();

extern	void		GELO_empty_init();
extern	void		GELO_data_init();
extern	void		GELO_data_inq_port_offset();
extern	void		GELO_tiled_init();
extern	void		GELO_layout_init();
extern	GELO_CONNECT	GELO_layout_connect_correlate();
extern	void		GELO_arc_init();

extern	void		GELO_heur_init();
extern	void		GELO_heur_layout();
extern	void		GELO_heur_connect();

extern	void		GELO_solve_init();
extern	void		GELO_solve_system();

extern	void		GELO_conn_init();
extern	void		GELO_connect_pivot();
extern	void		GELO_clear_pivots();
extern	Sequence	GELO_connect_inq_pivots();
extern	void		GELO_draw_connections();
extern	void		GELO_draw_connect();
extern	void		GELO_hilite_connect();
extern	GELO_CONNECT	GELO_connect_list_correlate();
extern	Boolean 	GELO_connect_correlate();
extern	GELO_OBJECT	GELO_inq_connect_from();
extern	GELO_OBJECT	GELO_inq_connect_to();
extern	GELO_PORT	GELO_inq_connect_from_port();
extern	GELO_PORT	GELO_inq_connect_to_port();
extern	Boolean 	GELO_inq_connect_from_location();
extern	Boolean 	GELO_inq_connect_to_location();
extern	void		GELO_conn_set_from_data();
extern	void		GELO_conn_set_to_data();
extern	String		GELO_conn_inq_from_data();
extern	String		GELO_conn_inq_to_data();
extern	void		GELO_conn_set_ports();
extern	Integer 	GELO_conn_inq_from_subport();
extern	void		GELO_conn_set_from_subport();
extern	Integer 	GELO_conn_inq_to_subport();
extern	void		GELO_conn_set_to_subport();
extern	void		GELO_free_connects();
extern	GELO_PORT	GELO_portal_location();
extern	void		GELO_connect_replace();
extern	Sequence	GELO_connect_elim();
extern	Boolean 	GELO_connect_compare();

extern	void		GELO_pert_init();
extern	Boolean 	GELO_pert_layout();

extern	void		GELO_giotto_init();
extern	Boolean 	GELO_giotto_layout();

extern	void		GELO_level_init();
extern	Boolean 	GELO_level_layout();

extern	void		GELO_util_init();






/* end of gelo_local.h */
