/************************************************************************/
/*									*/
/*		gelo_layout.h						*/
/*									*/
/*	Definitions for layout objects					*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MAX_COMPONENTS	256
#define MAX_CONNECT	1024
#define MIN_SIZE	10
#define DEFAULT_WHITE_SPACE 75
#define DEFAULT_WHITE_SPACE_NOCONN	10
#define DEFAULT_WHITE_SPACE_PERT	20
#define MIN_WHITE_SPACE 1




/************************************************************************/
/*									*/
/*	Access macro definitions					*/
/*									*/
/************************************************************************/


#define METHOD(o)	((GELO_METHOD) ((o)->attributes[0]))
#define CONNMETHOD(o)	((GELO_CONN_METHOD) ((o)->attributes[1]))
#define SHRINKAGE(o)	((Integer) ((o)->attributes[2]))
#define WHITE_SPACE(o)	((Integer) ((o)->attributes[3]))
#define BOX(o)		((Integer) ((o)->attributes[4]))
#define COMPONENTS(o)	((Sequence) ((o)->attributes[5]))
#define SET_COMPONENTS(o,v) ((o)->attributes[5] = (Universal) (v))
#define CONNECTS(o)	((Sequence) ((o)->attributes[6]))
#define SET_CONNECTS(o,v) ((o)->attributes[6] = (Universal) (v))
#define FIXED(o)	((Integer) ((o)->attributes[7]))
#define STANDARD(o)	((Integer) ((o)->attributes[8]))
#define CENTERED(o)	((Integer) ((o)->attributes[9]))





/************************************************************************/
/*									*/
/*	Local type definitions						*/
/*									*/
/************************************************************************/


typedef struct _COMPONENT {
   GELO_OBJECT	object;
   Boolean done;
   Boolean portal;
   GELO_PORT port;
   Integer pos_x;
   Integer pos_y;
   Integer cost;
   Character seqs[4];
   Character seqct[4];
   Sequence from_arcs;
   Sequence to_arcs;
   Sequence all_arcs;
   Universal data;
} COMPONENT;





/* end of gelo_layout.h */
