/************************************************************************/
/*									*/
/*		gelo.h							*/
/*									*/
/*	External definitions for the GELO general layout package	*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

#ifndef GELO_INCLUDED_ALREADY
#define GELO_INCLUDED_ALREADY

#include "ash.h"




/************************************************************************/
/*									*/
/*	Data types							*/
/*									*/
/************************************************************************/


typedef struct _GELO_OBJECT *	GELO_OBJECT;

typedef int			GELO_COORD;

typedef int			GELO_FLAVOR;

typedef int			GELO_ATTRIBUTE;

typedef GELO_OBJECT		(*GELO_FUNCTION)();

typedef struct _GELO_CONNECT * GELO_CONNECT;



typedef enum _GELO_SHAPE {
   GELO_SHAPE_RECTANGLE,
   GELO_SHAPE_NONE,
   GELO_SHAPE_SQUARE,
   GELO_SHAPE_ELLIPSE,
   GELO_SHAPE_CIRCLE,
   GELO_SHAPE_ROUND_RECTANGLE,
   GELO_SHAPE_TRIANGLE_UP,
   GELO_SHAPE_TRIANGLE_DOWN,
   GELO_SHAPE_TRIANGLE_LEFT,
   GELO_SHAPE_TRIANGLE_RIGHT,
   GELO_SHAPE_PENTAGON,
   GELO_SHAPE_HEXAGON,
   GELO_SHAPE_OCTAGON,
   GELO_SHAPE_DIAMOND,
   GELO_SHAPE_NULL_PTR,
   GELO_SHAPE_VLINE,
   GELO_SHAPE_SEMI_UP,
   GELO_SHAPE_SEMI_DOWN,
   GELO_SHAPE_SEMI_LEFT,
   GELO_SHAPE_SEMI_RIGHT,
   GELO_SHAPE_FLD_PTR,
   GELO_SHAPE_TBOX_LEFT,
   GELO_SHAPE_TBOX_RIGHT,
} GELO_SHAPE;


typedef enum _GELO_PORT {
   GELO_PORT_LEFT,
   GELO_PORT_TOP_LEFT,
   GELO_PORT_TOP,
   GELO_PORT_TOP_RIGHT,
   GELO_PORT_RIGHT,
   GELO_PORT_BOTTOM_RIGHT,
   GELO_PORT_BOTTOM,
   GELO_PORT_BOTTOM_LEFT,
   GELO_PORT_CENTER,
   GELO_PORT_ANY,
   GELO_PORT_LEFT_SEQ,
   GELO_PORT_TOP_SEQ,
   GELO_PORT_RIGHT_SEQ,
   GELO_PORT_BOTTOM_SEQ,
   GELO_PORT_USER,
} GELO_PORT;




typedef enum _GELO_ARC_ARROW {
   GELO_ARROW_NONE,
   GELO_ARROW_SINGLE,
   GELO_ARROW_DOUBLE,
   GELO_ARROW_SINGLE_ALL,
   GELO_ARROW_MARK,
   GELO_ARROW_MARK_ALL,
   GELO_ARROW_DMARK,
   GELO_ARROW_DMARK_ALL,
} GELO_ARC_ARROW;



typedef enum _GELO_ARC_LABEL_LOC {
   GELO_LABEL_ANY,
   GELO_LABEL_START,
   GELO_LABEL_MIDDLE,
   GELO_LABEL_END
} GELO_ARC_LABEL_LOC;



typedef enum _GELO_ARC_LABEL_POS {
   GELO_LABEL_NONE,
   GELO_LABEL_CENTER,
   GELO_LABEL_LEFT,
   GELO_LABEL_RIGHT
} GELO_ARC_LABEL_POS;


#define GELO_STYLE_INVIS	((ASH_LINE_STYLE) 128)


typedef int	GELO_METHOD;

#define GELO_METHOD_BIT_DFS	0x1
#define GELO_METHOD_BIT_HOR	0x2
#define GELO_METHOD_BIT_VERT	0x4
#define GELO_METHOD_BIT_2WAY	0x8
#define GELO_METHOD_BIT_INCR	0x10
#define GELO_METHOD_BIT_BFS	0x20
#define GELO_METHOD_BIT_AVG	0x40
#define GELO_METHOD_BIT_FWD	0x80
#define GELO_METHOD_BIT_LEVEL	0x100
#define GELO_METHOD_BIT_OPT	0x200
#define GELO_METHOD_BIT_ANNEAL	0x400

#define GELO_METHOD_BIT_GRID		0x1000
#define GELO_METHOD_BIT_LATTICE 	0x2000
#define GELO_METHOD_PERTBITS		0x3000

#define GELO_METHOD_BIT_GIOTTO		0x4000

#define GELO_METHOD_USER_BITS	0xff0000

#define GELO_METHOD_BIT_VAR0		0x1000000
#define GELO_METHOD_BIT_VAR1		0x2000000
#define GELO_METHOD_BIT_VAR2		0x4000000
#define GELO_METHOD_BIT_VAR3		0x8000000
#define GELO_METHOD_BIT_VAR4		0x10000000
#define GELO_METHOD_BIT_VAR5		0x20000000
#define GELO_METHOD_BIT_VAR6		0x40000000


#define GELO_METHOD_DFS 	(GELO_METHOD_BIT_DFS)
#define GELO_METHOD_HDFS	(GELO_METHOD_BIT_DFS|GELO_METHOD_BIT_HOR)
#define GELO_METHOD_VDFS	(GELO_METHOD_BIT_DFS|GELO_METHOD_BIT_VERT)
#define GELO_METHOD_INCR	(GELO_METHOD_BIT_INCR)
#define GELO_METHOD_DFS2	(GELO_METHOD_DFS|GELO_METHOD_BIT_2WAY)
#define GELO_METHOD_HDFS2	(GELO_METHOD_HDFS|GELO_METHOD_BIT_2WAY)
#define GELO_METHOD_VDFS2	(GELO_METHOD_VDFS|GELO_METHOD_BIT_2WAY)
#define GELO_METHOD_BFS 	(GELO_METHOD_BIT_BFS)
#define GELO_METHOD_HBFS	(GELO_METHOD_BIT_BFS|GELO_METHOD_BIT_HOR)
#define GELO_METHOD_VBFS	(GELO_METHOD_BIT_BFS|GELO_METHOD_BIT_VERT)
#define GELO_METHOD_BFS2	(GELO_METHOD_BFS|GELO_METHOD_BIT_2WAY)
#define GELO_METHOD_HBFS2	(GELO_METHOD_HBFS|GELO_METHOD_BIT_2WAY)
#define GELO_METHOD_VBFS2	(GELO_METHOD_VBFS|GELO_METHOD_BIT_2WAY)
#define GELO_METHOD_AVG 	(GELO_METHOD_BIT_AVG)
#define GELO_METHOD_DAVG	(GELO_METHOD_AVG|GELO_METHOD_BIT_DFS)
#define GELO_METHOD_BAVG	(GELO_METHOD_AVG|GELO_METHOD_BIT_BFS)
#define GELO_METHOD_AVG2	(GELO_METHOD_BIT_AVG|GELO_METHOD_BIT_2WAY)
#define GELO_METHOD_DAVG2	(GELO_METHOD_AVG2|GELO_METHOD_BIT_DFS)
#define GELO_METHOD_BAVG2	(GELO_METHOD_AVG2|GELO_METHOD_BIT_BFS)
#define GELO_METHOD_GRID	(GELO_METHOD_BIT_GRID|GELO_METHOD_BIT_VAR0)
#define GELO_METHOD_GRID2	(GELO_METHOD_GRID|GELO_METHOD_BIT_2WAY)
#define GELO_METHOD_LATTICE	(GELO_METHOD_BIT_LATTICE|GELO_METHOD_BIT_VAR0)
#define GELO_METHOD_LATTICE2	(GELO_METHOD_LATTICE|GELO_METHOD_BIT_2WAY)
#define GELO_METHOD_LEVEL	(GELO_METHOD_BIT_LEVEL|GELO_METHOD_BIT_VAR2|GELO_METHOD_BIT_VAR3)
#define GELO_METHOD_RECT	(GELO_METHOD_BIT_GIOTTO)



typedef enum _GELO_CONN_METHOD {
   GELO_CONN_METHOD_RECT,
   GELO_CONN_METHOD_DIRECT,
   GELO_CONN_METHOD_DIRECT_RECT,
   GELO_CONN_METHOD_PERT,
} GELO_CONN_METHOD;





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/



/************************************************************************/
/*									*/
/*	Definitions for EMPTY object					*/
/*									*/
/************************************************************************/


typedef GELO_OBJECT		GELO_EMPTY_OBJECT;

#define GELO_FLAVOR_EMPTY	0





/************************************************************************/
/*									*/
/*	Definitions for DATA objects					*/
/*									*/
/************************************************************************/


typedef GELO_OBJECT		GELO_DATA_OBJECT;

#define GELO_FLAVOR_DATA	1



#define GELO_DATA_ATTR_SHAPE	0
#define GELO_DATA_ATTR_FILL	1
#define GELO_DATA_ATTR_TEXT	2
#define GELO_DATA_ATTR_INVERT	3
#define GELO_DATA_ATTR_STYLE	4
#define GELO_DATA_ATTR_FONT	5



#define GELOdefine_data()	GELOdefine(GELO_FLAVOR_DATA)

#define GELOdefine_data_shape(o,v)	GELOset_attribute((o),GELO_DATA_ATTR_SHAPE,(v))
#define GELOdefine_data_fill(o,v)	GELOset_attribute((o),GELO_DATA_ATTR_FILL,(v))
#define GELOdefine_data_text(o,v)	GELOset_attribute((o),GELO_DATA_ATTR_TEXT,(v))
#define GELOdefine_data_invert(o,v)	GELOset_attribute((o),GELO_DATA_ATTR_INVERT,(v))
#define GELOdefine_data_style(o,v)	GELOset_attribute((o),GELO_DATA_ATTR_STYLE,(v))
#define GELOdefine_data_font(o,v)	GELOset_attribute((o),GELO_DATA_ATTR_FONT,(v))





/************************************************************************/
/*									*/
/*	Definitions for TILED objects					*/
/*									*/
/************************************************************************/


typedef GELO_OBJECT		GELO_TILED_OBJECT;

#define GELO_FLAVOR_TILED	2



#define GELO_TILED_ATTR_BOX		0
#define GELO_TILED_ATTR_COMPONENTS	1
#define GELO_TILED_ATTR_CONSTRAINTS	2
#define GELO_TILED_ATTR_CONNECTS	3



#define GELOdefine_tiled()	GELOdefine(GELO_FLAVOR_TILED)

#define GELOdefine_tiled_box(o,v)	GELOset_attribute((o),GELO_TILED_ATTR_BOX,(v))
#define GELOdefine_tiled_component(o,s,lx,by,rx,ty,xe,ye,sh)	   \
		GELOadd_son((o),(s));				   \
		GELOadd_attribute((o),GELO_TILED_ATTR_COMPONENTS, \
		   GELOtiled_component((s),(lx),(by),(rx),(ty),(xe),(ye),(sh)))
#define GELOdefine_tiled_constraint(o,s1,d1,s2,d2,m,a)		    \
		GELOadd_attribute((o),GELO_TILED_ATTR_CONSTRAINTS, \
		   GELOtiled_constraint((s1),(d1),(s2),(d2),(m),(a)))
#define GELOdefine_tiled_connect(o,c)			     \
		GELOadd_attribute((o),GELO_TILED_ATTR_CONNECTS,c)





/************************************************************************/
/*									*/
/*	Definitions for LAYOUT objects					*/
/*									*/
/************************************************************************/


typedef GELO_OBJECT		GELO_LAYOUT_OBJECT;

#define GELO_FLAVOR_LAYOUT	3



#define GELO_LAYOUT_ATTR_METHOD 	0
#define GELO_LAYOUT_ATTR_CONN_METHOD	1
#define GELO_LAYOUT_ATTR_SHRINKAGE	2
#define GELO_LAYOUT_ATTR_WHITE_SPACE	3
#define GELO_LAYOUT_ATTR_BOX		4
#define GELO_LAYOUT_ATTR_COMPONENTS	5
#define GELO_LAYOUT_ATTR_CONNECTS	6
#define GELO_LAYOUT_ATTR_FIXED		7
#define GELO_LAYOUT_ATTR_STANDARD	8
#define GELO_LAYOUT_ATTR_CENTERED	9





#define GELOdefine_layout()	GELOdefine(GELO_FLAVOR_LAYOUT)

#define GELOdefine_layout_method(o,v)	GELOset_attribute((o),GELO_LAYOUT_ATTR_METHOD,(v))
#define GELOdefine_layout_conn_method(o,v)   GELOset_attribute((o),GELO_LAYOUT_ATTR_CONN_METHOD,(v))
#define GELOdefine_layout_shrinkage(o,v) GELOset_attribute((o),GELO_LAYOUT_ATTR_SHRINKAGE,(v))
#define GELOdefine_layout_white_space(o,v)	GELOset_attribute((o),GELO_LAYOUT_ATTR_WHITE_SPACE,(v))
#define GELOdefine_layout_box(o,v)     GELOset_attribute((o),GELO_LAYOUT_ATTR_BOX,(v))
#define GELOdefine_layout_fixed(o,v)   GELOset_attribute((o),GELO_LAYOUT_ATTR_FIXED,(v))
#define GELOdefine_layout_standard(o,v)   GELOset_attribute((o),GELO_LAYOUT_ATTR_STANDARD,(v))
#define GELOdefine_layout_centered(o,v)   GELOset_attribute((o),GELO_LAYOUT_ATTR_CENTERED,(v))
#define GELOdefine_layout_component(o,s)	\
		GELOadd_son((o),(s));		 \
		GELOadd_attribute((o),GELO_LAYOUT_ATTR_COMPONENTS, \
		   GELOlayout_component((s)))
#define GELOdefine_layout_portal(o,s,port)	 \
		GELOadd_son((o),(s));		 \
		GELOadd_attribute((o),GELO_LAYOUT_ATTR_COMPONENTS, \
		   GELOlayout_portal((s),(port)))
#define GELOdefine_layout_connect(o,c)				\
		GELOadd_attribute((o),GELO_LAYOUT_ATTR_CONNECTS,c)
#define GELOdefine_layout_arc(o,a)					\
		GELOadd_son((o),(a));					\
		GELOadd_attribute((o),					\
		    GELO_LAYOUT_ATTR_CONNECTS,				\
		    GELOinq_attribute((a),GELO_ARC_ATTR_CONNECT))





/************************************************************************/
/*									*/
/*	Definitions for ARC objects					*/
/*									*/
/************************************************************************/


typedef GELO_OBJECT		GELO_ARC_OBJECT;

#define GELO_FLAVOR_ARC 	4



#define GELO_ARC_ATTR_CONNECT	0



#define GELOdefine_arc()	GELOdefine(GELO_FLAVOR_ARC)

#define GELOdefine_arc_connect(o,v)				\
		GELOconnect_set_arc_object((v),(o));		\
		GELOset_attribute((o),GELO_ARC_ATTR_CONNECT,(v))





/************************************************************************/
/*									*/
/*	Entries 							*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	GELO_OBJECT	GELOdefine();
extern	void		GELOset_notify_fct();
extern	void		GELOset_attribute();
extern	void		GELOadd_attribute();
extern	int		GELOinq_attribute();
extern	void		GELOlayout_validate();
extern	void		GELOadd_son();
extern	void		GELOset_user_structure();
extern	int		GELOinq_user_structure();
extern	void		GELOset_source();
extern	int		GELOinq_source_object();
extern	int		GELOinq_source_field();
extern	int		GELOinq_source_index();
extern	int		GELOinq_source_type();
extern	void		GELOset_contents();
extern	int		GELOinq_contents();
extern	void		GELOset_owner();
extern	GELO_FLAVOR	GELOinq_flavor();
extern	void		GELOset_priority_x();
extern	double		GELOinq_priority_x();
extern	void		GELOset_priority_y();
extern	double		GELOinq_priority_y();
extern	void		GELOuse_min_size();
extern	int		GELOinq_use_min_size();
extern	void		GELOuse_default_x();
extern	int		GELOinq_use_default_x();
extern	void		GELOuse_default_y();
extern	int		GELOinq_use_default_y();
extern	void		GELOuse_zero_size_x();
extern	int		GELOinq_zero_size_x();
extern	void		GELOuse_zero_size_y();
extern	int		GELOinq_zero_size_y();
extern	GELO_OBJECT	GELOinq_parent();

extern	int		GELOtiled_component();
extern	int		GELOtiled_constraint();

extern	int		GELOlayout_component();
extern	int		GELOlayout_portal();
extern	int		GELOinq_layout_heuristics();

extern	void		GELOwindow_open();
extern	void		GELOwindow_draw();
extern	void		GELOwindow_redraw();
extern	void		GELOwindow_set_view();
extern	void		GELOwindow_inq_real();
extern	void		GELOwindow_inq_view();
extern	void		GELOwindow_inq_world();
extern	void		GELOwindow_select();
extern	GELO_OBJECT	GELOcorrelate();
extern	void		GELOwindow_resize_object();
extern	void		GELOwindow_free();
extern	void		GELOwindow_free_except();
extern	void		GELOwindow_replace();
extern	int		GELOcompare();

extern	GELO_CONNECT	GELOnew_connect();
extern	void		GELOconnect_label();
extern	void		GELOconnect_arc_style();
extern	void		GELOconnect_label_style();
extern	void		GELOconnect_port_routine();
extern	void		GELOconnect_set_arc_object();

extern	int		GELOrequest_layout_methods();

extern	void		GELOtrace();

#else

extern "C" {
	GELO_OBJECT	GELOdefine(GELO_FLAVOR);
	void		GELOset_notify_fct(...);
	void		GELOset_attribute(GELO_OBJECT,GELO_ATTRIBUTE ...);
	void		GELOadd_attribute(GELO_OBJECT,GELO_ATTRIBUTE ...);
	int		GELOinq_attribute(GELO_OBJECT,GELO_ATTRIBUTE);
	void		GELOlayout_validate(GELO_OBJECT,int);
	void		GELOadd_son(GELO_OBJECT,GELO_OBJECT);
	void		GELOset_user_structure(GELO_OBJECT ...);
	int		GELOinq_user_structure(GELO_OBJECT);
	void		GELOset_source(GELO_OBJECT ...);
	int		GELOinq_source_object(GELO_OBJECT);
	int		GELOinq_source_field(GELO_OBJECT);
	int		GELOinq_source_index(GELO_OBJECT);
	int		GELOinq_source_type(GELO_OBJECT);
	void		GELOset_contents(GELO_OBJECT ...);
	int		GELOinq_contents(GELO_OBJECT);
	void		GELOset_owner(GELO_OBJECT ...);
	GELO_FLAVOR	GELOinq_flavor(GELO_OBJECT);
	void		GELOset_priority_x(GELO_OBJECT,double);
	double		GELOinq_priority_x(GELO_OBJECT);
	void		GELOset_priority_y(GELO_OBJECT,double);
	double		GELOinq_priority_y(GELO_OBJECT);
	void		GELOuse_min_size(GELO_OBJECT,int);
	int		GELOinq_use_min_size(GELO_OBJECT);
	void		GELOuse_default_x(GELO_OBJECT,int);
	int		GELOinq_use_default_x(GELO_OBJECT);
	void		GELOuse_default_y(GELO_OBJECT,int);
	int		GELOinq_use_default_y(GELO_OBJECT);
	void		GELOuse_zero_size_x(GELO_OBJECT,int);
	int		GELOinq_zero_size_x(GELO_OBJECT);
	void		GELOuse_zero_size_y(GELO_OBJECT,int);
	int		GELOinq_zero_size_y(GELO_OBJECT);
	GELO_OBJECT	GELOinq_parent(GELO_OBJECT);

	int		GELOtiled_component(GELO_OBJECT,int,int,int,int,double,double,double);
	int		GELOtiled_constraint(GELO_OBJECT,GELO_OBJECT,int,int,double,double);

	int		GELOlayout_component(GELO_OBJECT);
	int		GELOlayout_portal(GELO_OBJECT,GELO_PORT);
	int		GELOinq_layout_heuristics(GELO_OBJECT,GELO_METHOD *,GELO_CONN_METHOD *);

	void		GELOwindow_open(ASH_WINDOW);
	void		GELOwindow_draw(ASH_WINDOW,GELO_OBJECT);
	void		GELOwindow_redraw(ASH_WINDOW);
	void		GELOwindow_set_view(ASH_WINDOW,int,int,int,int);
	void		GELOwindow_inq_real(ASH_WINDOW,int *,int *,int *,int *);
	void		GELOwindow_inq_view(ASH_WINDOW,int *,int *,int *,int *);
	void		GELOwindow_inq_world(ASH_WINDOW,int *,int *,int *,int *);
	void		GELOwindow_select(ASH_WINDOW,GELO_OBJECT,int,int);
	GELO_OBJECT	GELOcorrelate(ASH_WINDOW,int,int);
	void		GELOwindow_resize_object(ASH_WINDOW,GELO_OBJECT);
	void		GELOwindow_free(ASH_WINDOW,GELO_OBJECT);
	void		GELOwindow_free_except(ASH_WINDOW,GELO_OBJECT,GELO_OBJECT);
	void		GELOwindow_replace(ASH_WINDOW,GELO_OBJECT,GELO_OBJECT);
	Boolean 	GELOcompare(GELO_OBJECT,GELO_OBJECT,GELO_OBJECT *,GELO_OBJECT *);

	GELO_CONNECT	GELOnew_connect(GELO_OBJECT,GELO_PORT,GELO_OBJECT,GELO_PORT);
	void		GELOconnect_label(GELO_CONNECT,GELO_ARC_LABEL_LOC,char *);
	void		GELOconnect_arc_style(GELO_CONNECT,int,GELO_ARC_ARROW);
	void		GELOconnect_label_style(GELO_CONNECT,GELO_ARC_LABEL_LOC,GELO_ARC_LABEL_POS,int);
	void		GELOconnect_port_routine(...);
	void		GELOconnect_set_arc_object(GELO_CONNECT,GELO_OBJECT);

	int		GELOrequest_layout_methods(ASH_WINDOW,GELO_METHOD*,
						      GELO_CONN_METHOD*,
						      int *,int *,int *,int *);

	void		GELOtrace(int);
};

#endif





/************************************************************************/
/*									*/
/*	Tracing Definitions						*/
/*									*/
/************************************************************************/


#define GELO_TRACE_OFF	0		/* tracing off			*/
#define GELO_TRACE_ON	0x1		/* trace external entries	*/
#define GELO_TRACE_INT	0x2		/* trace internal entries	*/
#define GELO_TRACE_DBG	0x4		/* trace local routines 	*/
#define GELO_TRACE_SPL	0x8		/* trace local routines 	*/


#endif




/* end of gelo.h */
