/* Carolyn Duby
/*	Copyright 1990 Brown University -- Steven P. Reiss		*/

 * March 10, 1989
 * Stem Package Example Program
 *
 * Purpose:
 *    - to introduce the student to stem
 *    - to provide a supplement to the BWE manual
 *
 *
 * Features Demonstrated
 *    - Pull-down menus
 *    - Menu Buttons
 *    - Scroll Bars   (Maybe)
 *    - Dialog Boxes  (Maybe)
 *
 */

#include <ash.h>    /* definitions for ASH */
#include <stem.h>   /* definitions for STEM */
#include <leaf.h>   /* definitions for LEAF */
#include <math.h>
#include <stdio.h>

#define    TRUE      1
#define    FALSE     0

/* identification for the different window types */

/* ids for windows in LEAF */
typedef enum {
   MENU_WIND = 1,
   DRAW_WIND = 2,
} window_type_t;

#define       LEAF_ID	    1

typedef struct point {
    int     x;
    int     y;
} point;

typedef struct circle {
    point   center;
    int     radius;
} circle;


/* macro to set the center of a given circle to have coordinates */
/* X and Y */
#define     SET_CIRCLE_CENTER(CIRC,X,Y)  CIRC.center.x = X; \
					 CIRC.center.y = Y
#define     SET_CIRCLE_RADIUS(CIRC,RAD) CIRC.radius = RAD
#define     CIRCLE_CENTER_X(CIRC)	 CIRC.center.x
#define     CIRCLE_CENTER_Y(CIRC)	 CIRC.center.y
#define     CIRCLE_RADIUS(CIRC) 	 CIRC.radius

/* sentinel value for identifying a partially declared circle for rubber banding */
#define     UNDEFINED_RAD		 -1
/* RIP track flag for allowing an infinite number of mouse clicks */
#define     INFINITE_CLICKS		 -1
/* this needs to be global for rubber banding routines */





ASH_WINDOW     draw_window;
circle	       rubber_circle;
int	       got_down_trans;


/* Procedure : handle_pulldown_pick
 *
 * This procedure handles a generic pull-down menu pick.
 * It prints out the name of the menu button that is chosen and
 * name of the menu that it was chosen from.  If the user
 * chose Quit, the routine returns TRUE to signal that quit
 * has been chosen.  If another button has been chosen, it
 * returns false that the program keeps on accepting menu picks.
 */


int
handle_pulldown_pick(data,menu_name,button_name,window)
int		     data;	   /* data associated with pick */
char		     *menu_name;   /* name of menu */
char		     *button_name; /* name of button from menu */
ASH_WINDOW	     window;	   /* window that menu is in */
{

    printf("selection %s from menu %s was chosen\n",button_name,
	   menu_name);

    if (strcmp(button_name,"Quit") == 0)
    {
	return(TRUE);	   /* Tell program to quit  */
    }
    else
    {
	return(FALSE);	   /* Tell program not to quit */
    }
}

/* distance
 *
 * This procedure finds the distance between two points
 * by using the distance formula :
 *	  dist = sqrt((x2-x1)^2 + (y2-y1)^2)
 *
 */

int
distance(x1,y1,x2,y2)
int	 x1;	/* x coordinate of first point */
int	 y1;	/* y coordinate of first point */
int	 x2;	/* x coordinate of second point */
int	 y2;	/* y coordinate of second point */
{
    int      delta_x;	 /* difference between the x values */
    int      delta_y;	 /* difference betwen the y values */
    int      dist;	 /* distance between two points */

    delta_x = x2-x1;
    delta_y = y2-y1;
    dist = (int) sqrt((double)(delta_x*delta_x + delta_y*delta_y));
    return(dist);
}


/* rubber_band_circle
 *
 * This procedure is called by RIPtrack automatically whenever
 * a mouse event occurs.  This procedure does the actual rubber banding of a
 * circle on the screen.  If this is not the initial user
 * mouse click then the old circle is drawn over.  The new
 * circle is drawn.
 *
 */

int
rubber_band_circle(mouse_x,mouse_y, num_btns, trans_type, max_clicks, window)
int	       mouse_x;   /* x position of mouse */
int	       mouse_y;   /* y position of mouse */
int	       num_btns;  /* number of buttons pressed on the mouse */
RIP_TRANS      trans_type; /* type of RIP transition */
int	       max_clicks; /* maximum number of mouse clicks */
ASH_WINDOW     window;	   /* window that mouse events occur in */
{

    int        not_done_tracking;     /* boolean indicating to stop tracking or not */
    int        prev_comb;	      /* previous ASH drawing combination routine */
    int        radius;		      /* radius of new circle */


    not_done_tracking = TRUE;
    if (window == draw_window)	 /* ignore events not coming from the draw window */
    {
	/* if the user pressed the mouse down */
	if (trans_type == RIP_TRANS_DOWN)
	{
	   /* get new circle radius */
	   SET_CIRCLE_CENTER(rubber_circle,mouse_x,mouse_y);
	   /* set radius to invalid value to signify undefined radius */
	   SET_CIRCLE_RADIUS(rubber_circle,UNDEFINED_RAD);
	   /* tell RIP not to stop tracking */
	   got_down_trans = TRUE;
	}
	else if ((trans_type == RIP_TRANS_MOVE) && (got_down_trans))
	{
	   if (CIRCLE_RADIUS(rubber_circle) != UNDEFINED_RAD)
	   {
		/* change drawing mode to exclusive or */
		prev_comb = ASHcombination_rule(draw_window,ASH_CR_XOR);
		/* draw over the old circle */
		ASHcircle(draw_window,CIRCLE_CENTER_X(rubber_circle),CIRCLE_CENTER_Y(rubber_circle),
			  CIRCLE_RADIUS(rubber_circle));
		/* reset combination rule to its original state */
		ASHcombination_rule(draw_window,prev_comb);
	    }
	    radius = distance(CIRCLE_CENTER_X(rubber_circle),CIRCLE_CENTER_Y(rubber_circle),mouse_x,mouse_y);
	    SET_CIRCLE_RADIUS(rubber_circle,radius);
	    ASHcircle(draw_window,CIRCLE_CENTER_X(rubber_circle), CIRCLE_CENTER_Y(rubber_circle),
		      CIRCLE_RADIUS(rubber_circle));
       }
       else if ((trans_type == RIP_TRANS_UP) && (got_down_trans))
       {
	  not_done_tracking = FALSE;
       }
    }

    return(not_done_tracking);
}




/* draw_rubber_circle
 *
 * This procedure rubber-bands a circle from user-input using RIP.
 * The user presses down where he/she wants the center and then
 * moves the mouse out to define the radius.
 */

draw_rubber_circle(data,menu_name,button_name,window)
int	  data; 	 /* data associated with pick */
char	  *menu_name;	 /* name of menu */
char	  *button_name;  /* name of button chosen */
ASH_WINDOW  window;	 /* window that menu is in */
{

   got_down_trans = FALSE;
   RIPinput_track(draw_window,"",rubber_band_circle,INFINITE_CLICKS);
}

/* create_pull_down_menus
 *
 * This procedure creates a set of sample pulldown menus by
 * using the STEM package.  First the menus are defined according
 * to STEM.  Next the stem pulldown menu define function is called.
 */

void
create_pull_down_menus(window)
ASH_WINDOW	       window;	 /* window to place menus in */
{
    /* data structure to define pulldown menus */

    static   STEM_PDM_DATA  pdm_def[] = {
    /* define menu one */
    { STEM_PSTATE_MENU, "Selectable Menu", NULL },
	/* define menu choices for "Selectable Menu" */

	/* define an enabled menu choice */
	{ STEM_PSTATE_BTN, "Enabled Btn", handle_pulldown_pick},
	/* define a disabled menu choice (appears as greyed-out) */
	{ STEM_PSTATE_BTN_DISABLE, "Disabled Btn", handle_pulldown_pick},
	/* define a selected menu choice (name has star next to it) */
	{ STEM_PSTATE_BTN_SELECT, "Selected Btn", handle_pulldown_pick},
	/* define the quit button */
	{ STEM_PSTATE_BTN, "Quit", handle_pulldown_pick },
    /* define menu two */
    /* this menu is not able to be selected until STEMpdm_menu_enable is called */
    { STEM_PSTATE_MENU_DISABLE, "Unselectable Menu", NULL },
	{ STEM_PSTATE_BTN, "A button",handle_pulldown_pick },
    { STEM_PSTATE_MENU, "Shapes", NULL },
	{ STEM_PSTATE_BTN, "Circle", draw_rubber_circle },
    /* tell STEM this is the last entry */
    { STEM_PSTATE_END }
    };

    /* define pull down menus described above */
    STEMpdm_define(window,NULL,pdm_def);
}

/* create_windows
 *
 * This procedure lays out the windows for the application
 * with leaf.  First, it calls ASHinit to create the root window,
 * a window which has no parent.  Next it calls the window setup
 * routine for LEAF.  It then calls the redraw routine for LEAF
 * so that the windows appear on the screen.  Lastly it inquires
 * and returns the ASH_WINDOWS making up the screen.
 */

void
create_windows(root_window,menu_window,draw_win)
ASH_WINDOW    *root_window;	/* window with no parents */
ASH_WINDOW    *menu_window;	/* window for pull-down menus */
ASH_WINDOW    *draw_win;       /* window for drawing */
{
    static LEAF_DATA   leaf_def[] =  {
       /* macro to define the root window */
       LEAF_ROOT(NULL),
       /* set up small window at top to hold pull-down menus */
       {
	   MENU_WIND, LEAF_TYPE_PDM,
	   { LEAF_COORD_LX, LEAF_COORD_TEXT, LEAF_COORD_RX,
	     LEAF_COORD_TY },
	   NULL, NULL
       },
       /* set up rest of window to be drawing window */
       {
	   DRAW_WIND, (LEAF_TYPE_WINDOW | LEAF_TYPE_UPPER_LEFT),
	   { LEAF_COORD_LX, LEAF_COORD_BY,
	     LEAF_COORD_RX, LEAF_COORD_NEXT(MENU_WIND) },
	   NULL, NULL
      },
      /* end of the leaf data */
      LEAF_END,
    };

    /* initialize ASH and get the root window */
    /* ASH_MODE_INQUIRE will ask the user to specify size */
    /* by coming up with a shadow window and then the user */
    /* dragging the lower right corner */
    (*root_window) = ASHinit(ASH_MODE_INQUIRE);

    /* tell LEAF to set up the windows according to the */
    /* LEAF data description, leaf_def */
    /* LEAF_ID is a number that is the ASH user-data for the */
    /* window */
    LEAFsetup_window((*root_window),leaf_def,LEAF_ID);

    /* tell LEAF to draw the windows */
    LEAFredraw((*root_window));

    /* ask leaf for the pointer to the menu window */
    (*menu_window) = LEAFinq_window((*root_window),MENU_WIND,0);

    /* ask leaf for the pointer to the drawing window */
    (*draw_win) = LEAFinq_window((*root_window),DRAW_WIND,0);

}



main()
{
    ASH_WINDOW	 root_window;	/* id of the root ASH window */
    ASH_WINDOW	 menu_window;	/* id of window for menus */

    /* create the root and any child windows */
    create_windows(&root_window,&menu_window,&draw_window);

    /* create pull down menus */
    create_pull_down_menus(menu_window);

    printf("draw_window   %u\n",draw_window);

   /* wait for events until Quit is picked */
    while (!RIPuser_pick(NULL))
	    ;
}



