/*	Copyright 1990 Brown University -- Steven P. Reiss		*/

#include "ash.h"
#include "rip.h"
#define NUM_BUTTONS 5

static	int		button_handler();
static	void		draw_buttons();

main(argc,argv)
   int argc;
   char * argv[];
{
   ASH_WINDOW win;

   argc = ASHset_application(argc,argv);
   win = ASHinq_top();
   ASHset_refresh(win,draw_buttons);
   draw_buttons(win);

   for ( ; ; ) {
      RIPuser_pick(0);
    };
};


static void
draw_buttons(win)
   ASH_WINDOW win;
{
   RIP_REGION rgn;
   int lx,by,rx,ty;
   int ht;
   int i;
   char buf[64];

   ASHinq_size(win,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);
   ht = (by-ty)/NUM_BUTTONS;

   for (i = 0; i < NUM_BUTTONS; ++i) {
      sprintf(buf,"Button %d",i);
      ASHcenter_text(win,buf,lx,ty+ht-1,rx,ty);
      ASHbox(win,lx,ty+ht-1,rx,ty);
      rgn = RIPdefine_region(win,lx,ty+ht-1,rx,ty,RIP_NO_CHARS,RIP_BTN_ANY_UP,
				button_handler,ASH_SENSE_FLIP);
      RIPset_data(rgn,i);
      ty += ht;
    };
};


static int
button_handler(x,y,ch,btns,rgn)
   int x,y,ch,btns;
   RIP_REGION rgn;
{
   int b;

   b = RIPinq_data(rgn);
   printf("Button %d hit\n",b);
   if (b == NUM_BUTTONS-1) exit(0);

   return 1;
};
