/*	Copyright 1990 Brown University -- Steven P. Reiss		*/

#include "ash.h"
#include "leaf.h"

#define NULL	0
#define ICON_FONT	"pecan.icons"
#define MOVE_CHAR	"1"
#define SIZE_CHAR	"0"
#define ICON_HEIGHT	16
#define ICON_WIDTH	16

static	int		handle_move_btn();
static	int		handle_size_btn();
static	int		handle_remove_btn();
static	int		handle_push_btn();

#define ROOT_WINDOW	0
#define USER_WINDOW	1
#define UL_REGION	2
#define TITLE_REGION	3
#define UR_REGION	4
#define LL_REGION	5
#define LOWER_REGION_1	6
#define LOWER_REGION_2	7
#define LR_REGION	8

static LEAF_DATA leaf_example[] = {
   LEAF_ROOT(NULL),
   { UL_REGION, LEAF_TYPE_TEXT|LEAF_TYPE_SENSE_FLIP,
	{ LEAF_COORD_LX_LINE, LEAF_COORD_SIZE(ICON_HEIGHT),
	     LEAF_COORD_SIZE(ICON_WIDTH), LEAF_COORD_TY_LINE },
	handle_move_btn, (int) MOVE_CHAR },
   { TITLE_REGION, LEAF_TYPE_TITLE,
	{ LEAF_COORD_NEXT_LINE(UL_REGION), LEAF_COORD_SAME(UL_REGION),
	     LEAF_COORD_RX_LINE, LEAF_COORD_TY_LINE },
	NULL, (int ) "Here is the title" },
   { USER_WINDOW, LEAF_TYPE_WINDOW|LEAF_TYPE_UPPER_LEFT|LEAF_TYPE_INVISIBLE,
	{ LEAF_COORD_LX_LINE, LEAF_COORD_NEXT_LINE(LL_REGION),
	     LEAF_COORD_RX_LINE, LEAF_COORD_NEXT_LINE(UL_REGION) },
	NULL, NULL },
   { LL_REGION, LEAF_TYPE_TEXT|LEAF_TYPE_SENSE_FLIP,
	{ LEAF_COORD_LX_LINE, LEAF_COORD_BY,
	     LEAF_COORD_SIZE(ICON_WIDTH), LEAF_COORD_SIZE(ICON_HEIGHT) },
	handle_size_btn, (int) SIZE_CHAR },
   { LOWER_REGION_1, LEAF_TYPE_TEXT|LEAF_TYPE_SENSE_FLIP,
	{ LEAF_COORD_NEXT_LINE(LL_REGION), LEAF_COORD_BY,
	     LEAF_COORD_TEXT, LEAF_COORD_SAME(LL_REGION) },
	handle_remove_btn, (int) "Remove" },
   { LOWER_REGION_2, LEAF_TYPE_TEXT|LEAF_TYPE_SENSE_FLIP,
	{ LEAF_COORD_TEXT, LEAF_COORD_BY,
	     LEAF_COORD_NEXT_LINE(LR_REGION), LEAF_COORD_SAME(LL_REGION) },
	handle_push_btn, (int) "Push" },
   { LR_REGION, LEAF_TYPE_TEXT|LEAF_TYPE_SENSE_FLIP,
	{ LEAF_COORD_SIZE(ICON_WIDTH), LEAF_COORD_BY,
	     LEAF_COORD_RX_LINE, LEAF_COORD_SAME(LL_REGION) },
	handle_size_btn, (int) SIZE_CHAR },
   LEAF_END
};


main(argc,argv)
   int argc;
   char * argv[];
{
   ASH_WINDOW win;
   ASH_FONT icon_font;

   argc = ASHset_application(argc,argv);
   win = ASHinq_top();
   icon_font = ASHloadfont(ICON_FONT);

   LEAFsetup_window(win,leaf_example,NULL);
   LEAFset_font(icon_font,win,UL_REGION,0);
   LEAFset_font(icon_font,win,LL_REGION,0);
   LEAFset_font(icon_font,win,LR_REGION,0);

   LEAFredraw(win);

   for ( ; ; ) {
      RIPuser_pick(0);
    };
};



static int
handle_move_btn(x,y,ch,btns,rgn)
   int x,y,ch,btns;
   RIP_REGION rgn;
{
   printf("move button hit\n");

   return 1;
};


static int
handle_size_btn(x,y,ch,btns,rgn)
   int x,y,ch,btns;
   RIP_REGION rgn;
{
   printf("size button hit\n");

   return 1;
};


static int
handle_push_btn(x,y,ch,btns,rgn)
   int x,y,ch,btns;
   RIP_REGION rgn;
{
   printf("push button hit\n");

   return 1;
};


static int
handle_remove_btn(x,y,ch,btns,rgn)
   int x,y,ch,btns;
   RIP_REGION rgn;
{
   printf("remove button hit\n");

   exit(0);
};
