/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

#include "/pro/bwe/include/ash.h"
#include "/pro/bwe/include/stem.h"

#define NULL 0
#define TRUE 1
#define FALSE 0

extern	int	exit();
static	int		scroll_handler();
static	int		scroll_val;
static	int		show_dialog();


static STEM_PDM_DATA menu_data[] = {
   { STEM_PSTATE_MENU|STEM_PSTATE_RIPOFF, "menu 1", NULL },
   { STEM_PSTATE_BTN, "button 1", show_dialog },
   { STEM_PSTATE_BTN_DISABLE, "button 2", NULL },
   { STEM_PSTATE_BTN_SELECT, "button 3", NULL },
   { STEM_PSTATE_BTN, "button 4", show_dialog },
   { STEM_PSTATE_BTN, "button 5", show_dialog },
   { STEM_PSTATE_BTN, "button 6", show_dialog },
   { STEM_PSTATE_BTN, "button 7", show_dialog },
   { STEM_PSTATE_MENU|STEM_PSTATE_RIPOFF, "menu 2", NULL },
   { STEM_PSTATE_BTN, "button 8", show_dialog },
   { STEM_PSTATE_BTN, "button 9", show_dialog },
   { STEM_PSTATE_BTN, "button 10", show_dialog },
   { STEM_PSTATE_BTN, "button 11", show_dialog },
   { STEM_PSTATE_BTN, "button 12", show_dialog },
   { STEM_PSTATE_BTN, "button 13", show_dialog },
   { STEM_PSTATE_BTN, "button 14", exit },
   { STEM_PSTATE_END }
};


static	char *	dialog[] = {
   "%CExample Dialog Box\n",
   "%0.0+o Choice 0   %0.1o Choice 1",
   "%0.2o Choice 2   %0.3o Choice 3\n",
   "Text: %1.16t\n",
   "%2o Boolean button\n",
   "%3'Exit'a\n",
   "   %+a%M   %c",
   0
};



main(argc,argv)
   int argc;
   char * argv[];
{
   ASH_WINDOW a,b,c,d,e,f,g,h;
   int i,j;
   int lx,by,rx,ty;
   int x,y;
   int fg;
   STEM_BTN sb;

   argc = ASHset_application(argc,argv);

   if (argc == 2)
      ASHinit(ASH_MODE_DISPLAY);
   else if (argc == 3)
      ASHinit(ASH_MODE_WINDOW);

   a = ASHinq_top();
   ASHinq_size(a,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);

   b = ASHcreate(a,0,36,0,36,rx,0,0,ASH_WINDOW_NOSAVE|ASH_WINDOW_VISIBLE);

   STEMpdm_define(b,b,menu_data);
   STEMpdm_btn_add(b,"menu 1","New button",NULL);
   STEMpdm_btn_remove(b,"menu 1","New button");

   STEMpdm_btn_remove(b,"menu 1","button 7");
   STEMpdm_btn_remove(b,"menu 2","button 9");

   c = ASHcreate(a,lx,by,0,40,rx,0,0,ASH_WINDOW_VISIBLE|ASH_WINDOW_NOSAVE);
   sb = STEMbtn_define(c,0,0,0,0,"Test Button",
			  STEM_BTN_DEFAULT|STEM_BTN_SENSE_FLIP,
			  NULL,NULL);

   fg = 0;

   d = ASHcreate(a,rx-20,by-50,0,0,16,200,1,ASH_WINDOW_NOSAVE);
   STEMscroll(d,scroll_handler,d);
   scroll_val = 25;
   STEMscroll_set(d,0,100,25,50);

   e = ASHcreate(a,lx+20,by-50,0,0,200,20,1,ASH_WINDOW_NOSAVE);
   STEMscroll(e,scroll_handler,e);
   scroll_val = 25;
   STEMscroll_set(e,0,100,25,50);

   for ( ; ; ) {
      RIPuser_pick(0);
      STEMbtn_set(sb,fg);
      fg = !fg;
    };
};




static int
scroll_handler(w,dir,val)
   ASH_WINDOW w;
   int dir,val;
{
   if (dir != 0) val = scroll_val + val*dir;

   if (val < 0) val = 0;
   if (val > 75) val = 75;
   scroll_val = val;

   STEMscroll_set(w,0,100,val,val+25);

   return 1;
};



static int
show_dialog(w,mnm,bnm)
   ASH_WINDOW w;
   char * mnm;
   char * bnm;
{
   int choice,bool,ext;
   char txt[32];

   w = ASHinq_parent(w);

   choice = 0;			/* set initial values		*/
   sprintf(txt,"%s in %s",bnm,mnm);
   bool = 1;
   ext = 0;

   if (!STEMdialog(w,dialog,&choice,txt,&bool,&ext)) {
      printf("Dialog box canceled\n");
      return 0;
    };

   printf("Dialog box accepted:\n");
   printf("   choice = %d\n",choice);
   printf("   text = %s\n",txt);
   printf("   boolean = %d\n",bool);
   printf("   exit = %d\n",ext);

   if (ext) exit(0);

   return 1;
};


