/*	Copyright 1989 Brown University -- Steven P. Reiss		*/

#include <ash.h>
#include <bio.h>
#include <biokeys.h>

#define TRUE 1
#define FALSE 0
#define NULL 0


static	void		refresh_rtn();
static	int		control_rtn();
static	ASH_WINDOW	a,b,c,d,e,f,g,h;




main(argc,argv)
   int argc;
   char **argv;
{
   int i,x,y;
   int xp[10],yp[10];
   ASH_CURSOR ac1,ac2;

   argc = ASHset_application(argc,argv);

   printf("Setup initial windows (click to continue)\n");
   a = ASHinq_top();
   b = ASHcreate(a,100,500,0,0,400,400,1,ASH_WINDOW_VISIBLE);
   d = ASHcreate(a,50,400,0,0,100,100,3,ASH_WINDOW_NOSAVE|ASH_WINDOW_INVISIBLE);

   f = ASHcreate(b,50,50,0,0,200,200,1,ASH_WINDOW_INVISIBLE);
   g = ASHcreate(f,50,50,0,0,100,100,1,ASH_WINDOW_VISIBLE|ASH_WINDOW_NOSAVE);
   e = ASHcreate(d,10,10,0,0,50,50,1,ASH_WINDOW_NOSAVE|ASH_WINDOW_INVISIBLE);

   ASHset_region_refresh(d,refresh_rtn);
   ASHset_region_refresh(g,refresh_rtn);
   ASHset_region_refresh(e,refresh_rtn);

   ac1 = ASHcursor_standard(ASH_CURSOR_SMALL_GLASSES);
   ac2 = ASHcursor_standard(ASH_CURSOR_BULLSEYE);
   ASHwindow_cursor(b,ac1);
   ASHwindow_cursor(d,ac2);

   RIPuser_pick(NULL);

   printf("Drawing primitives in a window (click to continue)\n");

   ASHbatch_mode(TRUE);

   ASHline(b,100,200,300,200);

   xp[0] = 25; yp[0] = 300;
   xp[1] = 75; yp[1] = 300;
   xp[2] = 50; yp[2] = 375;
   xp[3] = xp[0]; yp[3] = yp[0];
   ASHpolyline(b,4,xp,yp);
   for (i = 0; i < 3; ++i) xp[i] += 300;
   ASHpolygon(b,3,xp,yp);

   ASHarc(b,200,325,50,50,3840,3840);
   ASHarc_chord(b,200,275,50,50,3840,3840);
   ASHarc_slice(b,200,225,50,50,3840,3840);

   ASHpush_drawinfo(b,NULL);
   ASHbackground_color(b,ASHlookup_color(b,"wheat"));

   ASHfill(b,ASH_FILL_LIGHT_HALFTONE);
   ASHline_style(b,ASH_STYLE_DASHED);
   ASHcolor(b,ASHlookup_color(b,"violet"));
   ASHrectangle(b,75,25,100,200);
   ASHfill(b,ASH_FILL_SOLID);
   ASHbox(b,25,25,50,200);

   ASHfill(b,ASH_FILL_HALFTONE);
   ASHline_style(b,ASH_STYLE_THICKER);
   ASHcolor(b,ASHlookup_color(b,"cyan"));
   ASHround_rectangle(b,125,50,175,100,20);
   ASHfill(b,ASH_FILL_SOLID);
   ASHround_box(b,125,125,175,175,20);

   ASHfill(b,ASH_FILL_HALFTONE_STIPPLE);
   ASHline_style(b,ASH_STYLE_DOTTED);
   ASHcolor(b,ASHlookup_color(b,"green"));
   ASHfilled_ellipse(b,250,75,50,25);
   ASHfill(b,ASH_FILL_SOLID);
   ASHellipse(b,250,150,50,25);

   ASHtext(b,100,205,"This shows some graphics primitives");

   xp[0] = 350; yp[0] = 25;
   xp[1] = 375; yp[1] = 50;
   xp[2] = 360; yp[2] = 100;
   xp[3] = 375; yp[3] = 150;
   xp[4] = 350; yp[4] = 175;
   xp[5] = 325; yp[5] = 150;
   xp[6] = 340; yp[6] = 100;
   xp[7] = 325; yp[7] = 50;
   ASHline_style(b,ASH_STYLE_THICK);
   ASHfill(b,ASH_FILL_VERY_LIGHT);
   ASHcolor(b,ASHlookup_color(b,"blue"));
   ASHspline_filled(b,8,xp,yp);
   ASHfill(b,ASH_FILL_SOLID);
   ASHspline_closed(b,8,xp,yp);

   ASHpop_drawinfo(b);

   ASHbatch_mode(FALSE);

   RIPuser_pick(NULL);

   printf("Now we do some window manipulations (click to continue)\n");

   ASHbatch_mode(TRUE);

   ASHvisible(d,TRUE);

   ASHvisible(f,TRUE);

   refresh_rtn(f);
   ASHremove(f);

   ASHvisible(e,TRUE);

   for (i = 0; i < 10; ++i) {
      ASHview(d,50+i,400-i,0,0,100,100);
    };
   for (i = 10; i < 20; ++i) {
      ASHview(d,50+i,400-i,0,0,110-i,110-i);
    };
   for (i = 0; i < 10; ++i) {
      ASHresize(d,50,400,0,0,100+10*i,100+10*i);
    };
   ASHpop(b);
   ASHpop(d);
   ASHpush(d);
   ASHrefresh(a);
   ASHremove(d);

   d = ASHcreate(a,50,400,0,0,300,300,1,ASH_WINDOW_NOSAVE|ASH_WINDOW_INVISIBLE);
   ASHset_refresh(d,refresh_rtn);
   ASHvisible(d,TRUE);
   ASHpush(d);

   ASHbatch_mode(FALSE);

   RIPuser_pick(NULL);

   printf("Now we show some interaction mechanisms (type q to quit)\n");

   ASHset_control(a,control_rtn);
   ASHset_control(b,control_rtn);
   ASHset_control(d,control_rtn);

   ASHcenter_text(a,"BUTTON",25,50,125,25);
   ASHsensitive_area(a,25,50,125,25,ASH_SENSE_BOX);

   ASHcenter_text(b,"BUTTON B",25,25,125,50);
   ASHsensitive_area(b,25,25,125,50,ASH_SENSE_FLIP);

   BIOnew_input_window(a);
   BIOset_mask(a,BIO_MASK_DEFAULT|BIO_MASK_UP_FKEY|BIO_MASK_MOVE|BIO_MASK_STILL|
		  BIO_MASK_STILL_DOWN|BIO_MASK_WINDOW_ENTER|BIO_MASK_WINDOW_EXIT,
		  NULL);

   if (argc != 2) {
      for ( ; ; ) {
	 i = BIOnext_wait();
	 printf("Event %d -- %s\n",i,BIO__key_names[i]);
	 if (i == 'q') break;
       };
    };
};




static void
refresh_rtn(w)
   ASH_WINDOW w;
{
   int i;
   int lx,by,rx,ty;
   int dx,dy;

   ASHinq_size(w,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);
   dy = (ty-by)/10;
   dx = (rx-lx)/10;

   for (i = 0; i < 10; ++i) {
      switch (((int) w)%4) {
	 case 0 :
	    ASHline(w,lx,by,rx,by+i*dy);
	    break;
	 case 1 :
	    ASHline(w,lx,ty,rx,ty-i*dy);
	    break;
	 case 2 :
	    ASHline(w,rx,ty,lx,ty-i*dy);
	    break;
	 case 3 :
	    ASHline(w,rx,by,lx,by+i*dy);
	    break;
       };
    };
};




static int
control_rtn(msg,w)
   char * msg;
   ASH_WINDOW w;
{
   char * who;

   if (w == a) who = "top window";
   else if (w == b) who = "draw window";
   else if (w == d) who = "aux window";
   else return ASH_CONTROL_REJECT;

   printf("Message %s for %s\n",msg,who);

   return ASH_CONTROL_REJECT;
};
