/************************************************************************/
/*									*/
/*		ee.c							*/
/*									*/
/*	Main line for a EDT-based editorr			      */
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include <stdio.h>
#include <DATATYPES.h>
#include <edt.h>
#include <wind.h>
#include <ash.h>





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/





/************************************************************************/
/*									*/
/*	Local variables 						*/
/*									*/
/************************************************************************/




/************************************************************************/
/*									*/
/*	main -- main program						*/
/*									*/
/************************************************************************/


main(argc,argv)
   Integer argc;
   String argv[];
{
   String file;
   Boolean ro;
   Integer i;
   EDT_ID ei;
   ASH_WINDOW w;
   Integer lx,by,rx,ty;

   ro = FALSE;
   file = NULL;

   for (i = 1; i < argc; ++i) {
      if (STREQL(argv[i],"-r")) argv[i] = "-readonly";
    };

   argc = ASHset_application(argc,argv);

   for (i = 1; i < argc; ++i) {
      if (argv[i][0] == '-') {
	 switch (argv[i][1]) {
	    case 'r' :
	       ro = TRUE;
	       break;
	    default :
	       fprintf(stderr,"Invalid option <%s>\n",argv[i]);
	       exit(1);
	  };
       }
      else if (file != NULL) {
	 fprintf(stderr,"More than one file specified\n");
	 exit(1);
       }
      else {
	 file = argv[i];
       };
    };

   w = ASHinit(ASH_MODE_INQUIRE);
   ASHinq_size(w,ASH_SIZE_WINDOW,&lx,&by,&rx,&ty);
/* w = ASHcreate(w,lx,by,lx,by,rx,ty,0,ASH_WINDOW_HIT_USE|ASH_WINDOW_NOSAVE);	*/

   STEMdialog_mouse(TRUE);

   w = WINDsetup(w);

   ASHvisible(w,TRUE);

   if (ro) ei = EDTview_file(w,file);
   else ei = EDTedit_file(w,file);

   if (ei != NULL) EDTwait(ei);

   exit(0);
};
