/********************************************************************************/
/*										*/
/*		edthelp.c							*/
/*										*/
/*	HELP command routines for EDT						*/
/*										*/
/********************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "edt_local.h"





/********************************************************************************/
/*										*/
/*	Forward definitions							*/
/*										*/
/********************************************************************************/


static	Boolean 	binding_help();
static	Boolean 	show_bindings();
static	Boolean 	mouse_help();
static	int		compare_names();
static	String		find_binding();





/********************************************************************************/
/*										*/
/*	EDT_help_init -- module initialization					*/
/*										*/
/********************************************************************************/


void
EDT_help_init()
{
};





/************************************************************************/
/*									*/
/*	EDCMDHelp -- get help on a command by name			*/
/*									*/
/************************************************************************/


Boolean
EDCMDHelp(ev,name)
   EDT_VIEW ev;
   String name;
{
   EDT_CMD_ID cmd;
   Integer showfg;
   Character cmdbuf[64],smenu[20480],bndbuf[64];
   String cmds[256];
   STEM_DIALOG_LIST sdl;
   Integer ct;
   String menu[256];
   String s,t;
   Boolean again;

   again = TRUE;

   while (again) {
      again = FALSE;
      if (name != NULL && *name != 0) {
	 cmd = EDT_ctbl_find_command(name);
	 if (cmd == EDT_CMD_UNDEFINED) name = NULL;
       }
      else name = NULL;

      if (name == NULL) {
	 ct = 0;
	 menu[ct++] = "%CHELP on the EDT editor\n";
	 menu[ct++] = "This is a general purpose, extensible text editor\n";
	 menu[ct++] = "For help on a particular command, enter its name below:";
	 menu[ct++] = "   Command: %0.32t\n";
	 menu[ct++] = "For a list of all commands click the box below:";
	 menu[ct++] = "   %1.1o Show commands\n";
	 menu[ct++] = "For help on key bindings click the box below:";
	 menu[ct++] = "   %1.2o Binding help\n";
	 menu[ct++] = "For help on using the mouse click the box below:";
	 menu[ct++] = "   %1.3o Mouse help\n";
	 menu[ct++] = "Click 'Accept' when done\n";
	 menu[ct++] = "%M   %a";
	 menu[ct] = 0;
	 cmdbuf[0] = 0;
	 showfg = FALSE;
	 if (!STEMdialog(ev->edit->window,menu,cmdbuf,&showfg)) return FALSE;
	 if (cmdbuf[0] != 0) showfg = 0;
	 if (showfg == 1) {
	    strcpy(smenu,"%CGet HELP for Command:\n\n");
	    ct = EDT_ctbl_inq_cmds(TRUE,256,cmds);
	    qsort(cmds,ct,sizeof(String),compare_names);
	    cmds[ct] = NULL;
	    sdl.choice = -1;
	    sdl.btns = cmds;
	    strcat(smenu,"  %0.48.32l  \n");
	    strcat(smenu,"\n   %a%M   %c");
	    if (!STEMdialog1(ev->edit->window,smenu,&sdl)) return FALSE;
	    showfg = sdl.choice;
	    if (showfg < 0) return FALSE;
	    cmd = EDT_ctbl_find_command(cmds[showfg]);
	    name = cmds[showfg];
	  }
	 else if (showfg == 2) {
	    again = binding_help(ev);
	    name = NULL;
	    continue;
	  }
	 else if (showfg == 3) {
	    again = mouse_help(ev);
	    name = NULL;
	    continue;
	  }
	 else if (cmdbuf[0] != 0) {
	    cmd = EDT_ctbl_find_command(cmdbuf);
	    name = cmdbuf;
	  }
	 else return TRUE;
       };

      if (cmd < 0) {
	 sprintf(smenu,"%s is not a valid command name",name);
	 EDassoc(VIEW_FILE(ev),ev->editwin);
	 EDfile_display(VIEW_FILE(ev),smenu);
	 EDassoc(VIEW_FILE(ev),ev->edit->window);
	 return FALSE;
       };

      s = EDT_ctbl_inq_help(cmd);
      t = find_binding(ev,cmd,bndbuf);
      if (s == NULL && t == NULL) {
	 sprintf(smenu,"No help available for command %s",name);
	 EDassoc(VIEW_FILE(ev),ev->editwin);
	 EDfile_display(VIEW_FILE(ev),smenu);
	 EDassoc(VIEW_FILE(ev),ev->edit->window);
       }
      else {
	 if (s == NULL) {
	    sprintf(smenu,"Command %s is bound to %s",name,t);
	  }
	 else if (t == NULL) {
	    sprintf(smenu,"%%CHelp for command %s\n\n%s",name,s);
	  }
	 else {
	    sprintf(smenu,"%%CHelp for command %s (%s)\n\n%s",name,t,s);
	  };
	 strcat(smenu,"\n\n   %0o More Help%M   %a");
	 showfg = 0;
	 if (!STEMdialog1(ev->edit->window,smenu,&showfg)) showfg = FALSE;
	 again = showfg;
	 name = NULL;
       };
    };

   return TRUE;
};






/********************************************************************************/
/*										*/
/*	binding_help -- provide help information on key bindings		*/
/*										*/
/********************************************************************************/


static Boolean
binding_help(ev)
   EDT_VIEW ev;
{
   Integer ct;
   String menu[256];
   Integer show,again;
   Boolean fg;

   fg = TRUE;

   while (fg) {
      ct = 0;
      menu[ct++] = "%CHelp on Key Bindings\n";
      menu[ct++] = "The editor binds commands to control keys, function";
      menu[ct++] = "keys, meta-ascii keys and escape sequences.  For";
      menu[ct++] = "information on any of these click the box below:";
      menu[ct++] = "   %0.1o Control key bindings";
      menu[ct++] = "   %0.2o Function key bindings";
      menu[ct++] = "   %0.3o Meta key bindings";
      menu[ct++] = "   %0.4o Escape sequence bindings\n";
      menu[ct++] = "For the binding of a particular command, request help";
      menu[ct++] = "on that command.\n";
      menu[ct++] = "   %1o More Help%M   %a";
      menu[ct] = 0;

      show = 0;
      again = 0;
      if (!STEMdialog(ev->edit->window,menu,&show,&again)) return FALSE;

      switch (show) {
	 case 1 :
	    fg = show_bindings(ev,"Control Key",1,31);
	    break;
	 case 2 :
	    fg = show_bindings(ev,"Function Key",FKEY_FIRST,FKEY_LAST);
	    break;
	 case 3 :
	    fg = show_bindings(ev,"Meta Key",FKEY_META_FIRST,FKEY_META_LAST);
	    break;
	 case 4 :
	    fg = show_bindings(ev,"Escape Sequence",EDT_ESCAPE_FIRST,MAX_EDT_KEYS-1);
	    break;
	 default :
	    fg = FALSE;
	    break;
       };
    };

   return again;
};





/********************************************************************************/
/*										*/
/*	show_bindings -- show a set of bindings 				*/
/*										*/
/********************************************************************************/


static Boolean
show_bindings(ev,what,f,t)
   EDT_VIEW ev;
   String what;
   Integer f,t;
{
   Character smenu[20480];
   Boolean fg;
   Integer i;
   Integer more;

   sprintf(smenu,"%%C%s Bindings\n",what);

   fg = TRUE;
   for (i = f; i < t; ++i) {
      if (ev->edit->keymap.key[i] >= 0) {
	 if (fg) strcat(smenu,"\n");
	 else strcat(smenu,"  %M");
	 fg = !fg;
	 if (i >= EDT_ESCAPE_FIRST) {
	    strcat(smenu,"Escape-");
	    strcat(smenu,BIO__key_names[i-EDT_ESCAPE_FIRST]);
	  }
	 else strcat(smenu,BIO__key_names[i]);
	 strcat(smenu," : ");
	 strcat(smenu,EDT_ctbl_inq_name(ev->edit->keymap.key[i]));
       };
    };

   strcat(smenu,"\n\n   %0o More Bindings%M   %a");

   more = 0;
   if (!STEMdialog1(ev->edit->window,smenu,&more)) return FALSE;

   return more;
};





/********************************************************************************/
/*										*/
/*	mouse_help -- help for mouse						*/
/*										*/
/********************************************************************************/


static Boolean
mouse_help(ev)
   EDT_VIEW ev;
{
   Integer ct;
   String menu[64];
   Integer more;

   ct = 0;
   menu[ct++] = "%CHelp on Using the Mouse\n";
   menu[ct++] = "The mouse is used for positioning and for selecting.  There";
   menu[ct++] = "are two ways of using the mouse, tapping and dragging.  A tap";
   menu[ct++] = "is a quick up-down of a mouse button at a single location. A";
   menu[ct++] = "drag is anything else";
   menu[ct++] = "\nThe normal mouse actions are:";
   menu[ct++] = "   Tap(Left)    -- move to selected character";
   menu[ct++] = "   Tap(Middle)  -- move to start/end of selected word";
   menu[ct++] = "   Tap(Right)   -- move to start/end of selected line";
   menu[ct++] = "   Drag(Left)   -- Select characters";
   menu[ct++] = "   Drag(Middle) -- Select words";
   menu[ct++] = "   Drag(Right)  -- Select lines";
   menu[ct++] = "\nIf there is a current selection, then the Right button extends it.";
   menu[ct++] = "If the Right button drags to extend, then the selection is made";
   menu[ct++] = "into a replace selection which will be deleted.";
   menu[ct++] = "\nWhile dragging, the selection unit can be changed by pressing";
   menu[ct++] = "the other two mouse buttons.  The leftmost one will select a smaller";
   menu[ct++] = "selection unit and the rightmost one a larger unit.  The selection";
   menu[ct++] = "units are:";
   menu[ct++] = "   Character -- Word -- Line -- Paragraph -- File";
   menu[ct++] = "\n   %0o More Help%M   %a";
   menu[ct] = 0;

   more = 0;
   if (!STEMdialog(ev->edit->window,menu,&more)) return FALSE;

   return more;
};





/********************************************************************************/
/*										*/
/*	compare_names -- qsort string compare function				*/
/*										*/
/********************************************************************************/


static int
compare_names(n1,n2)
   String * n1;
   String * n2;
{
   return strcmp(*n1,*n2);
};






/********************************************************************************/
/*										*/
/*	find_binding -- find binding to given command				*/
/*										*/
/********************************************************************************/


static String
find_binding(ev,cmd,buf)
   EDT_VIEW ev;
   EDT_CMD_ID cmd;
   Character buf[];
{
   Integer i;

   for (i = 0; i < MAX_EDT_KEYS; ++i) {
      if (ev->edit->keymap.key[i] == cmd) break;
    };

   if (i >= MAX_EDT_KEYS) return NULL;

   if (i >= EDT_ESCAPE_FIRST) {
      sprintf(buf,"Escape-%s",BIO__key_names[i-EDT_ESCAPE_FIRST]);
    }
   else {
      strcpy(buf,BIO__key_names[i]);
    };

   return buf;
};






/* end of edthelp.c */
