/************************************************************************/
/*									*/
/*		edtcc.c 						*/
/*									*/
/*	C-language specific routines for EDT editor			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "edt_local.h"





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define FCTSRCHSTR "^[A-Za-z_][A-Za-z0-9_]*[ ]*("

#define INDENT_A_DEFAULT 3
#define INDENT_B_DEFAULT 3
#define INDENT_C_DEFAULT 1
#define INDENT_D_DEFAULT 2

#define BLOCK_START	"/************************************************************************/\n"
#define BLOCK_MID	"/*                                                                      */\n"
#define BLOCK_END	"/************************************************************************/\n"
#define BLOCK_SIZE	5






/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


static	Integer 	indent_A = INDENT_A_DEFAULT;
static	Integer 	indent_B = INDENT_B_DEFAULT;
static	Integer 	indent_C = INDENT_C_DEFAULT;
static	Integer 	indent_D = INDENT_D_DEFAULT;





/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/


static	void		get_line();





/************************************************************************/
/*									*/
/*	EDTCC_init -- module initialization				*/
/*									*/
/************************************************************************/


void
EDTCC_init()
{
   FILE_BUF fbf;
   Character buf[10240];
   Integer i;

   fbf = FILEinq_buffer("C_BLOCK_CMMT");
   if (FILEbuffer_size(fbf) == 0) {
      strcpy(buf,BLOCK_START);
      for (i = 0; i < BLOCK_SIZE-2; ++i) strcat(buf,BLOCK_MID);
      strcat(buf,BLOCK_END);
      FILEbuffer_define(fbf,buf);
    };
};





/************************************************************************/
/*									*/
/*	EDTCCindent -- compute CC indentation				*/
/*									*/
/************************************************************************/


Integer
EDTCCindent(fid)
   FILE_ID fid;
{
   Integer y;
   Integer x,lastsig,nestlevel;
   Integer ch;
   Integer strflg,cmmtfg,eosfirst,nestfg;
   Integer fctfg,casefg,i,lblfg,rbrfg,cmafg,lbrfg;
   Integer lastsemi;
   Character line_buffer[1024];

   y = FILEinq_currline(fid);
   lastsig = -1;
   nestlevel = 0;
   strflg = 0;
   cmmtfg = FALSE;
   eosfirst = FALSE;
   nestfg = -1;
   fctfg = FALSE;
   casefg = FALSE;
   lblfg = FALSE;
   rbrfg = FALSE;
   cmafg = -1;
   lbrfg = FALSE;
   lastsemi = -1;

   get_line(fid,y,line_buffer);
   for (x = 0; line_buffer[x] == ' '; ++x);

   /* Check for initial sequences */

   if (line_buffer[x] == '#') return(0);
   else if (line_buffer[x] == '}') {
      nestlevel = 1;
      eosfirst = TRUE;
      rbrfg = TRUE;
    }
   else if (line_buffer[x] == '{') lbrfg = TRUE;
   else if (strncmp(&line_buffer[x],"case",4) == 0) casefg = 1;
   else if (strncmp(&line_buffer[x],"default",4) == 0) casefg = 1;
   else if (isalnum(line_buffer[x])) {
      while (isalnum(line_buffer[x])) ++x;
      while (line_buffer[x] == ' ') ++x;
      if (line_buffer[x] == ':') lblfg = TRUE;
    };

   x = 0;

   for ( ; ; ) {
      while (x <= 0) {
	 --y;
	 fctfg = FALSE;
	 if (y <= 0) goto found;
	 get_line(fid,y,line_buffer);
	 if (line_buffer[0] == '#') x = 0;
	    else x = strlen(line_buffer);
       };
      ch = line_buffer[--x];

      if (cmmtfg) {
	 if (ch == '/' && line_buffer[x+1] == '*') cmmtfg = FALSE;
	 continue;
       };
      if (strflg != 0) {
	 if (ch == strflg && (x == 0 || line_buffer[x-1] != '\\')) {
	    strflg = 0;
	    ch = 'X';
	  }
	 else continue;
       };

      if (ch == '/' && x > 0 && line_buffer[x-1] == '*') {
	 cmmtfg = TRUE;
	 --x;
	 continue;
       };

      switch(ch)
       { case ' '       :
		break;

	 case '"'       :
	 case '\''      :
		strflg = ch;
		break;

	 case '('       :
		if (lastsemi != y && line_buffer[x+1] != ')') fctfg = TRUE;

	 case '{'       :
		if (lastsig < 0) casefg = 0;
		if (nestlevel > 0) {
		   --nestlevel;
		   if (nestlevel == 0) lastsig = x;
		 }
		else if (lastsig < 0 && x > 0) nestfg = x;
		else if (x == 0 && lastsig < 0) { nestfg = 0; goto found; }
		else goto found;
		cmafg = -1;
		break;

	 case '}'       :
		if (nestlevel == 0) {
		   if (x == 0) { lastsig = -1; nestfg = -1; goto found; };
		   if (lastsig >= 0) goto found;
		      else eosfirst = TRUE;
		 };
		++nestlevel;
		break;

	 case ')'       :
		++nestlevel;
		break;

	 case ':'       :
		if (nestlevel > 0) break;
		i = 0;
		while (line_buffer[i] == ' ') ++i;
		if (strncmp(&line_buffer[i],"case",4) != 0 &&
		       strncmp(&line_buffer[i],"default",7) != 0) {
		   while (isalnum(line_buffer[i])) ++i;
		   while (line_buffer[i] == ' ') ++i;
		   if (i == x) x = 0;
		 }
		else {
		   lastsig = i;
		   nestfg = 1;
		   goto found;
		 };
		break;

	 case ';'       :
		lastsemi = y;
		if (nestlevel > 0) break;
		if (lastsig >= 0) goto found;
		eosfirst = TRUE;
		break;

	 case ',' :
		if (nestlevel == 0) cmafg = y;
		break;

	 default	 :
		if (nestlevel > 0) break;
		lastsig = x;
		if (x == 0) {
		   if (fctfg && indent_D != 0) nestfg = 0;
		   lastsig = -1;
		   goto found;
		 };
		break;
       };
    };

found:
   if (lastsig < 0 && nestfg < 0) x = 0;
    else if (lastsig < 0) x = indent_B;
    else if (nestfg >= 0) x = lastsig+indent_B;
    else if (!eosfirst && (cmafg < 0 || cmafg == y)) x = lastsig+indent_A;
    else x = lastsig;

   if (lbrfg && x == indent_B) x = 0;
   if (rbrfg && x != 0) x += indent_C;
   else if (casefg) x -= indent_B;
   else if (lblfg) x -= 2*indent_B;
   if (x < 0) x = 0;

   return x;
};





/************************************************************************/
/*									*/
/*	get_line -- get given line					*/
/*									*/
/************************************************************************/


static void
get_line(fid,l,buf)
   FILE_ID fid;
   Integer l;
   String buf;
{
   FILE_POS p1,p2;
   String s;
   Integer cl;

   cl = FILEinq_currline(fid);

   FILEinq_position(fid,FILE_MOVE_REL|FILE_MOVE_LINE|FILE_MOVE_LINE_START,
		       l-cl,&p1);
   FILEinq_position(fid,FILE_MOVE_REL|FILE_MOVE_LINE|FILE_MOVE_LINE_END,
		       l-cl,&p2);

   s = FILEcopy_text(fid,&p1,&p2);

   if (s != NULL) {
      strcpy(buf,s);
      free(s);
    }
   else buf[0] = 0;
};





/* end of edtcc.c */



