/************************************************************************/
/*									*/
/*		edt_local.h						*/
/*									*/
/*	Local definitions for editor interface package			*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/



#define  PROT_NAME	EDT__sema

#include <bwethread.h>
#include <DATATYPES.h>
#include <ctype.h>
#include <sequence.h>
#include <ash.h>
#include <editor.h>
#include <rip.h>
#include <bio.h>
#include <biokeys.h>
#include <bpiokeys.h>
#include <leaf.h>
#include <stem.h>
#include <help.h>
#include <cmpx.h>

#include <dl.h>

#include <edt.h>

#define LPROTECT(ei)	ASHlock((ei)->window)
#define LUNPROTECT(ei)	ASHunlock((ei)->lockwin)




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define VIEW_CURSOR	ASH_CURSOR_SMALL_XHAIRS

#define MAX_ARGS		16

#define DEFAULT_BUFFER_NAME	"BUFFER"
#define SELECT_BUFFER_NAME	"SELECTION"
#define X_BUFFER_NAME		"X_BUFFER"
#define DEFAULT_HISTORY 	32

#define SECURE_COUNTER		10

#define VERSION 		1
#define SUBVERSION		1

#define EDT_BASIS_FILE		"%s/lib/bwe/edt.ctbl.%s"
#define EDT_BASIS_FILE0 	"%s/bwe/lib/edt.ctbl.%s"
#define EDT_BASIS_CMD_FILE	"%s/.edt.cmds"
#define EDT_ABBREV_FILE 	"%s/lib/bwe/edt.abbrev"
#define EDT_ABBREV_FILE0	"%s/bwe/lib/edt.abbrev"
#define EDT_LOCAL_ABBREV	"%s/.edtabbrev"

#define EDT_CONTROL_FILE	".edt.control"
#define EDT_CONTROL_TEXT	"%s %d %d\n"    /* file line column     */




/************************************************************************/
/*									*/
/*	Command and Key definitions					*/
/*									*/
/************************************************************************/


#define MAX_EDT_CMDS	512

#define EDT_ESCAPE_FIRST 512
#define MAX_EDT_KEYS	(512+128)


typedef Short			EDT_CMD_ID;
#define EDT_CMD_IGNORE		(-1)
#define EDT_CMD_UNDEFINED	(-2)
#define EDT_CMD_HOOK(id)	(-100-id)
#define EDT_CMD_IS_HOOK(cmd)	((cmd) <= -100)
#define EDT_CMD_HOOK_ID(cmd)	(-(cmd)-100)


#define EDT_CMD_FLAG_GROUP_NUM	0x0f
#define EDT_CMD_FLAG_GROUP_TYPE 0x11
#define EDT_CMD_FLAG_GROUP_MOVE 0x12
#define EDT_CMD_FLAG_GROUP_3	0x14
#define EDT_CMD_FLAG_GROUP_4	0x18

#define EDT_CMD_FLAG_NO_COMMAND 0x20
#define EDT_CMD_FLAG_SHOW_ARGS	0x80
#define EDT_CMD_FLAG_SAME	0x100
#define EDT_CMD_FLAG_CONFIRM	0x200
#define EDT_CMD_FLAG_CLOSE	0x400
#define EDT_CMD_FLAG_MACRO_ABORT 0x800
#define EDT_CMD_FLAG_NO_PSET	0x1000


typedef struct _EDT_VAR *	EDT_VAR;
typedef struct _EDT_CMD *	EDT_CMD;
typedef struct _EDT_BIND *	EDT_BIND;
typedef struct _EDT_BUF *	EDT_BUF;
typedef struct _EDT_POS *	EDT_POS;
typedef struct _EDT_ENUM_TYPE * EDT_ENUM_TYPE;


typedef struct _EDT_KEYMAP {
   EDT_CMD_ID	key[MAX_EDT_KEYS];
} EDT_KEYMAP;



typedef Integer EDT_VAR_TYPE;

#define EDT_VAR_TYPE_UNDEF	(0)
#define EDT_VAR_TYPE_BOOL	(-1)
#define EDT_VAR_TYPE_STRING	(-2)
#define EDT_VAR_TYPE_INT	(-3)
#define EDT_VAR_TYPE_UDF	(-4)
#define EDT_VAR_TYPE_ENUM	(-5)
#define EDT_VAR_TYPE_BUFFER	(-6)
#define EDT_VAR_TYPE_POSITION	(-7)


typedef struct _EDT_ENUM_TYPE {
   Character name[32];
   Character text[256];
} EDT_ENUM_TYPE_INFO;





typedef struct _EDT_VAR {
   Character name[32];
   Character description[32];
   EDT_VAR_TYPE type;
   Universal dflt;
   Short index;
   Short loc;
   Boolean global;
   Boolean temp;
} EDT_VAR_INFO;



typedef struct _EDT_CMD {
   Character name[32];
   Character rtn_name[32];
   Integer   vars[MAX_ARGS];
   Integer flags;
   Integer nvars;
   Function_Ptr rtn;
   String help;
} EDT_CMD_INFO;



typedef struct _EDT_BIND {
   Character keys[48];
   EDT_CMD_ID cmd;
   Character when[16];
} EDT_BIND_INFO;



typedef struct _EDT_BUF {
   Character name[32];
   FILE_BUF buffer;
} EDT_BUF_INFO;



typedef struct _EDT_POS {
   Integer flags;
} EDT_POS_INFO;

#define EDT_POS_FLAG_CURRENT	  0x2
#define EDT_POS_FLAG_START_FILE   0x4
#define EDT_POS_FLAG_END_FILE	  0x8
#define EDT_POS_FLAG_LINE_START   0x40
#define EDT_POS_FLAG_LINE_END	  0x80
#define EDT_POS_FLAG_SELECT_START 0x100
#define EDT_POS_FLAG_SELECT_END   0x200
#define EDT_POS_FLAG_VIEW_TOP	  0x400
#define EDT_POS_FLAG_VIEW_BOTTOM  0x800
#define EDT_POS_FLAG_VIEW_MIDDLE  0x1000
#define EDT_POS_FLAG_NEXT_LINE	  0x2000
#define EDT_POS_FLAG_PREV_LINE	  0x4000
#define EDT_POS_FLAG_COND_START   0x8000

#define EDT_POS_FLAG_PREVIOUS	  0x10000
#define EDT_POS_FLAG_END	  0x20000
#define EDT_POS_FLAG_WORD	  0x40000
#define EDT_POS_FLAG_PARA	  0x80000
#define EDT_POS_FLAG_LINE	  0x100000
#define EDT_POS_FLAG_SEP	  0x200000
#define EDT_POS_FLAG_CURROK	  0x400000
#define EDT_POS_FLAG_TAB	  0x800000
#define EDT_POS_FLAG_SENTENCE	  0x1000000

#define EDT_POS_FLAG_MOVEMENT	  (EDT_POS_FLAG_WORD| \
					EDT_POS_FLAG_PARA| \
					EDT_POS_FLAG_LINE| \
					EDT_POS_FLAG_SENTENCE)




typedef Integer EDT_HOOK_TYPE;
#define EDT_HOOK_INDENT 	0
#define EDT_HOOK_WORD_BOUNDS	1
#define EDT_HOOK_SENT_BOUNDS	2
#define EDT_HOOK_PARA_BOUNDS	3
#define EDT_HOOK_MODE_SELECT	4
#define EDT_HOOK_END_OF_LINE	5

#define EDT_NUM_HOOKS		6





/************************************************************************/
/*									*/
/*	Local Type Definitions						*/
/*									*/
/************************************************************************/



typedef struct _EDT_SELECT	*EDT_SELECT;
typedef struct _EDT_MACRO	*EDT_MACRO;
typedef struct _EDT_MACRO_BLK	*EDT_MACRO_BLK;
typedef struct _EDT_VINFO	*EDT_VINFO;
typedef struct _EDT_VIEW	*EDT_VIEW;
typedef struct _EDT_CODE	*EDT_CODE;



typedef struct _EDT_SELECT {
   EDT_VIEW	view;
   EDT_SELECT_TYPE unit;
   FILE_POS	begin;
   FILE_POS	end;
   Boolean	valid;
   Boolean	replace;
   Short	anchor;
} EDT_SELECT_INFO;

#define EDT_ANCHOR_NONE 	0
#define EDT_ANCHOR_START	1
#define EDT_ANCHOR_END		2
#define EDT_ANCHOR_SET		3




typedef struct _EDT_MACRO {
   EDT_VIEW	view;
   EDT_MACRO_BLK first;
   EDT_MACRO_BLK last;
} EDT_MACRO_INFO;



typedef struct _EDT_MACRO_BLK {
   EDT_MACRO_BLK next;
   EDT_CMD_ID cmd;
   Integer key;
   Universal  vals[MAX_ARGS];
} EDT_MACRO_BLK_INFO;




typedef struct _EDT_ID {
   String	filename;
   ASH_WINDOW	window;
   ASH_WINDOW	menuwin;
   ASH_WINDOW	stswin;
   ASH_WINDOW	lockwin;
   ASH_FONT	font;
   EDT_VINFO	views;
   FILE_ID	edit_file;
   Boolean	shell;
   Boolean	wait;
   Boolean	in_command;
   Integer	shell_pos;
   Integer	ingroup;
   EDT_DATA	data;
   Universal	udata;
   EDT_MARK	all_marks;
   Integer	line_size;
   String	mode;
   Universal	temp;
   EDT_KEYMAP	keymap;
   Integer	varct;
   Universal *	vars;
   Integer	gvarct;
   Universal *	gvars;
   Function_Ptr hooks[EDT_NUM_HOOKS];
   Sequence	menus;
   EDT_SELECT_INFO select;
   EDT_MACRO	macro;
   Integer	histct;
   Integer	histfirst;
   Integer *	history;
   Byte 	escape;
   FILE_MARK	marks;
   Integer	cmdct;
   Integer	status;
   Integer	status_line;
   Integer	status_eof;
   Boolean	force_bounds;
   Boolean	force_save;
   Boolean	no_close;
   Function_Ptr input_filter;
   Function_Ptr output_filter;
} EDT_ID_INFO;




typedef int	EDT_VIEW_TYPE;
#define EDT_VIEW_TYPE_SHELL	0x1




typedef struct _EDT_VINFO {
   EDT_VIEW	view;
   Integer	fraction;
   EDT_VIEW_TYPE type;
   ASH_WINDOW	window;
   EDT_VINFO	next;
   Integer	ty;
   Integer	by;
} EDT_VINFO_INFO;




typedef struct _EDT_VIEW {
   EDT_ID	edit;
   ASH_WINDOW	window;
   ASH_WINDOW	editwin;
   ASH_WINDOW	scrollwin;
   TEXT_ID	edit_text;
   EDT_VIEW_TYPE type;
   RIP_REGION	region;
   Integer	first_line;
   Integer	top_line;
   Integer	bottom_line;
   Integer	last_line;
} EDT_VIEW_INFO;




typedef struct _EDT_MARK {
   EDT_MARK	next;
   Integer	file_pos;
   Boolean	valid;
} EDT_MARK_INFO;




typedef enum {
   CODE_INT,
   CODE_FLOAT,
   CODE_STRING,
   CODE_LIST,
   CODE_CALL,
   CODE_NAME,
} EDT_CODE_TYPE;





#define EDT_STATUS_OPEN 	0x1
#define EDT_STATUS_INSERT	0x2
#define EDT_STATUS_INDENT	0x4
#define EDT_STATUS_HOLD 	0x8
#define EDT_STATUS_ARGS 	0x10
#define EDT_STATUS_MACRO	0x20
#define EDT_STATUS_ENABLE	0x40





/************************************************************************/
/*									*/
/*	Access macros							*/
/*									*/
/************************************************************************/


#define VIEW_FILE(ev)		((ev)->edit->edit_file)
#define VIEW_TEXT(ev)		((ev)->edit_text)
#define VIEW_SELECT_START(ev)	((ev)->edit->select.begin)
#define VIEW_SELECT_END(ev)	((ev)->edit->select.end)
#define VIEW_SELECT_VALID(ev)	((ev)->edit->select.valid)





/************************************************************************/
/*									*/
/*	System Variables						*/
/*									*/
/************************************************************************/


#define last_key_struck_INDEX		1
#define last_key_struck 	gvars[last_key_struck_INDEX]
#define get_args_INDEX			2
#define get_args		gvars[get_args_INDEX]
#define insert_mode_INDEX		3
#define insert_mode		gvars[insert_mode_INDEX]
#define auto_indent_INDEX		4
#define auto_indent		gvars[auto_indent_INDEX]
#define raw_mode_INDEX			5
#define raw_mode		gvars[raw_mode_INDEX]
#define hold_mode_INDEX 		6
#define hold_mode		gvars[hold_mode_INDEX]
#define open_mode_INDEX 		7
#define open_mode		gvars[open_mode_INDEX]
#define abbrev_mode_INDEX		8
#define abbrev_mode		gvars[abbrev_mode_INDEX]
#define extend_mode_INDEX		9
#define extend_mode		gvars[extend_mode_INDEX]
#define usesel_mode_INDEX		10
#define usesel_mode		gvars[usesel_mode_INDEX]
#define backeol_mode_INDEX		11
#define backeol_mode		gvars[backeol_mode_INDEX]
#define previous_file_INDEX		12
#define previous_file		gvars[previous_file_INDEX]
#define always_replace_INDEX		13
#define always_replace		gvars[always_replace_INDEX]
#define previous_cmd_INDEX		14
#define previous_cmd		gvars[previous_cmd_INDEX]
#define auto_linefeed_INDEX		15
#define auto_linefeed		gvars[auto_linefeed_INDEX]
#define previous_line_INDEX		16
#define previous_line		gvars[previous_line_INDEX]
#define cur_indent_INDEX		17
#define cur_indent		gvars[cur_indent_INDEX]
#define auto_select_all_INDEX		18
#define auto_select_all 	gvars[auto_select_all_INDEX]
#define scan_args_INDEX 		19
#define scan_args		gvars[scan_args_INDEX]
#define readonly_mode_INDEX		20
#define readonly_mode		gvars[readonly_mode_INDEX]







/************************************************************************/
/*									*/
/*	Local Entries							*/
/*									*/
/************************************************************************/


					/* edtmain.c			*/
extern	void		EDT_init();
extern	void		EDT_error();


					/* edtwin.c			*/
extern	void		EDT_win_init();
extern	EDT_ID		EDT_info_by_window();
extern	EDT_ID		EDT_info_by_menu();
extern	EDT_ID		EDT_info_by_editor();
extern	Integer 	EDT_open_file();
extern	Boolean 	EDT_close_file();
extern	EDT_VIEW	EDT_inq_current_view();
extern	void		EDT_rebind();
extern	void		EDT_set_values();
extern	void		EDT_split_view();
extern	void		EDT_remove_view();
extern	void		EDT_size_view();
extern	void		EDT_confirm();


					/* edtview.c			*/
extern	void		EDT_view_init();
extern	EDT_VIEW	EDT_view_create();
extern	Boolean 	EDT_view_line_pos();
extern	Integer 	EDT_view_correlate_line();
extern	Integer 	EDT_view_inq_bounds();
extern	Boolean 	EDT_view_bounds();


					/* edtinput.c			*/
extern	void		EDT_input_init();
extern	Integer 	EDT_button_handler();
extern	Boolean 	EDT_clear_selection();
extern	EDT_SELECT_TYPE EDT_inq_selection_unit();
extern	void		EDT_set_selection_unit();
extern	void		EDT_start_selection();
extern	Boolean 	EDT_extend_selection();
extern	void		EDT_finish_selection();
extern	void		EDT_replace_selection();


					/* edteval.c			*/
extern	void		EDT_eval_init();
extern	Boolean 	EDT_eval_cmd();
extern	Boolean 	EDT_eval_menu_btn();
extern	void		EDT_save_command();
extern	Boolean 	EDT_undo();
extern	Boolean 	EDT_redo();
extern	Boolean 	EDT_scroll_to();
extern	void		EDT_file_position();
extern	Integer 	EDT_word_bounds();
extern	Integer 	EDT_para_bounds();
extern	Integer 	EDT_line_bounds();
extern	void		EDT_last_char();
extern	void		EDT_next_char();
extern	void		EDT_macro_begin();
extern	void		EDT_macro_add();
extern	void		EDT_macro_end();
extern	Boolean 	EDT_macro_do();
extern	void		EDT_synch_view();
extern	void		EDT_synch_position();
extern	void		EDT_auto_extend();


					/* edtctbl.c			*/
extern	void		EDT_ctbl_init();
extern	void		EDT_ctbl_startup();
extern	Boolean 	EDT_ctbl_show_args();
extern	Boolean 	EDT_ctbl_ignore_cmd();
extern	Integer 	EDT_ctbl_cmd_group();
extern	Function_Ptr	EDT_ctbl_routine();
extern	String		EDT_ctbl_cmd_name();
extern	Boolean 	EDT_ctbl_cmd_close();
extern	Boolean 	EDT_ctbl_macro_abort();
extern	Boolean 	EDT_ctbl_no_prev_set();
extern	String		EDT_ctbl_confirm();
extern	EDT_CMD_ID	EDT_ctbl_map_key();
extern	String		EDT_ctbl_mode_select();
extern	Integer 	EDT_ctbl_indent();
extern	Integer 	EDT_ctbl_word_bounds();
extern	Integer 	EDT_ctbl_sent_bounds();
extern	Integer 	EDT_ctbl_para_bounds();
extern	void		EDT_ctbl_end_of_line();
extern	EDT_CMD_ID	EDT_ctbl_find_command();
extern	Integer 	EDT_ctbl_arg_list();
extern	void		EDT_ctbl_setup();
extern	void		EDT_ctbl_define();
extern	void		EDT_ctbl_subcommand();
extern	EDT_VAR 	EDT_ctbl_new_var();
extern	EDT_VAR 	EDT_ctbl_make_global();
extern	EDT_VAR 	EDT_ctbl_find_global();
extern	EDT_VAR_TYPE	EDT_ctbl_new_enum();
extern	EDT_VAR_TYPE	EDT_ctbl_find_type();
extern	String		EDT_ctbl_inq_enums();
extern	void		EDT_ctbl_new_bind();
extern	void		EDT_ctbl_rebind();
extern	void		EDT_ctbl_help();
extern	String		EDT_ctbl_inq_help();
extern	String		EDT_ctbl_inq_name();
extern	Integer 	EDT_ctbl_inq_cmds();
extern	void		EDT_ctbl_load_file();
extern	Boolean 	EDT_ctbl_check_mode();




					/* edtvars.c			*/
extern	void		EDT_vars_init();
extern	void		EDT_var_reset();
extern	void		EDT_var_setup();
extern	Universal	EDT_var_get_value();
extern	void		EDT_var_set_value();
extern	void		EDT_var_set_default();
extern	Integer 	EDT_value_enum();
extern	EDT_BUF 	EDT_value_buffer();
extern	EDT_POS 	EDT_value_position();
extern	Universal	EDT_value_copy();
extern	Boolean 	EDT_vars_request();



					/* edtprim.c			*/
extern	void		EDT_prim_init();
extern	Boolean 	EDCMDNoop();
extern	Boolean 	EDCMDEnter();
extern	Boolean 	EDCMDInsertMode();
extern	Boolean 	EDCMDIndentMode();
extern	Boolean 	EDCMDOpenMode();
extern	Boolean 	EDCMDReadOnly();
extern	Boolean 	EDCMDGenericMove();
extern	Boolean 	EDCMDTabN();
extern	Boolean 	EDCMDGenericSearch();
extern	Boolean 	EDCMDReplaceString();
extern	Boolean 	EDCMDGenericPosition();
extern	Boolean 	EDCMDScroll();
extern	Boolean 	EDCMDKeepPosition();
extern	Boolean 	EDCMDInsertCharacter();
extern	Boolean 	EDCMDSelfInsert();
extern	Boolean 	EDCMDNewLine();
extern	Boolean 	EDCMDGenericMap();
extern	Boolean 	EDCMDGenericDelete();
extern	Boolean 	EDCMDGenericPick();
extern	Boolean 	EDCMDPatternDelete();
extern	Boolean 	EDCMDGenericInsert();
extern	Boolean 	EDCMDInsertString();
extern	Boolean 	EDCMDSavePosition();
extern	Boolean 	EDCMDGotoPosition();
extern	Boolean 	EDCMDCommand();
extern	Boolean 	EDCMDUndo();
extern	Boolean 	EDCMDRedo();
extern	Boolean 	EDCMDCloseFile();
extern	Boolean 	EDCMDOpenFile();
extern	Boolean 	EDCMDSaveFile();
extern	Boolean 	EDCMDAlterAccess();
extern	Boolean 	EDCMDSplitView();
extern	Boolean 	EDCMDRemoveView();
extern	Boolean 	EDCMDSizeView();
extern	Boolean 	EDCMDLoadCommands();
extern	Boolean 	EDCMDSaveCommandTable();
extern	Boolean 	EDCMDLoadCommandTable();
extern	Boolean 	EDCMDSelectBegin();
extern	Boolean 	EDCMDSelectExtend();
extern	Boolean 	EDCMDSelectReplace();
extern	Boolean 	EDCMDSelectAbort();
extern	Boolean 	EDCMDCopyFromFile();
extern	Boolean 	EDCMDWriteToFile();
extern	Boolean 	EDCMDUnixCommand();
extern	Boolean 	EDCMDPrint();
extern	Boolean 	EDCMDIndent();
extern	Boolean 	EDCMDJoin();
extern	Boolean 	EDCMDMacroCompile();
extern	Boolean 	EDCMDMacroDo();
extern	Boolean 	EDCMDBindKeys();
extern	Boolean 	EDCMDTranspose();
extern	Boolean 	EDCMDUserCall();
extern	void		EDHOOKword_wrap();
extern	void		EDT_indent_on_line();



					/* edtsyn.y/edtlex.l		*/
extern	void		EDT_syn_init();



					/* edtexec.c			*/
extern	void		EDT_exec_init();



					/* edtcc.c			*/
extern	void		EDTCC_init();
extern	Integer 	EDTCCindent();


					/* edtpascal.c			*/
extern	void		EDTPAS_init();
extern	Integer 	EDTPASindent();


					/* edthelp.c			*/
extern	void		EDT_help_init();
extern	Boolean 	EDCMDHelp();


					/* edtabbrev.c			*/
extern	void		EDT_abbrev_init();
extern	Boolean 	EDCMDAbbrevDefine();
extern	Boolean 	EDCMDAbbrevExpand();
extern	Boolean 	EDCMDAbbrevLoad();
extern	Boolean 	EDCMDAbbrevStore();
extern	Boolean 	EDCMDAbbrevClear();
extern	Boolean 	EDCMDAbbrevComplete();
extern	void		EDT_abbrev_setup();
extern	void		EDT_abbrev_define();
extern	void		EDT_abbrev_clear();
extern	Boolean 	EDT_abbrev_save();
extern	Boolean 	EDT_abbrev_load();
extern	String		EDT_abbrev_find();





/* end of edt_local.h */
