/************************************************************************/
/*									*/
/*		edt.h							*/
/*									*/
/*	Global definitions for editor interface package 		*/
/*									*/
/************************************************************************/
/*	Copyright 1988 Brown University -- Steven P. Reiss		*/


#include "ash.h"




/************************************************************************/
/*									*/
/*	Type Definitions						*/
/*									*/
/************************************************************************/


typedef struct _EDT_DATA {
   Boolean readonly;			/* files should be readonly	*/
   Boolean create;			/* files can be created 	*/
   Boolean temporary;			/* file name is advisory only	*/
   Boolean scroll;			/* window is scrollable 	*/
   Boolean raw; 			/* raw mode input for shell	*/
   Boolean echo;			/* echo mode input for shell	*/
   Boolean savectl;			/* load/save control info	*/
   Boolean disable;			/* file editing disabled	*/
   String mode; 			/* major mode for editor	*/
   Function_Ptr bounds_rtn;		/* bounds notification		*/
   Function_Ptr input_rtn;		/* input for shell mode 	*/
   Function_Ptr mouse_rtn;		/* extra mouse btn routine	*/
   Function_Ptr file_rtn;		/* call back for open/close	*/
   Function_Ptr input_filter;		/* input filter routine 	*/
   Function_Ptr output_filter;		/* output filter routine	*/
   Integer __spare[4];			/* for later use		*/
} EDT_DATA_INFO;



typedef struct _EDT_DATA *	EDT_DATA;
typedef struct _EDT_ID *	EDT_ID;
typedef struct _EDT_MARK *	EDT_MARK;
typedef struct _EDT_EXEC *	EDT_EXEC;


typedef enum {
   EDT_SELECT_VOID,
   EDT_SELECT_CHAR,
   EDT_SELECT_WORD,
   EDT_SELECT_LINE,
   EDT_SELECT_PARA,
   EDT_SELECT_FILE
} EDT_SELECT_TYPE;



typedef enum {
   EDT_FILE_OPEN,
   EDT_FILE_ABORT,
   EDT_FILE_SAVE,
   EDT_FILE_INQ_ABORT,
   EDT_FILE_INQ_SAVE,
   EDT_FILE_REMOVE,
   EDT_FILE_SECURE,
   EDT_FILE_PREOPEN,
} EDT_FILE_TYPE;





/************************************************************************/
/*									*/
/*	Entry Points							*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	void		EDTstartup();
extern	EDT_ID		EDTedit_file();
extern	EDT_ID		EDTview_file();
extern	EDT_ID		EDTedit_string();
extern	EDT_ID		EDTedit_interactive();
extern	EDT_EXEC	EDTedit_shell();
extern	EDT_EXEC	EDTedit_pty();
extern	EDT_ID		EDTedit_output();
extern	void		EDTwait();

extern	EDT_ID		EDTdefine_editor();
extern	void		EDTrelease();
extern	String		EDTinq_line_text();
extern	String		EDTinq_contents();
extern	Integer 	EDTcur_line();
extern	Integer 	EDTcur_char();
extern	Integer 	EDTlast_line();
extern	Integer 	EDTinq_line_pos();
extern	Integer 	EDTcorrelate_line();
extern	Integer 	EDTinq_bounds();
extern	EDT_MARK	EDTmarker();
extern	Integer 	EDTmark_line();
extern	Integer 	EDTmark_char();
extern	Boolean 	EDTset_file();
extern	Boolean 	EDTclose();
extern	Boolean 	EDTclose_save();
extern	Boolean 	EDTclose_abort();
extern	Boolean 	EDTsecure();
extern	void		EDTforce_save();
extern	void		EDTprohibit_close();
extern	void		EDTsynch();
extern	Boolean 	EDTinq_modified();
extern	void		EDTshell_output();
extern	void		EDTshell_done_prompt();
extern	void		EDTgoto();
extern	void		EDTgoto_alt();
extern	void		EDTgoto_top();
extern	void		EDTenable();
extern	void		EDTinsert_line();
extern	void		EDTdelete_line();
extern	void		EDTreplace_line();
extern	void		EDTtruncate_at();
extern	void		EDTkeep_position();
extern	void		EDThilite_line();
extern	void		EDTjoin_views();
extern	void		EDTtypein();
extern	void		EDTset_user_data();
extern	void		EDTset_mouse_rtn();
extern	void		EDTauto_select_all();
extern	String		EDTinq_selection();

extern	Boolean 	EDTctbl_save();
extern	Boolean 	EDTctbl_load();

extern	Boolean 	EDTload_description();

extern	EDT_EXEC	EDTexec();
extern	EDT_EXEC	EDTptty();
extern	void		EDTexec_stop();
extern	void		EDTexec_kill();
extern	void		EDTexec_input();
extern	void		EDTexec_wait();
extern	int		EDTexec_inq_status();
extern	void		EDTexec_prohibit_close();

#else

extern "C" {
	void		EDTstartup();
	EDT_ID		EDTedit_file(ASH_WINDOW,char *);
	EDT_ID		EDTview_file(ASH_WINDOW,char *);
	EDT_ID		EDTedit_string(ASH_WINDOW,char *);
	EDT_ID		EDTedit_interactive(ASH_WINDOW,char * ...);
	EDT_EXEC	EDTedit_shell(ASH_WINDOW);
	EDT_EXEC	EDTedit_pty(ASH_WINDOW,char *);
	EDT_ID		EDTedit_output(ASH_WINDOW ...);
	void		EDTwait(EDT_ID);

	EDT_ID		EDTdefine_editor(ASH_WINDOW,char *,EDT_DATA ...);
	void		EDTrelease(EDT_ID);
	String		EDTinq_line_text(EDT_ID,int,char *);
	String		EDTinq_contents(EDT_ID);
	Integer 	EDTcur_line(EDT_ID);
	Integer 	EDTcur_char(EDT_ID);
	Integer 	EDTlast_line(EDT_ID);
	Integer 	EDTinq_line_pos(EDT_ID,int,int *,int *,int);
	Integer 	EDTcorrelate_line(EDT_ID,int);
	Integer 	EDTinq_bounds(EDT_ID,int *,int *,int *,int);
	EDT_MARK	EDTmarker(EDT_ID,int,int);
	Integer 	EDTmark_line(EDT_ID,EDT_MARK);
	Integer 	EDTmark_char(EDT_ID,EDT_MARK);
	Boolean 	EDTset_file(EDT_ID,char *);
	Boolean 	EDTclose(EDT_ID);
	Boolean 	EDTclose_save(EDT_ID);
	Boolean 	EDTclose_abort(EDT_ID);
	Boolean 	EDTsecure(EDT_ID,char *);
	void		EDTforce_save(EDT_ID);
	void		EDTprohibit_close(EDT_ID);
	void		EDTsynch(EDT_ID);
	Boolean 	EDTinq_modified(EDT_ID);
	void		EDTshell_output(EDT_ID,char *);
	void		EDTshell_done_prompt(EDT_ID);
	void		EDTgoto(EDT_ID,int);
	void		EDTgoto_alt(EDT_ID,int);
	void		EDTgoto_top(EDT_ID,int);
	void		EDTenable(EDT_ID,int);
	void		EDTinsert_line(EDT_ID,int,char *);
	void		EDTdelete_line(EDT_ID,int);
	void		EDTreplace_line(EDT_ID,int,char *);
	void		EDTtruncate_at(EDT_ID,int);
	void		EDTkeep_position(EDT_ID,int);
	void		EDThilite_line(EDT_ID,int);
	void		EDTjoin_views(EDT_ID);
	void		EDTtypein(EDT_ID,int);
	void		EDTset_user_data(EDT_ID ...);
	void		EDTset_mouse_rtn(EDT_ID ...);
	void		EDTauto_select_all(EDT_ID,int);
	String		EDTinq_selection(EDT_ID);

	Boolean 	EDTctbl_save(EDT_ID,char *);
	Boolean 	EDTctbl_load(char *);

	Boolean 	EDTload_description(char *);

	EDT_EXEC	EDTexec(ASH_WINDOW,ASH_WINDOW,ASH_WINDOW,char * ...);
	EDT_EXEC	EDTptty(ASH_WINDOW,ASH_WINDOW,ASH_WINDOW,char *);
	void		EDTexec_stop(EDT_EXEC);
	void		EDTexec_kill(EDT_EXEC,int);
	void		EDTexec_input(EDT_EXEC,char *);
	void		EDTexec_wait(EDT_EXEC);
	int		EDTexec_inq_status(EDT_EXEC);
	void		EDTexec_prohibit_close(EDT_EXEC);
};

#endif





/* end of edt.h */
