/************************************************************************/
/*									*/
/*		fileoutput.c						*/
/*									*/
/*	Routines to return text from editor				*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "editor_local.h"





/************************************************************************/
/*									*/
/*	Forward definitions						*/
/*									*/
/************************************************************************/



/******************************************************************/
/*								  */
/*    FILEinq_text - place all the text between 'from' and 'to'   */
/*	  in the given buffer, up to the given length.		  */
/*								  */
/******************************************************************/


void
FILEinq_text(fid,from,to,buffer)
   FILE_ID fid;
   FILE_POS *from;
   FILE_POS *to;
   FILE_BUF buffer;
{
   register FILE_INDEX start,end;
   register Integer i;
   register String text;

   FILE_INIT;

   FILE_position(fid,from);	/* verify file positions */
   FILE_position(fid,to);

   FILE_position_real(fid,from);
   FILE_position_real(fid,to);

   start = from->index;
   end = to->index;
   if (start == end) return;
   if (start < end) {
      PROTECT;
      text = (String) malloc(end - start + 1);
      for( i = 0; start != end; i++,start++) {
	 *(text + i) = charAt(fid,start);
       }
      *(text + i) = '\0';
      FILEbuffer_define(buffer,text);
      free(text);
      UNPROTECT;
    }
   else EDabort("Bad arguments to FILEinq_text");
}





/******************************************************************/
/*								  */
/*    FILEget_text - pass all the text in the designated region   */
/*	  to the function 'fct' one character at a time.          */
/*								  */
/******************************************************************/


void
FILEget_text(fid,from,to,fct)
   FILE_ID fid;
   FILE_POS *from;
   FILE_POS *to;
   Integer (*fct) ();
{
   register FILE_INDEX start,end;

   FILE_INIT;

   FILE_position(fid,from);	 /* verify file positions */
   FILE_position(fid,to);

   start = from->index;
   end = to->index;
   if (start < end) {
      for( ; start != end; start++) (*fct) (charAt(fid,start));
    }
   else EDabort("Bad argument to get_text");
}





/******************************************************************/
/*								  */
/*    FILEcopy_text - return all the text in a designated region  */
/*	  to the caller as a string.				  */
/*								  */
/******************************************************************/


char *
FILEcopy_text(fid,from,to)
   FILE_ID   fid;
   FILE_POS *from;
   FILE_POS *to;
{
   register FILE_INDEX start,end;
   register Integer i;
   String text;

   FILE_INIT;

   FILE_position(fid,from);	/* verify file positions */
   FILE_position(fid,to);

   start = from->index;
   end = to->index;
   if (start <= end) {
      PROTECT;
      text = (String) malloc(end - start + 1);
      for( i = 0; start != end; i++,start++) {
	 *(text + i) = charAt(fid,start);
       }
      *(text + i) = '\0';
      UNPROTECT;
      return(text);
    }
   else EDabort("Bad argument to FILEcopy_text");

   /*NOTREACHED*/
}





/******************************************************************/
/*								  */
/*    FILEget_char - return the character at given (line,char)	  */
/*	  position in the file.  If there is no char at that	  */
/*	  position, it returns '\0'.                              */
/*								  */
/******************************************************************/


int
FILEget_char(fid,line,ch)
   FILE_ID fid;
   Integer line;
   Integer ch;
{
   FILE_POS fp;

   FILE_INIT;

   FILEnew_position(fid,line,ch,&fp);

   if (fp.virt) return( '\0' );
   else return( charAt(fid,fp.index) );
}





/******************************************************************/
/*								  */
/*    FILEregister_message - associates the given function to	  */
/*	  the given file (via a list). These functions will	  */
/*	  be called to inform of changes.			  */
/*								  */
/******************************************************************/


void
FILEregister_message(fid,fct)
   FILE_ID fid;
   Function_Ptr  fct;
{
   REG_MSG regmsgp;
   REG_MSG last;

   FILE_INIT;

   PROTECT;

   last = NULL;
   regmsgp = fid->filedata->regmsg;
   while ((regmsgp != NULL) && (regmsgp->fct != fct)) {
      last = regmsgp;
      regmsgp = regmsgp->nxtregmsg;
    }

   if (regmsgp == NULL) { /* not already in list */
      regmsgp = PALLOC(REG_MSG_INFO);
      regmsgp->fct = fct;
      regmsgp->nxtregmsg = NULL;
      if (last == NULL) /* empty list */
	 fid->filedata->regmsg = regmsgp;
      else
	 last->nxtregmsg = regmsgp;
    }

   regmsgp->limitset = FALSE;

   UNPROTECT;
}





/******************************************************************/
/*								  */
/*    FILEnotify_limits - define a region of interest for	  */
/*	  notification messages (like reg_mesg).		  */
/*								  */
/******************************************************************/


void
FILEnotify_limits(fid,fct,from,to)
   FILE_ID   fid;
   Function_Ptr    fct;
   FILE_POS *from;
   FILE_POS *to;
{
   REG_MSG regmsgp;
   REG_MSG last;
   FILE_INDEX start,end;

   FILE_INIT;

   FILE_position(fid,from);
   FILE_position(fid,to);

   start = from->index;
   end = to->index;
   if (start < end) {
      PROTECT;
      last = NULL;
      regmsgp = fid->filedata->regmsg;
      while ((regmsgp != NULL) && (regmsgp->fct != fct)) {
	 last = regmsgp;
	 regmsgp = regmsgp->nxtregmsg;
       }
      if (regmsgp == NULL) { /* not already in list */
	 regmsgp = PALLOC(REG_MSG_INFO);
	 regmsgp->fct = fct;
	 regmsgp->nxtregmsg = NULL;
	 if (last == NULL) /* empty list */
	    fid->filedata->regmsg = regmsgp;
	 else
	    last->nxtregmsg = regmsgp;
       }
      regmsgp->limitset = TRUE;
      CopyPos(fid,from,&regmsgp->from);
      CopyPos(fid,to,&regmsgp->to);
      UNPROTECT;
    }
   else EDabort("Bad argument to notify_limits");
}





/* end of fileoutput.c */
