/******************************************************************/
/*								  */
/*		editorio.c					  */
/*								  */
/*	I/O to user routines for the editor			  */
/*								  */
/******************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "editor_local.h"




/******************************************************************/
/*								  */
/*	Local storage						  */
/*								  */
/******************************************************************/


typedef struct _ED_IO_INFO *	ED_IO_INFO;

typedef struct _ED_IO_INFO {
   ASH_WINDOW window;
   FILE_ID fid;
   ED_IO_INFO next;
} ED_IO_INFO_B;

static	ED_IO_INFO	first_info = NULL;





/************************************************************************/
/*									*/
/*	Forward Definitions						*/
/*									*/
/************************************************************************/


static	ASH_WINDOW	find_err_window();





/******************************************************************/
/*								  */
/*	ED_init -- initialize this module			  */
/*								  */
/******************************************************************/


void
ED_init()
{
   first_info = NULL;
};





/******************************************************************/
/*								  */
/*    EDabort - abort the editor cleanly. A 'big' error has       */
/*	 occurred.						  */
/*								  */
/******************************************************************/


void
EDabort(s1)
  String s1;
{
   printf("EDITOR: %s\n",s1);

   EDfile_display(NULL,s1);

   abort();
}




/******************************************************************/
/*								  */
/*	EDassoc -- associate window with file id		  */
/*								  */
/******************************************************************/


void
EDassoc(f,w)
   FILE_ID f;
   ASH_WINDOW w;
{
   register ED_IO_INFO ei,eil;

   if (w == NULL) {
      eil = NULL;
      for (ei = first_info; ei != NULL; ei = ei->next) {
	 if (ei->fid == f) break;
	 eil = ei;
       };
      if (ei != NULL) {
	 if (eil == NULL) first_info = ei->next;
	 else eil->next = ei->next;
	 free(ei);
       };
    }
   else {
      for (ei = first_info; ei != NULL; ei = ei->next) {
	 if (ei->fid == f) break;
       };
      if (ei == NULL) {
	 ei = (ED_IO_INFO) calloc(1,sizeof(ED_IO_INFO_B));
	 ei->fid = f;
	 ei->next = first_info;
	 ei->window = NULL;
	 first_info = ei;
       };
      ei->window = w;
    };
};





/******************************************************************/
/*								  */
/*	EDfile_display -- display for a given file		  */
/*								  */
/******************************************************************/


void
EDfile_display(fid,s)
   FILE_ID fid;
   String s;
{
   Character buf[256];
   ASH_WINDOW w;

   if (s == NULL) return;

   if (fid != NULL && fid->filedata != NULL && fid->filedata->ignerror)
      return;

   if (fid != NULL && fid->filedata != NULL) fid->filedata->ignerror = TRUE;

   w = find_err_window(fid);

   sprintf(buf,"%%B8%%P8\n%%C%s\n\n%%M   %%a",s);
   STEMdialog1(w,buf);
};





/******************************************************************/
/*								  */
/*	EDfile_boolean -- return boolean information for user	  */
/*								  */
/******************************************************************/


char *
EDfile_boolean(f,p)
   FILE_ID f;
   String p;
{
   register Integer fg;
   register String r;
   Character buf[256];
   ASH_WINDOW w;

   w = find_err_window(f);

   sprintf(buf,"%%B8%%P8\n%%C%s\n\n   %%a%%M   %%c",p);
   fg = STEMdialog1(w,buf);
   r = (fg ? "yes" : "no");

   return r;
};




/************************************************************************/
/*									*/
/*	find_err_window -- find window for error message		*/
/*									*/
/************************************************************************/


static ASH_WINDOW
find_err_window(fid)
   FILE_ID fid;
{
   register ED_IO_INFO ei;
   ASH_WINDOW w;

   for (ei = first_info; ei != NULL; ei = ei->next) {
      if (ei->fid == fid) break;
    };

   if (ei != NULL) w = ei->window;
   else if (first_info == NULL) w = ASHinq_top();
   else w = first_info->window;

   return w;
};





/* end of editorio.c */
