/****************************************************************************/
/*									    */
/*		editor.h						    */
/*									    */
/*	External definitions for using the editor			    */
/*									    */
/****************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "ash.h"




/************************************************************************/
/*									*/
/*	Data type definitions						*/
/*									*/
/************************************************************************/


typedef struct _FILE_POS_NODE	FILE_POS;

typedef struct _FILE_HEADER *	FILE_ID;

typedef struct _FILE_BUF *	FILE_BUF;

typedef struct _FILE_MARK_NODE * FILE_MARK;

typedef struct _TEXT_DISPLAY *	TEXT_ID;





typedef enum {			  /* messages sent out by file module	    */
     FILE_MSG_TYPEIN,
     FILE_MSG_DELETE,
     FILE_MSG_INSERT,
     FILE_MSG_CLOSE,
     FILE_MSG_CHANGED,
     FILE_MSG_COMMAND
} FILE_MSG;



#ifndef EDITOR_LOCAL

struct _FILE_POS_NODE { 	   /* dummy file position for outside use    */
   int	dummy[10];
};

#endif


typedef enum _TEXT_FLAG {
  TEXT_FLAG_TOP_LEFT,
  TEXT_FLAG_NEAR_TOP,
  TEXT_FLAG_NEAR_BOTTOM,
  TEXT_FLAG_NEAR_MIDDLE,
  TEXT_FLAG_DELTA_LINES,
  TEXT_FLAG_DELTA_CHARS
} TEXT_FLAG;



typedef enum _TEXT_CURSOR {
  TEXT_CURSOR_CHAR,
  TEXT_CURSOR_UNDERLINE,
  TEXT_CURSOR_SAME,
  TEXT_CURSOR_CARET,
  TEXT_CURSOR_FORCE,
} TEXT_CURSOR;




/********************************************************************/
/*								    */
/*		  constants and parameters			    */
/*								    */
/********************************************************************/

#define UPDATE	    FALSE
#define NOUPDATE    TRUE

#define FILE_ID_NONE	    NULL

#define FILE_MARK_NEW	    NULL

#define  FILE_OPEN_READONLY	 0x1  /* file open flag params	    */
#define  FILE_OPEN_TEMPORARY	 0x2
#define  FILE_OPEN_CREATE	 0x4
#define  FILE_OPEN_NEW		 0x8
#define  FILE_OPEN_EXCLUSIVE	 0x10
#define  FILE_OPEN_LOCK 	 0x20
#define  FILE_OPEN_HOLD 	 0x40

#define  FILE_MOVE_ABS		 0x1  /* relative file move params  */
#define  FILE_MOVE_REL		 0x2
#define  FILE_MOVE_START	 0x4
#define  FILE_MOVE_END		 0x8
#define  FILE_MOVE_CHAR 	 0x10
#define  FILE_MOVE_LINE 	 0x20
#define  FILE_MOVE_LINE_START	 0x40
#define  FILE_MOVE_LINE_END	 0x80
#define  FILE_MOVE_COND_START	 0x100

#define  FILE_SEARCH_FORWARD	 0x1  /* search style parameters    */
#define  FILE_SEARCH_BACKWARD	 0x2
#define  FILE_SEARCH_WRAP	 0x4
#define  FILE_SEARCH_RE 	 0x8
#define  FILE_SEARCH_NOCASE	 0x10
#define  FILE_SEARCH_START	 0x20
#define  FILE_SEARCH_END	 0x40
#define  FILE_SEARCH_CURROK	 0x80

typedef  int			FILE_FILTER_WHEN;
#define  FILE_FILTER_INPUT	 0x1
#define  FILE_FILTER_OUTPUT	 0x2





/************************************************************************/
/*									*/
/*	External storage						*/
/*									*/
/************************************************************************/


extern FILE_POS  *FILE_POS_START;     /* predefined FILE_POS ptrs.  */
extern FILE_POS  *FILE_POS_END;
extern FILE_POS  *FILE_POS_NONE;







/********************************************************************/
/*								    */
/*	    entries to file module				    */
/*								    */
/********************************************************************/


#ifndef __cplusplus

extern	FILE_ID 	FILEopen();		 /* filefiles.c    */
extern	char *		FILEinq_filename();
extern	void		FILEfilter();
extern	void		FILErelease();
extern	int		FILEmodified();
extern	int		FILEclose();
extern	int		FILEsave_as();
extern	void		FILEclose_allfiles();
extern	void		FILEset_backups();
extern	int		FILEalter_access();
extern	void		FILEsecure();


extern	void		FILEmove();		/* filelocation.c */
extern	void		FILEset_position();
extern	void		FILEinq_position();
extern	void		FILEnew_position();
extern	int		FILEinq_line();
extern	int		FILEinq_char();
extern	int		FILEinq_currline();
extern	int		FILEinq_currchar();
extern	int		FILEinq_autoindent();
extern	int		FILEinq_linespaces();
extern	int		FILEpos_compare();
extern	void		FILEpos_copy();


extern	void		FILEinsert();		/* fileedit.c	  */
extern	void		FILEdelete();
extern	void		FILEpick();
extern	void		FILEtypein();
extern	void		FILEedit_limits();


extern	char *		FILEinq_buffer_name();	/* filebuffers.c  */
extern	FILE_BUF	FILEinq_buffer();
extern	int		FILEbuffer_size();
extern	int		FILEbuffer_define();
extern	int		FILEbuffer_append();
extern	char *		FILEbuffer_contents();
extern	void		FILEbuffer_load();
extern	void		FILEbuffer_store();
extern	void		FILEbuffer_window();


extern	void		FILEinq_text(); 	/* fileoutput.c 	*/
extern	void		FILEget_text();
extern	char *		FILEcopy_text();
extern	int		FILEget_char();
extern	void		FILEregister_message();
extern	void		FILEnotify_limits();


extern	FILE_MARK	FILEset_mark(); 	/* filemarks.c		*/
extern	void		FILEunset_mark();
extern	void		FILEinq_mark();
extern	int		FILEsave_pos();
extern	void		FILEdelete_pos();
extern	void		FILEinq_savepos();


extern	int		FILEend_command();	/* filehistory.c	*/
extern	int		FILEundo_command();
extern	int		FILEredo_command();
extern	void		FILEfree_history();


extern	void		FILEsearch();		/* filesearch.c 	*/
extern	int		FILEsearch_position();
extern	void		FILEsearch_word();

#else

extern "C" {
	FILE_ID 	FILEopen(char *,int);
	char *		FILEinq_filename(FILE_ID);
	void		FILEfilter(FILE_ID,int ...);
	void		FILErelease(FILE_ID);
	int		FILEmodified(FILE_ID);
	int		FILEclose(FILE_ID,int);
	int		FILEsave_as(FILE_ID,char *);
	void		FILEclose_allfiles();
	void		FILEset_backups(FILE_ID,int);
	int		FILEalter_access(FILE_ID);
	void		FILEsecure(FILE_ID);

	void		FILEmove(FILE_ID,int ...);
	void		FILEset_position(FILE_ID,int,int,FILE_POS *);
	void		FILEinq_position(FILE_ID,int ...);
	void		FILEnew_position(FILE_ID,int,int,FILE_POS *);
	int		FILEinq_line(FILE_ID,FILE_POS *);
	int		FILEinq_char(FILE_ID,FILE_POS *);
	int		FILEinq_currline(FILE_ID);
	int		FILEinq_currchar(FILE_ID);
	int		FILEinq_autoindent(FILE_ID);
	int		FILEinq_linespaces(FILE_ID);
	int		FILEpos_compare(FILE_ID,FILE_POS *,FILE_POS *);
	void		FILEpos_copy(FILE_ID,FILE_POS *,FILE_POS *);

	void		FILEinsert(FILE_ID,FILE_BUF,int);
	void		FILEdelete(FILE_ID,FILE_BUF,int ...);
	void		FILEpick(FILE_ID,FILE_BUF,int ...);
	void		FILEtypein(FILE_ID,int,int);
	void		FILEedit_limits(FILE_ID,FILE_POS *,FILE_POS *);

	char *		FILEinq_buffer_name(FILE_BUF);
	FILE_BUF	FILEinq_buffer(char *);
	int		FILEbuffer_size(FILE_BUF);
	int		FILEbuffer_define(FILE_BUF,char *);
	int		FILEbuffer_append(FILE_BUF,char *);
	char *		FILEbuffer_contents(FILE_BUF);
	void		FILEbuffer_load(char *);
	void		FILEbuffer_store(char *);
	void		FILEbuffer_window(FILE_BUF,ASH_WINDOW);

	void		FILEinq_text(FILE_ID,FILE_POS *,FILE_POS *,FILE_BUF);
	void		FILEget_text(FILE_ID,FILE_POS *,FILE_POS * ...);
	char *		FILEcopy_text(FILE_ID,FILE_POS *,FILE_POS *);
	int		FILEget_char(FILE_ID,int,int);
	void		FILEregister_message(FILE_ID ...);
	void		FILEnotify_limits(FILE_ID ...);

	FILE_MARK	FILEset_mark(FILE_ID,FILE_MARK);
	void		FILEunset_mark(FILE_ID,FILE_MARK);
	void		FILEinq_mark(FILE_ID,FILE_MARK,FILE_POS *);
	int		FILEsave_pos(FILE_ID);
	void		FILEdelete_pos(FILE_ID,int);
	void		FILEinq_savepos(FILE_ID,int,FILE_POS *);

	int		FILEend_command(FILE_ID,int);
	int		FILEundo_command(FILE_ID,int);
	int		FILEredo_command(FILE_ID);
	void		FILEfree_history(int);

	void		FILEsearch(FILE_ID,char *,int,FILE_POS *);
	int		FILEsearch_position(FILE_ID,char *,int,FILE_POS *,FILE_POS *);
	void		FILEsearch_word(FILE_ID,int,FILE_POS *);
};

#endif




/********************************************************************/
/*								    */
/*	    entries to text module				    */
/*								    */
/********************************************************************/


#ifndef __cplusplus

extern	TEXT_ID 	TEXTopen();
extern	void		TEXTposition();
extern	void		TEXTinq_top();
extern	int		TEXTinq_topline();
extern	int		TEXTinq_leftchar();
extern	void		TEXTinq_bottom();
extern	int		TEXTinq_bottomline();
extern	int		TEXTinq_rightchar();
extern	void		TEXTcorrelate();
extern	void		TEXTmark_begin();
extern	void		TEXTinq_mark_begin();
extern	void		TEXTmark_until();
extern	void		TEXTmark_from();
extern	void		TEXTmark_end();
extern	void		TEXTmark2_begin();
extern	void		TEXTmark2_until();
extern	void		TEXTmark2_from();
extern	void		TEXTmark2_end();
extern	void		TEXTcursor_enable();
extern	void		TEXTcursor();
extern	void		TEXTclose();
extern	void		TEXTinq_screensize();
extern	void		TEXTresize();
extern	void		TEXTset_shell_mode();

#else

extern "C" {
	TEXT_ID 	TEXTopen(FILE_ID,ASH_WINDOW);
	void		TEXTposition(TEXT_ID,TEXT_FLAG ...);
	void		TEXTinq_top(TEXT_ID,FILE_POS *);
	int		TEXTinq_topline(TEXT_ID);
	int		TEXTinq_leftchar(TEXT_ID);
	void		TEXTinq_bottom(TEXT_ID,FILE_POS *);
	int		TEXTinq_bottomline(TEXT_ID);
	int		TEXTinq_rightchar(TEXT_ID);
	void		TEXTcorrelate(TEXT_ID,int,int,FILE_POS *);
	void		TEXTmark_begin(TEXT_ID,FILE_POS *);
	void		TEXTinq_mark_begin(TEXT_ID,FILE_POS *);
	void		TEXTmark_until(TEXT_ID,FILE_POS *);
	void		TEXTmark_end(TEXT_ID);
	void		TEXTmark2_begin(TEXT_ID,FILE_POS *);
	void		TEXTmark2_until(TEXT_ID,FILE_POS *);
	void		TEXTmark2_end(TEXT_ID);
	void		TEXTcursor_enable(TEXT_ID,int);
	void		TEXTcursor(TEXT_ID,TEXT_CURSOR,FILE_POS *);
	void		TEXTclose(TEXT_ID);
	void		TEXTinq_screensize(TEXT_ID,int *,int *);
	void		TEXTresize(TEXT_ID);
	void		TEXTset_shell_mode(TEXT_ID);
};

#endif





/***********************************************************************/
/*								       */
/*	 entries to ed_io.c					       */
/*								       */
/***********************************************************************/


#ifndef __cplusplus

extern	void		EDabort();
extern	void		EDassoc();
extern	void		EDfile_display();
extern	char *		EDfile_boolean();

#else

extern "C" {
	void		EDabort(char *);
	void		EDassoc(FILE_ID,ASH_WINDOW);
	void		EDfile_display(FILE_ID,char *);
	char *		EDfile_boolean(FILE_ID,char *);
};

#endif





/* end of editor.h */
