/************************************************************************/
/*									*/
/*		cmpx_local.h						*/
/*									*/
/*	Local definitions for the communications multiplexor		*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/



#define PROT_NAME	CMPX__sema
#include <bwethread.h>

#include <DATATYPES.h>
#include <cmpx.h>
#include <signal.h>




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define CMPX_TICK_TIME		2000




/************************************************************************/
/*									*/
/*	Data types							*/
/*									*/
/************************************************************************/


typedef struct _CMPX_DATA *CMPX_DATA;




typedef struct _CMPX_DATA {
   CMPX_DATA next;
   Function_Ptr routine;
   Integer timeout;
   Integer curtime;
   Integer rfgs[CMPX_MASK_SIZE];
   Integer wfgs[CMPX_MASK_SIZE];
   Integer xfgs[CMPX_MASK_SIZE];
} CMPX_DATA_B;





/************************************************************************/
/*									*/
/*	Tracing definitions						*/
/*									*/
/************************************************************************/


extern	Integer CMPX__tracelvl;

#define TRACE	if (CMPX__tracelvl & CMPX_TRACE_ON) CMPX_trace
#define ITRACE	if (CMPX__tracelvl & CMPX_TRACE_INT) CMPX_trace
#define DTRACE	if (CMPX__tracelvl & CMPX_TRACE_DEBUG) CMPX_trace

#define ERROR(msg) CMPX_trace("Error: msg")
#define ABORT(msg) (CMPX_trace("ABORT: msg"), abort())





/************************************************************************/
/*									*/
/*	Module-local routines						*/
/*									*/
/************************************************************************/


extern	void		CMPX_trace();





/* end of cmpx_local.h */
