/************************************************************************/
/*									*/
/*		cmpx.h							*/
/*									*/
/*	Include file for communications multiplexing			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/





/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define CMPX_MASK_SIZE		1
#define CMPX_MASK_COUNT 	(CMPX_MASK_SIZE*32)




/************************************************************************/
/*									*/
/*	Tracing definitions						*/
/*									*/
/************************************************************************/


					/* trace level bit definitions	*/
#define CMPX_TRACE_DEBUG 4		/*    trace for debugging	*/
#define CMPX_TRACE_INT 2		/*    trace internal calls	*/
#define CMPX_TRACE_ON  1		/*    trace external calls	*/
#define CMPX_TRACE_OFF 0		/*    stop tracing		*/






/************************************************************************/
/*									*/
/*	External routines						*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	void		CMPXtrace();
extern	void		CMPXregister();
extern	void		CMPXregister_timeout();
extern	void		CMPXregister_add();
extern	int		CMPXset_tick();
extern	void		CMPXset_monitor();
extern	void		CMPXclose();
extern	void		CMPXselect();

#else

extern "C" {
	void		CMPXtrace(int);
	void		CMPXregister(int,int *,int *,int * ...);
	void		CMPXregister_timeout(int ...);
	void		CMPXregister_add(int,int *,int *,int * ...);
	int		CMPXset_tick(int);
	void		CMPXset_monitor(...);
	void		CMPXclose(int);
	void		CMPXselect(int);
};

#endif





/* end of cmpx.h */
