%{
/*   index - create a TROFFable index file from the data output by running
**	     the BWE Programmer's Manual macros.
*/

#define INDEXMAXSIZE 10000

static int count = 0;
static int count2 = 0;
static int valid = 0;
static char ipage[64] = {'1','\0'};
static char pageno[64];
static char buf[128];

static char *data[INDEXMAXSIZE];
static char *data2[INDEXMAXSIZE];

extern int strcmp();

%}
L			      [A-Za-z_$]
D			      [0-9]
I			      ({L}({L}|{D})*)
%%
^\@INDEX		      valid = 1;
^\@PAGE" "{D}+                strcpy (ipage, &yytext[6]);
^\@CONTENTS" "[^\n]+\n        {
				 if (count2 >= INDEXMAXSIZE) {
				    fprintf(stderr,
					"index: table of contents too large\n");
				    return 0;
				 }
				 data2[count2] = (char *)malloc(strlen(yytext)-9);
				 strcpy (data2[count2++], &yytext[10]);
			      }
\n			      valid = 0;
{I}", "{D}+"."{D}+            if (valid) {
				 if (count >= INDEXMAXSIZE) {
				    fprintf(stderr,"index: index too large\n");
				    return 0;
				 }
				 data[count] = (char *)malloc(strlen(yytext)+1);
				 strcpy (data[count++], yytext);
			      }
.			      ;
%%
mycmp (str1, str2)
   char **str1, **str2;
{
   char *s1, *s2;

   s1 = *str1;
   s2 = *str2;
   while (*s1 != '\0' && *s2 != '\0') {
      if (*s1 != *s2) {
	 if (*s1 == '_') return -1;
	 if (*s2 == '_') return 1;
	 if (*s1 == '$') return -1;
	 if (*s2 == '$') return 1;
	 if ((*s1 & 0x1f) < (*s2 & 0x1f)) return -1;
	 if ((*s1 & 0x1f) > (*s2 & 0x1f)) return 1;
      }
      s1++;
      s2++;
   }
   return (*s1 - *s2);
}

contents ()
{
   register int i;

   printf("..\n.. CONTENTS\n..\n");
   printf(".ds N CONTENTS\n");
   printf(".nr F 0\n");
   printf(".1c\n");
   for (i=0; i<count2; i++) {
      printf ("%s", data2[i]);
   }
   printf(".(x\n");
   printf(".sp\n");
   printf(".b \"Index Of User Entries\"\n");
   printf(".)x \\nC.1\n");
   printf(".ds Rf Table Of Contents\n");
   printf(".ds D \\*(td\n");
   printf(".af %% i\n");
   printf(".(c\n");
   printf(".ps 12\n");
   printf(".b \"Table Of Contents\"\n");
   printf(".ps 10\n");
   printf(".)c\n");
   printf(".sp 2\n");
   printf(".xp\n");
   printf(".if o .bp\n");
}

yywrap ()
{
   register int i;
   register char last;

   printf("..\n.. CONTENTS and INDEX generated by the 'index' program\n..\n");

   printf(".so /pro/bwe/doc/bwemac.me\n");
   printf(".nr F 1\n");
   printf(".nr C %s\n", ipage);
   printf("..\n.. INDEX\n..\n");
   printf(".ds Rf Index Of User Entries\n");
   printf(".ds N INDEX\n");
   printf(".ds D \\*(td\n");
   printf(".af %% 1\n");
   printf(".(c\n");
   printf(".ps 12\n");
   printf(".b \"Index Of User Entries\"\n");
   printf(".ps 10\n");
   printf(".)c\n");
   printf(".sp 2\n");
   printf(".2c\n");
   printf(".nf\n");

   qsort (data, count, sizeof(data[0]), mycmp);

   last = *data[0] & 0x1f;
   for (i=0; i<count; i++) {
      if (last != (*data[i] & 0x1f)) {	/* space at first letter changes */
	 printf(".sp\n");
	 last = *data[i] & 0x1f;
      }
      printf ("%s\n", data[i]);
   }
   printf(".E\n");

   contents();

   return 1;
}

/* end of index.l */
