/************************************************************************/
/*									*/
/*		biomove.c					       */
/*								       */
/*	BIO routines to handle faked cursor movement		       */
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "bio_local.h"





/************************************************************************/
/*									*/
/*	Local storage							*/
/*									*/
/************************************************************************/


static	BIO_MAP 	previous_map = NULL;
static	Integer 	toplx,topby,toprx,topty;
static	Integer 	deltax,deltay;





/************************************************************************/
/*									*/
/*	Forward Definitions					       */
/*									*/
/************************************************************************/


static			move_simulate();





/************************************************************************/
/*									*/
/*	BIO_move_init -- module initialization				*/
/*									*/
/************************************************************************/


void
BIO_move_init()
{
   ITRACE("BIO_move_init");

   previous_map = NULL;
   ASHinq_size(ASHinq_top(),ASH_SIZE_WINDOW,&toplx,&topby,&toprx,&topty);
   deltax = (toplx < toprx ? 1 : -1);
   deltay = (topby < topty ? 1 : -1);
};





/************************************************************************/
/*									*/
/*	BIO_move_check -- test and handle movement event		*/
/*									*/
/************************************************************************/


void
BIO_move_check(e,w)
   BPIO_EVENT e;
   BIO_WINDATA w;
{
   register BIO_MAP m;

   ITRACE("BIO_move_check 0x%x 0x%x",e,w);

   switch (e->BPIO_class) {
      case BPIO_CLASS_FKEY :
	 m = &(w->BIO_fkey_map[e->BPIO_data]);
	 break;
      case BPIO_CLASS_UP_FKEY :
	 if ((w->BIO_mask.BIO_mask_flags & BIO_MASK_UP_FKEY) == 0) m = NULL;
	 else m = &(w->BIO_up_fkey_map[e->BPIO_data]);
	 break;
      case BPIO_CLASS_SHIFT_FKEY :
	 if ((w->BIO_mask.BIO_mask_flags & BIO_MASK_SHIFT_FKEY) == 0)
	    m = &(w->BIO_fkey_map[e->BPIO_data]);
	 else m = &(w->BIO_shift_fkey_map[e->BPIO_data]);
	 break;
      case BPIO_CLASS_CTRL_FKEY :
	 if ((w->BIO_mask.BIO_mask_flags & BIO_MASK_CTRL_FKEY) == 0)
	    m = &(w->BIO_fkey_map[e->BPIO_data]);
	 else m = &(w->BIO_ctrl_fkey_map[e->BPIO_data]);
	 break;
      case BPIO_CLASS_META_FKEY :
	 if ((w->BIO_mask.BIO_mask_flags & BIO_MASK_META_FKEY) == 0)
	    m = &(w->BIO_fkey_map[e->BPIO_data]);
	 else m = &(w->BIO_meta_fkey_map[e->BPIO_data]);
	 break;
      default :
	 m = NULL;
	 break;
    };

   if (m == NULL ||
	  (w->BIO_mask.BIO_mask_flags & BIO_MASK_FKEY) == 0 ||
	  m->BIO_maptype != BIO_MAP_MOVE) {
      previous_map = NULL;
      return;
    };

   PROTECT;

   move_simulate(e,m->BIO_mapdata.map_misc.v1,m->BIO_mapdata.map_misc.v2,
		    (previous_map == m));

   previous_map = m;

   UNPROTECT;

   return;
};





/************************************************************************/
/*									*/
/*	move_simulate -- simulate the locator device		       */
/*									*/
/************************************************************************/


static
move_simulate(e,mt,v,eqfg)
   BPIO_EVENT e;
   Integer mt;
   Integer v;
   Boolean eqfg;
{
   static Integer delta;
   register Integer x,y;

   DTRACE("move_simulate 0x%x %d %d %d",e,mt,v,eqfg);

   e->BPIO_class = BPIO_CLASS_EVENT;
   e->BPIO_data = BPIO_EVENT_MOVE;

   if (eqfg) delta = MIN(delta+1,BIO_MOVE_MAX);
   else delta = 1;

   switch (mt) {
      case BIO_MOVE_GOTO :
	 x = (v>>16);
	 y = v&0xffff;
	 break;
      case BIO_MOVE_HOME :
	 x = (toplx+toprx)/2;
	 y = (topty+topby)/2;
	 break;
      case BIO_MOVE_VERT :
	 x = e->BPIO_xpos;
	 y = e->BPIO_ypos+deltay*delta*v;
	 break;
      case BIO_MOVE_HORIZ :
	 x = e->BPIO_xpos+deltax*delta*v;
	 y = e->BPIO_ypos;
	 break;
      case BIO_MOVE_DOWN :
	 e->BPIO_class = BPIO_CLASS_MOUSE;
	 e->BPIO_data = BPIO_MOUSE_DATA((1<<v),v);
	 x = e->BPIO_xpos;
	 y = e->BPIO_ypos;
	 break;
      case BIO_MOVE_UP :
	 e->BPIO_class = BPIO_CLASS_UP_MOUSE;
	 e->BPIO_data = BPIO_MOUSE_DATA(0,v);
	 x = e->BPIO_xpos;
	 y = e->BPIO_ypos;
	 break;
      default :
	 x = e->BPIO_xpos;
	 y = e->BPIO_ypos;
	 return;
    };

   if (deltax > 0) {
      if (x < toplx) x = toplx;
      if (x > toprx) x = toprx;
    }
   else {
      if (x > toplx) x = toplx;
      if (x < toprx) x = toprx;
    };

   if (deltay > 0) {
      if (y < topby) y = topby;
      if (y > topty) y = topty;
    }
   else {
      if (y > topby) y = topby;
      if (y < topty) y = topty;
    };

   ASHcursor_move(e->BPIO_window,x,y);

   e->BPIO_xpos = x;
   e->BPIO_ypos = y;
};





/* end of biomove.c */
