/************************************************************************/
/*									*/
/*		biokeys.h						*/
/*									*/
/*	Key definitions for input packages				*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#ifndef BIOKEYS_INCLUDED
#define BIOKEYS_INCLUDED


/************************************************************************/
/*									*/
/*	Ascii base values						*/
/*									*/
/************************************************************************/


#define FKEY_ASCII_FIRST	0
#define FKEY_ASCII_LAST 	127
#define FKEY_META_FIRST 	128
#define FKEY_META_LAST		255
#define FKEY_ASCII_BASE(n)	((n)&0x7f)

#define FKEY_TEST_ASCII(n)  ((n) >= FKEY_ASCII_FIRST && (n) <= FKEY_ASCII_LAST)
#define FKEY_TEST_META(n)   ((n) >= FKEY_META_FIRST && (n) <= FKEY_META_LAST)

#define FKEY_ASCII(n)		(n)
#define FKEY_META(n)		((n)+FKEY_META_FIRST)




/************************************************************************/
/*									*/
/*	Function key base values					*/
/*									*/
/************************************************************************/


#define FKEY_FIRST		(FKEY_META_LAST+1)
#define FKEY_COUNT		64
#define FKEY_FIRST_SHIFT	(FKEY_FIRST+FKEY_COUNT)
#define FKEY_FIRST_CTRL 	(FKEY_FIRST+2*FKEY_COUNT)
#define FKEY_FIRST_UP		(FKEY_FIRST+3*FKEY_COUNT)
#define FKEY_LAST		(FKEY_FIRST+4*FKEY_COUNT-1)
#define FKEY_BASE(n)		((n)&0x3f)

#define FKEY_MOUSE_FIRST	(FKEY_LAST+1)
#define FKEY_MOUSE_COUNT	(1<<4)
#define FKEY_MOUSE_UP_FIRST	(FKEY_MOUSE_FIRST+FKEY_MOUSE_COUNT)
#define FKEY_MOUSE_TAP_FIRST	(FKEY_MOUSE_FIRST+2*FKEY_MOUSE_COUNT)
#define FKEY_MOUSE_LAST 	(FKEY_MOUSE_FIRST+3*FKEY_MOUSE_COUNT-1)



#define FKEY_EVENT_FIRST	(FKEY_MOUSE_LAST+1)
#define FKEY_EVENT_COUNT	16
#define FKEY_EVENT_LAST 	(FKEY_EVENT_FIRST+FKEY_EVENT_COUNT-1)





/************************************************************************/
/*									*/
/*	Tests and values for adjusted keys				*/
/*									*/
/************************************************************************/


#define FKEY(n) 		(FKEY_FIRST+(n))
#define FKEY_SHIFT(n)		(FKEY_FIRST_SHIFT+(n))
#define FKEY_CTRL(n)		(FKEY_FIRST_CTRL+(n))
#define FKEY_UP(n)		(FKEY_FIRST_UP+(n))

#define FKEY_TEST(n)	    ((n) >= FKEY_FIRST && (n) <= FKEY_LAST)
#define FKEY_TEST_PLAIN(n)  ((n) >= FKEY_FIRST && (n) < FKEY_FIRST+FKEY_COUNT)
#define FKEY_TEST_SHIFT(n)  ((n) >= FKEY_FIRST_SHIFT && (n) < FKEY_FIRST_SHIFT+FKEY_COUNT)
#define FKEY_TEST_CTRL(n)   ((n) >= FKEY_FIRST_CTRL && (n) < FKEY_FIRST_CTRL+FKEY_COUNT)
#define FKEY_TEST_UP(n)     ((n) >= FKEY_FIRST_UP && (n) < FKEY_FIRST_UP+FKEY_COUNT)

#define FKEY_MOUSE(n)		(FKEY_MOUSE_FIRST+(n))
#define FKEY_MOUSE_UP(n)	(FKEY_MOUSE_UP_FIRST+(n))
#define FKEY_MOUSE_COMBO(n)	(FKEY_MOUSE_FIRST+(n))
#define FKEY_MOUSE_TAP(n)	(FKEY_MOUSE_TAP_FIRST+(n))
#define FKEY_MOUSE_SHIFT(n)	FKEY_MOUSE((n)+4)
#define FKEY_MOUSE_CTRL(n)	FKEY_MOUSE((n)+8)
#define FKEY_MOUSE_META(n)	FKEY_MOUSE((n)+12)

#define FKEY_TEST_MOUSE(n)	((n) >= FKEY_MOUSE_FIRST && (n) < FKEY_MOUSE_FIRST+FKEY_MOUSE_COUNT)
#define FKEY_TEST_MOUSE_DOWN(n) ((n) >= FKEY_MOUSE_FIRST && (n) < FKEY_MOUSE_FIRST+FKEY_MOUSE_COUNT)
#define FKEY_TEST_MOUSE_UP(n)	((n) >= FKEY_MOUSE_UP_FIRST && (n) < FKEY_MOUSE_UP_FIRST+FKEY_MOUSE_COUNT)
#define FKEY_TEST_MOUSE_TAP(n)	((n) >= FKEY_MOUSE_TAP_FIRST && (n) < FKEY_MOUSE_TAP_FIRST+FKEY_MOUSE_COUNT)

/* note that meta fkeys are mapped to control fkeys */




/************************************************************************/
/*									*/
/*	Events								*/
/*									*/
/************************************************************************/


#define FKEY_EVENT_NONE 	(FKEY_EVENT_FIRST+0)
#define FKEY_EVENT_ENTER	(FKEY_EVENT_FIRST+1)
#define FKEY_EVENT_EXIT 	(FKEY_EVENT_FIRST+2)
#define FKEY_EVENT_MOVE 	(FKEY_EVENT_FIRST+3)
#define FKEY_EVENT_STILL	(FKEY_EVENT_FIRST+4)
#define FKEY_EVENT_ABORT	(FKEY_EVENT_FIRST+5)
#define FKEY_EVENT_REDRAW	(FKEY_EVENT_FIRST+6)
#define FKEY_EVENT_VISIBLE	(FKEY_EVENT_FIRST+7)
#define FKEY_EVENT_INVISIBLE	(FKEY_EVENT_FIRST+8)
#define FKEY_EVENT_VIEW 	(FKEY_EVENT_FIRST+9)
#define FKEY_EVENT_RESIZE	(FKEY_EVENT_FIRST+10)

#define FKEY_TEST_EVENT(n)	((n) >= FKEY_EVENT_FIRST && (n) <= FKEY_EVENT_LAST)





/************************************************************************/
/*									*/
/*	Mouse definitions						*/
/*									*/
/************************************************************************/


#define FKEY_MOUSE_LEFT 	FKEY_MOUSE(0)
#define FKEY_MOUSE_CENTER	FKEY_MOUSE(1)
#define FKEY_MOUSE_RIGHT	FKEY_MOUSE(2)

#define FKEY_MOUSE_LEFT_S	FKEY_MOUSE_SHIFT(0)
#define FKEY_MOUSE_CENTER_S	FKEY_MOUSE_SHIFT(1)
#define FKEY_MOUSE_RIGHT_S	FKEY_MOUSE_SHIFT(2)

#define FKEY_MOUSE_LEFT_C	FKEY_MOUSE_CTRL(0)
#define FKEY_MOUSE_CENTER_C	FKEY_MOUSE_CTRL(1)
#define FKEY_MOUSE_RIGHT_C	FKEY_MOUSE_CTRL(2)

#define FKEY_MOUSE_LEFT_M	FKEY_MOUSE_META(0)
#define FKEY_MOUSE_CENTER_M	FKEY_MOUSE_META(1)
#define FKEY_MOUSE_RIGHT_M	FKEY_MOUSE_META(2)

#define FKEY_MOUSE_LEFT_UP	FKEY_MOUSE_UP(0)
#define FKEY_MOUSE_CENTER_UP	FKEY_MOUSE_UP(1)
#define FKEY_MOUSE_RIGHT_UP	FKEY_MOUSE_UP(2)





/********************************************************************************/
/*										*/
/*	Table of key names							*/
/*										*/
/********************************************************************************/


#ifndef BIO_MAIN
extern	char *		BIO__key_names[];
#else

	char *	BIO__key_names[] = {

"Null", "Control-A", "Control-B", "Control-C", "Control-D", "Control-E", "Control-F",
"Control-G", "Backspace", "Tab", "Line Feed", "Control-K", "Control-L",
"Return", "Control-N", "Control-O", "Control-P", "Control-Q", "Control-R",
"Control-S", "Control-T", "Control-U", "Control-V", "Control-W", "Control-X",
"Control-Y", "Control-Z", "Escape", "Control-\\", "Control-]", "Control-~", "Control-_",
"Space", "!", "\"", "#", "$", "%", "&", "'", "(", ")",
"*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I",
"J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y",
"Z", "[", "\\", "]", "^", "_", "`", "a", "b", "c", "d", "e", "f", "g", "h", "i",
"j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y",
"z", "{", "|", "}", "~", "Delete",

"Meta-Null", "Meta-Control-A", "Meta-Control-B", "Meta-Control-C", "Meta-Control-D",
"Meta-Control-E", "Meta-Control-F", "Meta-Control-G", "Meta-Backspace",
"Meta-Tab", "Meta-Line Feed", "Meta-Control-K", "Meta-Control-L",
"Meta-Return", "Meta-Control-N", "Meta-Control-O", "Meta-Control-P",
"Meta-Control-Q", "Meta-Control-R", "Meta-Control-S", "Meta-Control-T",
"Meta-Control-U", "Meta-Control-V", "Meta-Control-W", "Meta-Control-X",
"Meta-Control-Y", "Meta-Control-Z", "Meta-Escape", "Meta-Control-\\",
"Meta-Control-]", "Meta-Control-~", "Meta-Control-_",
"Meta-Space", "Meta-!", "Meta-\"",
"Meta-#", "Meta-$", "Meta-%", "Meta-&", "Meta-'", "Meta-(", "Meta-)",
"Meta-*", "Meta-+", "Meta-,", "Meta--", "Meta-.", "Meta-/", "Meta-0",
"Meta-1", "Meta-2", "Meta-3", "Meta-4", "Meta-5", "Meta-6", "Meta-7",
"Meta-8", "Meta-9", "Meta-:", "Meta-;", "Meta-<", "Meta-=", "Meta->",
"Meta-?", "Meta-@", "Meta-A", "Meta-B", "Meta-C", "Meta-D", "Meta-E",
"Meta-F", "Meta-G", "Meta-H", "Meta-I", "Meta-J", "Meta-K", "Meta-L",
"Meta-M", "Meta-N", "Meta-O", "Meta-P", "Meta-Q", "Meta-R", "Meta-S",
"Meta-T", "Meta-U", "Meta-V", "Meta-W", "Meta-X", "Meta-Y", "Meta-Z",
"Meta-[", "Meta-\\", "Meta-]", "Meta-^", "Meta-_", "Meta-`", "Meta-a",
"Meta-b", "Meta-c", "Meta-d", "Meta-e", "Meta-f", "Meta-g", "Meta-h",
"Meta-i", "Meta-j", "Meta-k", "Meta-l", "Meta-m", "Meta-n", "Meta-o",
"Meta-p", "Meta-q", "Meta-r", "Meta-s", "Meta-t", "Meta-u", "Meta-v",
"Meta-w", "Meta-x", "Meta-y", "Meta-z", "Meta-{", "Meta-|", "Meta-}",
"Meta-~", "Meta-Delete",

"F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "F11",
"F12", "F13", "F14",
"L1", "L2", "L3", "L4", "L5", "L6", "L7", "L8", "L9", "L10",
"R1", "R2", "R3", "R4", "R5", "R6", "R7", "R8", "R9", "R10",
"R11", "R12", "R13", "R14", "R15",
"HOME", "Left-Arrow", "Up-Arrow", "Right-Arrow", "Down-Arrow",
"PRIOR", "NEXT", "END", "BEGIN", "SELECT", "PRINT", "EXECUTE",
"INSERT", "UNDO", "REDO", "MENU", "FIND", "CANCEL", "HELP",
"BREAK", "PF1", "PF2", "PF3", "PF4",

"Shift-F0", "Shift-F1", "Shift-F2", "Shift-F3", "Shift-F4", "Shift-F5",
"Shift-F6", "Shift-F7", "Shift-F8", "Shift-F9", "Shift-F10", "Shift-F11",
"Shift-F12", "Shift-F13", "Shift-F14", "Shift-L1", "Shift-L2", "Shift-L3",
"Shift-L4", "Shift-L5", "Shift-L6", "Shift-L7", "Shift-L8", "Shift-L9",
"Shift-L10", "Shift-R1", "Shift-R2", "Shift-R3", "Shift-R4", "Shift-R5",
"Shift-R6", "Shift-R7", "Shift-R8", "Shift-R9", "Shift-R10", "Shift-R11",
"Shift-R12", "Shift-R13", "Shift-R14", "Shift-R15", "Shift-HOME",
"Shift-Left-Arrow", "Shift-Up-Arrow", "Shift-Right-Arrow", "Shift-Down-Arrow",
"Shift-PRIOR", "Shift-NEXT", "Shift-END", "Shift-BEGIN", "Shift-SELECT",
"Shift-PRINT", "Shift-EXECUTE", "Shift-INSERT", "Shift-UNDO", "Shift-REDO",
"Shift-MENU", "Shift-FIND", "Shift-CANCEL", "Shift-HELP", "Shift-BREAK",
"Shift-PF1", "Shift-PF2", "Shift-PF3", "Shift-PF4",

"Control-F0", "Control-F1", "Control-F2", "Control-F3", "Control-F4", "Control-F5",
"Control-F6", "Control-F7", "Control-F8", "Control-F9", "Control-F10", "Control-F11",
"Control-F12", "Control-F13", "Control-F14", "Control-L1", "Control-L2", "Control-L3",
"Control-L4", "Control-L5", "Control-L6", "Control-L7", "Control-L8", "Control-L9",
"Control-L10", "Control-R1", "Control-R2", "Control-R3", "Control-R4", "Control-R5",
"Control-R6", "Control-R7", "Control-R8", "Control-R9", "Control-R10", "Control-R11",
"Control-R12", "Control-R13", "Control-R14", "Control-R15", "Control-HOME",
"Control-Left-Arrow", "Control-Up-Arrow", "Control-Right-Arrow", "Control-Down-Arrow",
"Control-PRIOR", "Control-NEXT", "Control-END", "Control-BEGIN", "Control-SELECT",
"Control-PRINT", "Control-EXECUTE", "Control-INSERT", "Control-UNDO", "Control-REDO",
"Control-MENU", "Control-FIND", "Control-CANCEL", "Control-HELP", "Control-BREAK",
"Control-PF1", "Control-PF2", "Control-PF3", "Control-PF4",

"Up-F0", "Up-F1", "Up-F2", "Up-F3", "Up-F4", "Up-F5",
"Up-F6", "Up-F7", "Up-F8", "Up-F9", "Up-F10", "Up-F11",
"Up-F12", "Up-F13", "Up-F14", "Up-L1", "Up-L2", "Up-L3",
"Up-L4", "Up-L5", "Up-L6", "Up-L7", "Up-L8", "Up-L9",
"Up-L10", "Up-R1", "Up-R2", "Up-R3", "Up-R4", "Up-R5",
"Up-R6", "Up-R7", "Up-R8", "Up-R9", "Up-R10", "Up-R11",
"Up-R12", "Up-R13", "Up-R14", "Up-R15", "Up-HOME",
"Up-Left-Arrow", "Up-Up-Arrow", "Up-Right-Arrow", "Up-Down-Arrow",
"Up-PRIOR", "Up-NEXT", "Up-END", "Up-BEGIN", "Up-SELECT",
"Up-PRINT", "Up-EXECUTE", "Up-INSERT", "Up-UNDO", "Up-REDO",
"Up-MENU", "Up-FIND", "Up-CANCEL", "Up-HELP", "Up-BREAK",
"Up-PF1", "Up-PF2", "Up-PF3", "Up-PF4",

"Mouse-left", "Mouse-center", "Mouse-right", "Mouse-X",
"Shift-Mouse-left", "Shift-Mouse-center", "Shift-Mouse-right", "Shift-Mouse-X",
"Control-Mouse-left", "Control-Mouse-center", "Control-Mouse-right", "Control-Mouse-X",
"Meta-Mouse-left", "Meta-Mouse-center", "Meta-Mouse-right", "Meta-Mouse-X",

"Up-Mouse-left", "Up-Mouse-center", "Up-Mouse-right", "Up-Mouse-X",
"Shift-Up-Mouse-left", "Shift-Up-Mouse-center", "Shift-Up-Mouse-right", "Shift-Up-Mouse-X",
"Control-Up-Mouse-left", "Control-Up-Mouse-center", "Control-Up-Mouse-right", "Control-Up-Mouse-X",
"Meta-Up-Mouse-left", "Meta-Up-Mouse-center", "Meta-Up-Mouse-right", "Meta-Up-Mouse-X",

"Tap-left", "Tap-center", "Tap-right", "Tap-X",
"Shift-Tap-left", "Shift-Tap-center", "Shift-Tap-right", "Shift-Tap-X",
"Control-Tap-left", "Control-Tap-center", "Control-Tap-right", "Control-Tap-X",
"Meta-Tap-left", "Meta-Tap-center", "Meta-Tap-right", "Meta-Tap-X",

"Null Event", "Enter Event", "Exit Event", "Move Event", "Still Event",
"Abort Event", "Event 6", "Event 7", "Event 8", "Event 9", "Event 10",
"Event 11", "Event 12", "Event 13", "Event 14", "Event 15",
};

#endif

#endif




/* end of biokeys.h */
