/************************************************************************/
/*									*/
/*		bio_local.h						*/
/*									*/
/*	Local definitions for Brown Input Operations package		*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#define PROT_NAME	ASH__sema
#include <bwethread.h>

#include <ctype.h>
#include <ash.h>
#include <bpio.h>
#include <bio.h>
#include <biokeys.h>
#include <signal.h>
#include <cmpx.h>
#include <DATATYPES.h>




/************************************************************************/
/*									*/
/*	Parameters							*/
/*									*/
/************************************************************************/


#define MAX_QUEUE_SIZE	256
#define TAP_CLICK_INTERVAL   300000
#define ABORT_SIGNAL	SIGINT
#define DEFAULT_CURSOR	ASH_CURSOR_ARROW_UL
#define BIO_SERVER_ENV	"BIO_SERVER"
#define BIO_MOVE_MAX	5

#define TRANSCRIPT_FORMAT	"%d %d (%d,%d) %d\n"





/************************************************************************/
/*									*/
/*	Data structures 						*/
/*									*/
/************************************************************************/


typedef struct _BIO_WINDATA *BIO_WINDATA;
typedef struct _BIO_THREAD  *BIO_THREAD;
typedef struct _BIO_QUEUE   *BIO_QUEUE;
typedef struct _BIO_MAP     *BIO_MAP;
typedef struct _BIO_MASK    *BIO_MASK;



typedef struct _BIO_MASK {
   Integer BIO_mask_flags;
   Integer BIO_fkeys[64/(8*sizeof(Integer))];
} BIO_MASK_B;




typedef struct _BIO_MAP {
   BIO_MAP_TYPE BIO_maptype;
   union {
      String map_string;
      struct {
	 Function_Ptr map_rtn;
	 Integer map_data;
       } map_call;
      Integer map_value;
      struct {
	 Integer v1,v2;
       } map_misc;
    } BIO_mapdata;
} BIO_MAP_B;




typedef struct _BIO_QUEUE {
   Integer BIO_qhead;
   Integer BIO_qtail;
   String BIO_string;
   BPIO_EVENT_B BIO_events[MAX_QUEUE_SIZE];
   BIO_WINDATA BIO_windata[MAX_QUEUE_SIZE];
} BIO_QUEUE_B;



typedef struct _BIO_THREAD {
   BIO_QUEUE BIO_queue;
   THREAD    BIO_thread_id;
   BIO_WINDATA BIO_windata;
   Boolean   BIO_waiting;
   Integer   BIO_last_x;
   Integer   BIO_last_y;
   BPIO_TIME BIO_last_time;
   ASH_WINDOW BIO_last_window;
   SEMAPHORE  BIO_sema;
} BIO_THREAD_B;





typedef struct _BIO_WINDATA {
   BIO_WINDATA BIO_next;
   BIO_MAP_B BIO_ascii_map[128];
   BIO_MAP_B BIO_meta_ascii_map[128];
   BIO_MAP_B BIO_fkey_map[64];
   BIO_MAP_B BIO_shift_fkey_map[64];
   BIO_MAP_B BIO_ctrl_fkey_map[64];
   BIO_MAP_B BIO_meta_fkey_map[64];
   BIO_MAP_B BIO_up_fkey_map[64];
   BIO_MAP_B BIO_event_map[16];
   BIO_MASK_B BIO_mask;
   BIO_THREAD BIO_thread;
   ASH_WINDOW BIO_window;
   Boolean    BIO_cbreak;
} BIO_WINDATA_B;





/************************************************************************/
/*									*/
/*	Tracing definitions						*/
/*									*/
/************************************************************************/


#define ENTER CHECKINIT; if (BIO__debugfg & BIO_TRACE_ON) BIO_trace
#define TRACE if (BIO__debugfg & BIO_TRACE_ON) BIO_trace
#define ITRACE if (BIO__debugfg & BIO_TRACE_INT) BIO_trace
#define DTRACE if (BIO__debugfg & BIO_TRACE_DBG) BIO_trace
#define STRACE if (BIO__debugfg & BIO_TRACE_SPC) BIO_trace
#define ERROR(m) BIO_error(m)
#define FATAL(m) { ERROR(m); ABORT; }
#define ABORT	abort()
#define CHECKINIT if (!BIO__inited_flag) BIOinit()






/************************************************************************/
/*									*/
/*	Module storage							*/
/*									*/
/************************************************************************/


extern	Integer 	BIO__debugfg;
extern	Boolean 	BIO__inited_flag;





/************************************************************************/
/*									*/
/*	Module-local functions						*/
/*									*/
/************************************************************************/


						/* biowork.c		*/
extern	void		BIO_error();
extern	void		BIO_trace();

						/* biomove.c		*/
extern	void		BIO_move_init();
extern	void		BIO_move_check();





/* end of bio_local.h */

