/************************************************************************/
/*									*/
/*		bio.h							*/
/*									*/
/*	Definitions for Brown Input Operations module			*/
/*									*/
/************************************************************************/
/*	Copyright 1989 Brown University -- Steven P. Reiss		*/


#include "ash.h"




/************************************************************************/
/*									*/
/*	Event type							*/
/*									*/
/************************************************************************/


typedef int		BIO_EVENT;





/************************************************************************/
/*									*/
/*	Mapping type definitions					*/
/*									*/
/************************************************************************/


typedef enum {
   BIO_MAP_DEFAULT,
   BIO_MAP_STRING,
   BIO_MAP_ACTION,
   BIO_MAP_VALUE,
   BIO_MAP_MOVE,
   BIO_MAP_NONE,
   BIO_MAP_ABORT,
   BIO_MAP_WINACT,
} BIO_MAP_TYPE;



#define BIO_MOVE_HOME	0
#define BIO_MOVE_HORIZ	1
#define BIO_MOVE_VERT	2
#define BIO_MOVE_GOTO	3
#define BIO_MOVE_UP	4
#define BIO_MOVE_DOWN	5





/************************************************************************/
/*									*/
/*	Input mask definitions						*/
/*									*/
/************************************************************************/


#define BIO_MASK_ASCII		0x00000001	/* allow ascii chars	*/
#define BIO_MASK_META		0x00000002	/* allow meta ascii	*/
#define BIO_MASK_FKEY		0x00000004	/* allow function keys	*/
#define BIO_MASK_SHIFT_FKEY	0x00000008	/* allow shift-fkeys	*/
#define BIO_MASK_CTRL_FKEY	0x00000010	/* allow ctrl-fkeys	*/
#define BIO_MASK_META_FKEY	0x00000020	/* allow meta-fkeys	*/
#define BIO_MASK_UP_FKEY	0x00000040	/* allow up-fkeys	*/
#define BIO_MASK_MOVE		0x00000080	/* report mouse moving	*/
#define BIO_MASK_MOVE_DOWN	0x00000100	/* report mouse w/ btn	*/
#define BIO_MASK_STILL		0x00000200	/* report mouse still	*/
#define BIO_MASK_STILL_DOWN	0x00000400	/* report mouse still	*/
#define BIO_MASK_BUTTON 	0x00000800	/* report mouse btns	*/
#define BIO_MASK_BUTTON_UP	0x00001000	/* report mouse btn up	*/
#define BIO_MASK_TAP_BUTTON	0x00002000	/* report button taps	*/
#define BIO_MASK_OR_BUTTON	0x00004000	/* report ORed buttons	*/
#define BIO_MASK_WINDOW_ENTER	0x00008000	/* report window entry	*/
#define BIO_MASK_WINDOW_EXIT	0x00010000	/* report window exit	*/
#define BIO_MASK_SHIFT_BUTTON	0x00020000	/* extra mouse buttons	*/
#define BIO_MASK_REDRAW 	0x00040000	/* redraw events	*/
#define BIO_MASK_VISIBLE	0x00080000	/* visible/invisible	*/
#define BIO_MASK_VIEW		0x00100000	/* view/resize		*/



#define BIO_MASK_DEFAULT	(BIO_MASK_ASCII | BIO_MASK_META | BIO_MASK_FKEY | \
				 BIO_MASK_SHIFT_FKEY | BIO_MASK_CTRL_FKEY | \
				 BIO_MASK_META_FKEY | BIO_MASK_MOVE_DOWN | \
				 BIO_MASK_BUTTON | BIO_MASK_BUTTON_UP | \
				 BIO_MASK_TAP_BUTTON | BIO_MASK_SHIFT_BUTTON | \
				 BIO_MASK_REDRAW | BIO_MASK_VISIBLE | BIO_MASK_VIEW)





/************************************************************************/
/*									*/
/*	Tracing values							*/
/*									*/
/************************************************************************/


#define BIO_TRACE_DBG 4 		/*    trace for debugging	*/
#define BIO_TRACE_INT 2 		/*    trace internal calls	*/
#define BIO_TRACE_ON  1 		/*    trace external calls	*/
#define BIO_TRACE_OFF 0 		/*    stop tracing		*/





/************************************************************************/
/*									*/
/*	External entrys 						*/
/*									*/
/************************************************************************/


#ifndef __cplusplus

extern	void		BIOthread_init();
extern	void		BIOinit();
extern	void		BIOtrace();
extern	BIO_EVENT	BIOnext_wait();
extern	BIO_EVENT	BIOnext();
extern	int		BIOpeek();
extern	ASH_WINDOW	BIOinq_window();
extern	void		BIOinq_position();
extern	void		BIOinq_time();
extern	int		BIOpoll();
extern	void		BIOtrack();
extern	void		BIOnew_input_window();
extern	void		BIOremove_window();
extern	void		BIOset_mapping();
extern	void		BIOset_mask();
extern	void		BIOset_cbreak();
extern	int		BIOset_cursor();
extern	ASH_CURSOR	BIOset_cursor_pattern();
extern	ASH_CURSOR	BIOset_cursor_standard();
extern	int		BIOset_window_thread();
extern	ASH_WINDOW	BIOinq_top_window();
extern	ASH_WINDOW	BIOgrab_io();
extern	void		BIOflush();
extern	void		BIOflush_same();
extern	void		BIOtranscript();
extern	void		BIOinput_transcript();

#else

extern "C" {
	void		BIOthread_init();
	void		BIOinit();
	void		BIOtrace(int);
	BIO_EVENT	BIOnext_wait();
	BIO_EVENT	BIOnext();
	int		BIOpeek();
	ASH_WINDOW	BIOinq_window();
	void		BIOinq_position(int *,int *);
	void		BIOinq_time(int *,int *);
	int		BIOpoll();
	void		BIOtrack();
	void		BIOnew_input_window(ASH_WINDOW);
	void		BIOremove_window(ASH_WINDOW);
	void		BIOset_mapping(ASH_WINDOW,int,BIO_MAP_TYPE ...);
	void		BIOset_mask(ASH_WINDOW,int,int *);
	void		BIOset_cbreak(ASH_WINDOW,int);
	int		BIOset_cursor(ASH_WINDOW,int);
	ASH_CURSOR	BIOset_cursor_pattern(ASH_WINDOW,ASH_CURSOR);
	ASH_CURSOR	BIOset_cursor_standard(ASH_WINDOW,ASH_CURSOR_ID);
	int		BIOset_window_thread(ASH_WINDOW ...);
	ASH_WINDOW	BIOinq_top_window();
	ASH_WINDOW	BIOgrab_io(ASH_WINDOW);
	void		BIOflush(int);
	void		BIOflush_same(int,int);
	void		BIOtranscript(char *);
	void		BIOinput_transcript(char *);
};

#endif




/* end of bio.h */

